/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.security.x509.tls.impl;

import java.util.ArrayList;
import java.util.Iterator;
import net.shibboleth.utilities.java.support.logic.ConstraintViolationException;
import net.shibboleth.utilities.java.support.resolver.CriteriaSet;
import net.shibboleth.utilities.java.support.resolver.Criterion;
import net.shibboleth.utilities.java.support.resolver.ResolverException;
import org.opensaml.security.credential.CredentialResolver;
import org.opensaml.security.credential.impl.StaticCredentialResolver;
import org.opensaml.security.trust.TrustEngine;
import org.opensaml.security.trust.impl.ExplicitX509CertificateTrustEngine;
import org.opensaml.security.x509.X509Credential;
import org.opensaml.security.x509.tls.CertificateNameOptions;
import org.opensaml.security.x509.tls.ClientTLSValidationConfiguration;
import org.opensaml.security.x509.tls.ClientTLSValidationConfigurationCriterion;
import org.opensaml.security.x509.tls.ClientTLSValidationParameters;
import org.opensaml.security.x509.tls.impl.BasicClientTLSValidationConfiguration;
import org.opensaml.security.x509.tls.impl.BasicClientTLSValidationParametersResolver;
import org.testng.Assert;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public class BasicClientTLSValidationParametersResolverTest {
    private BasicClientTLSValidationParametersResolver resolver;
    private CriteriaSet criteriaSet;
    private ClientTLSValidationConfigurationCriterion criterion;
    private BasicClientTLSValidationConfiguration config1;
    private BasicClientTLSValidationConfiguration config2;
    private BasicClientTLSValidationConfiguration config3;
    private TrustEngine<? super X509Credential> controlTrustEngine1;
    private TrustEngine<? super X509Credential> controlTrustEngine2;
    private TrustEngine<? super X509Credential> controlTrustEngine3;
    private CertificateNameOptions controlNameOpts1;
    private CertificateNameOptions controlNameOpts2;
    private CertificateNameOptions controlNameOpts3;

    @BeforeClass
    public void buildTrustEnginesAndNameOpts() {
        StaticCredentialResolver credResolver = new StaticCredentialResolver(new ArrayList());
        this.controlTrustEngine1 = new ExplicitX509CertificateTrustEngine((CredentialResolver)credResolver);
        this.controlTrustEngine2 = new ExplicitX509CertificateTrustEngine((CredentialResolver)credResolver);
        this.controlTrustEngine3 = new ExplicitX509CertificateTrustEngine((CredentialResolver)credResolver);
        this.controlNameOpts1 = new CertificateNameOptions();
        this.controlNameOpts2 = new CertificateNameOptions();
        this.controlNameOpts3 = new CertificateNameOptions();
    }

    @BeforeMethod
    public void setUp() {
        this.resolver = new BasicClientTLSValidationParametersResolver();
        this.config1 = new BasicClientTLSValidationConfiguration();
        this.config2 = new BasicClientTLSValidationConfiguration();
        this.config3 = new BasicClientTLSValidationConfiguration();
        this.criterion = new ClientTLSValidationConfigurationCriterion(new ClientTLSValidationConfiguration[]{this.config1, this.config2, this.config3});
        this.criteriaSet = new CriteriaSet(new Criterion[]{this.criterion});
    }

    @Test
    public void testResolveTrustEngine() {
        TrustEngine trustEngine = this.resolver.resolveTrustEngine(this.criteriaSet);
        Assert.assertNull((Object)trustEngine);
        this.config1.setX509TrustEngine(this.controlTrustEngine1);
        this.config2.setX509TrustEngine(this.controlTrustEngine2);
        this.config3.setX509TrustEngine(this.controlTrustEngine3);
        trustEngine = this.resolver.resolveTrustEngine(this.criteriaSet);
        Assert.assertTrue((trustEngine == this.controlTrustEngine1 ? 1 : 0) != 0);
        this.config1.setX509TrustEngine(null);
        trustEngine = this.resolver.resolveTrustEngine(this.criteriaSet);
        Assert.assertTrue((trustEngine == this.controlTrustEngine2 ? 1 : 0) != 0);
        this.config2.setX509TrustEngine(null);
        trustEngine = this.resolver.resolveTrustEngine(this.criteriaSet);
        Assert.assertTrue((trustEngine == this.controlTrustEngine3 ? 1 : 0) != 0);
    }

    @Test
    public void testResolveNameOptions() {
        CertificateNameOptions nameOpts = this.resolver.resolveNameOptions(this.criteriaSet);
        Assert.assertNull((Object)nameOpts);
        this.config1.setCertificateNameOptions(this.controlNameOpts1);
        this.config2.setCertificateNameOptions(this.controlNameOpts2);
        this.config3.setCertificateNameOptions(this.controlNameOpts3);
        nameOpts = this.resolver.resolveNameOptions(this.criteriaSet);
        Assert.assertTrue((nameOpts == this.controlNameOpts1 ? 1 : 0) != 0);
        this.config1.setCertificateNameOptions(null);
        nameOpts = this.resolver.resolveNameOptions(this.criteriaSet);
        Assert.assertTrue((nameOpts == this.controlNameOpts2 ? 1 : 0) != 0);
        this.config2.setCertificateNameOptions(null);
        nameOpts = this.resolver.resolveNameOptions(this.criteriaSet);
        Assert.assertTrue((nameOpts == this.controlNameOpts3 ? 1 : 0) != 0);
    }

    @Test
    public void testResolve() throws ResolverException {
        this.config1.setX509TrustEngine(this.controlTrustEngine1);
        this.config1.setCertificateNameOptions(this.controlNameOpts1);
        Iterable paramsIter = this.resolver.resolve(this.criteriaSet);
        Assert.assertNotNull((Object)paramsIter);
        Iterator iterator = paramsIter.iterator();
        Assert.assertNotNull(iterator);
        Assert.assertTrue((boolean)iterator.hasNext());
        ClientTLSValidationParameters params = (ClientTLSValidationParameters)iterator.next();
        Assert.assertNotNull((Object)params);
        Assert.assertTrue((params.getX509TrustEngine() == this.controlTrustEngine1 ? 1 : 0) != 0);
        Assert.assertTrue((params.getCertificateNameOptions() == this.controlNameOpts1 ? 1 : 0) != 0);
        Assert.assertFalse((boolean)iterator.hasNext());
    }

    @Test
    public void testResolveSingle() throws ResolverException {
        this.config1.setX509TrustEngine(this.controlTrustEngine1);
        this.config1.setCertificateNameOptions(this.controlNameOpts1);
        ClientTLSValidationParameters params = this.resolver.resolveSingle(this.criteriaSet);
        Assert.assertNotNull((Object)params);
        Assert.assertTrue((params.getX509TrustEngine() == this.controlTrustEngine1 ? 1 : 0) != 0);
        Assert.assertTrue((params.getCertificateNameOptions() == this.controlNameOpts1 ? 1 : 0) != 0);
    }

    @Test(expectedExceptions={ConstraintViolationException.class})
    public void testNullCriteriaSet() throws ResolverException {
        this.resolver.resolve(null);
    }

    @Test(expectedExceptions={ConstraintViolationException.class})
    public void testAbsentCriterion() throws ResolverException {
        this.resolver.resolve(new CriteriaSet());
    }
}

