/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.security.x509.tls.impl;

import java.io.IOException;
import java.io.InputStream;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.Collection;
import net.shibboleth.utilities.java.support.resolver.CriteriaSet;
import org.opensaml.security.SecurityException;
import org.opensaml.security.testing.MockTrustEngine;
import org.opensaml.security.trust.TrustEngine;
import org.opensaml.security.x509.X509Support;
import org.opensaml.security.x509.tls.impl.ThreadLocalX509TrustEngineContext;
import org.opensaml.security.x509.tls.impl.ThreadLocalX509TrustManager;
import org.testng.Assert;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public class ThreadLocalX509TrustManagerTest {
    private ThreadLocalX509TrustManager trustManager = new ThreadLocalX509TrustManager();
    private X509Certificate[] chain;
    private CriteriaSet criteria;

    @BeforeClass
    public void beforeClass() throws CertificateException, IOException {
        try (InputStream is = this.getClass().getResourceAsStream("/data/certificate.pem");){
            Collection certs = X509Support.decodeCertificates((InputStream)is);
            this.chain = (X509Certificate[])certs.stream().toArray(X509Certificate[]::new);
        }
    }

    @BeforeMethod
    public void beforeMethod() {
        ThreadLocalX509TrustEngineContext.clearCurrent();
        this.criteria = new CriteriaSet();
    }

    @AfterMethod
    public void afterMethod() {
        ThreadLocalX509TrustEngineContext.clearCurrent();
    }

    @Test
    public void trusted() throws CertificateException {
        ThreadLocalX509TrustEngineContext.loadCurrent((TrustEngine)new MockTrustEngine(true), (CriteriaSet)this.criteria, (Boolean)true);
        this.trustManager.checkServerTrusted(this.chain, "RSA");
        Assert.assertTrue((boolean)ThreadLocalX509TrustEngineContext.getTrusted());
    }

    @Test
    public void notTrusted() throws CertificateException {
        ThreadLocalX509TrustEngineContext.loadCurrent((TrustEngine)new MockTrustEngine(false), (CriteriaSet)this.criteria, (Boolean)true);
        try {
            this.trustManager.checkServerTrusted(this.chain, "RSA");
            Assert.fail((String)"Trust manager should have thrown");
        }
        catch (CertificateException e) {
            Assert.assertFalse((boolean)ThreadLocalX509TrustEngineContext.getTrusted());
        }
    }

    @Test
    public void notTrustedNotFatal() throws CertificateException {
        ThreadLocalX509TrustEngineContext.loadCurrent((TrustEngine)new MockTrustEngine(false), (CriteriaSet)this.criteria, (Boolean)false);
        this.trustManager.checkServerTrusted(this.chain, "RSA");
        Assert.assertFalse((boolean)ThreadLocalX509TrustEngineContext.getTrusted());
    }

    @Test
    public void trustEngineThrowsSecurityException() throws CertificateException {
        ThreadLocalX509TrustEngineContext.loadCurrent((TrustEngine)new MockTrustEngine((Throwable)new SecurityException()), (CriteriaSet)this.criteria, (Boolean)true);
        try {
            this.trustManager.checkServerTrusted(this.chain, "RSA");
            Assert.fail((String)"Trust manager should have thrown");
        }
        catch (CertificateException e) {
            Assert.assertFalse((boolean)ThreadLocalX509TrustEngineContext.getTrusted());
        }
    }

    @Test
    public void trustEngineThrowsSecurityExceptionNotFatal() throws CertificateException {
        ThreadLocalX509TrustEngineContext.loadCurrent((TrustEngine)new MockTrustEngine((Throwable)new SecurityException()), (CriteriaSet)this.criteria, (Boolean)false);
        this.trustManager.checkServerTrusted(this.chain, "RSA");
        Assert.assertFalse((boolean)ThreadLocalX509TrustEngineContext.getTrusted());
    }

    @Test
    public void trustEngineThrowsRuntimeException() throws CertificateException {
        ThreadLocalX509TrustEngineContext.loadCurrent((TrustEngine)new MockTrustEngine((Throwable)new RuntimeException()), (CriteriaSet)this.criteria, (Boolean)true);
        try {
            this.trustManager.checkServerTrusted(this.chain, "RSA");
            Assert.fail((String)"Trust manager should have thrown");
        }
        catch (CertificateException e) {
            Assert.assertFalse((boolean)ThreadLocalX509TrustEngineContext.getTrusted());
        }
    }

    @Test
    public void trustEngineThrowsRuntimeExceptionNotFatal() throws CertificateException {
        ThreadLocalX509TrustEngineContext.loadCurrent((TrustEngine)new MockTrustEngine((Throwable)new RuntimeException()), (CriteriaSet)this.criteria, (Boolean)false);
        this.trustManager.checkServerTrusted(this.chain, "RSA");
        Assert.assertFalse((boolean)ThreadLocalX509TrustEngineContext.getTrusted());
    }

    @Test
    public void threadLocalNotLoaded() throws CertificateException {
        try {
            this.trustManager.checkServerTrusted(this.chain, "RSA");
            Assert.fail((String)"Trust manager should have thrown");
        }
        catch (CertificateException e) {
            Assert.assertNull((Object)ThreadLocalX509TrustEngineContext.getTrusted());
        }
    }

    @Test(expectedExceptions={IllegalArgumentException.class})
    public void nullChain() throws CertificateException {
        ThreadLocalX509TrustEngineContext.loadCurrent((TrustEngine)new MockTrustEngine(true), (CriteriaSet)this.criteria, (Boolean)true);
        this.trustManager.checkServerTrusted(null, "RSA");
    }

    @Test(expectedExceptions={IllegalArgumentException.class})
    public void emptyChain() throws CertificateException {
        ThreadLocalX509TrustEngineContext.loadCurrent((TrustEngine)new MockTrustEngine(true), (CriteriaSet)this.criteria, (Boolean)true);
        this.trustManager.checkServerTrusted(new X509Certificate[0], "RSA");
    }

    @Test(expectedExceptions={IllegalArgumentException.class})
    public void nullAuthType() throws CertificateException {
        ThreadLocalX509TrustEngineContext.loadCurrent((TrustEngine)new MockTrustEngine(true), (CriteriaSet)this.criteria, (Boolean)true);
        this.trustManager.checkServerTrusted(this.chain, null);
    }

    @Test(expectedExceptions={IllegalArgumentException.class})
    public void emptyAuthType() throws CertificateException {
        ThreadLocalX509TrustEngineContext.loadCurrent((TrustEngine)new MockTrustEngine(true), (CriteriaSet)this.criteria, (Boolean)true);
        this.trustManager.checkServerTrusted(this.chain, "");
    }
}

