/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.soap.soap11.encoder.http.impl;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.util.List;
import javax.servlet.http.HttpServletResponse;
import net.shibboleth.utilities.java.support.component.ComponentInitializationException;
import net.shibboleth.utilities.java.support.primitive.NonnullSupplier;
import net.shibboleth.utilities.java.support.xml.XMLParserException;
import org.opensaml.core.testing.XMLObjectBaseTestCase;
import org.opensaml.core.xml.XMLObject;
import org.opensaml.core.xml.XMLObjectBuilder;
import org.opensaml.core.xml.io.Unmarshaller;
import org.opensaml.core.xml.io.UnmarshallingException;
import org.opensaml.core.xml.schema.XSAny;
import org.opensaml.messaging.context.MessageContext;
import org.opensaml.messaging.encoder.MessageEncodingException;
import org.opensaml.soap.messaging.SOAPMessagingSupport;
import org.opensaml.soap.messaging.context.SOAP11Context;
import org.opensaml.soap.soap11.Body;
import org.opensaml.soap.soap11.Envelope;
import org.opensaml.soap.soap11.Fault;
import org.opensaml.soap.soap11.FaultCode;
import org.opensaml.soap.soap11.FaultString;
import org.opensaml.soap.soap11.Header;
import org.opensaml.soap.soap11.encoder.http.impl.HTTPSOAP11Encoder;
import org.opensaml.soap.util.SOAPSupport;
import org.opensaml.soap.wsaddressing.Action;
import org.springframework.mock.web.MockHttpServletResponse;
import org.testng.Assert;
import org.testng.annotations.Test;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xmlunit.builder.DiffBuilder;
import org.xmlunit.diff.Diff;

public class HTTPSOAP11EncoderTest
extends XMLObjectBaseTestCase {
    @Test
    public void testBasicEncodingAsPayload() throws ComponentInitializationException, MessageEncodingException, UnsupportedEncodingException, XMLParserException, UnmarshallingException {
        XMLObjectBuilder xsAnyBuilder = this.getBuilder(XSAny.TYPE_NAME);
        XSAny payload = (XSAny)xsAnyBuilder.buildObject("http://example.org/soap/ns/message", "GetLastTradePriceResponse", "m");
        XSAny price = (XSAny)xsAnyBuilder.buildObject("http://example.org/soap/ns/message", "Price", "m");
        price.setTextContent("34.5");
        payload.getUnknownXMLObjects().add(price);
        MessageContext messageContext = new MessageContext();
        messageContext.setMessage((Object)payload);
        final MockHttpServletResponse response = new MockHttpServletResponse();
        HTTPSOAP11Encoder encoder = new HTTPSOAP11Encoder();
        encoder.setMessageContext(messageContext);
        encoder.setHttpServletResponseSupplier((NonnullSupplier)new NonnullSupplier<HttpServletResponse>(){

            public MockHttpServletResponse get() {
                return response;
            }
        });
        encoder.initialize();
        encoder.prepareContext();
        encoder.encode();
        Assert.assertEquals((String)response.getContentType(), (String)"text/xml;charset=UTF-8", (String)"Unexpected content type");
        Assert.assertEquals((String)"UTF-8", (String)response.getCharacterEncoding(), (String)"Unexpected character encoding");
        Assert.assertEquals((String)response.getHeader("Cache-control"), (String)"no-cache, no-store", (String)"Unexpected cache controls");
        Assert.assertEquals((String)response.getHeader("SOAPAction"), (String)"");
        Assert.assertEquals((int)response.getStatus(), (int)200);
        Envelope encodedEnv = (Envelope)this.parseUnmarshallResourceByteArray(response.getContentAsByteArray(), false);
        String soapMessage = "/org/opensaml/soap/soap11/SOAPNoHeaders.xml";
        Envelope controlEnv = (Envelope)this.parseUnmarshallResource(soapMessage, false);
        Diff diff = DiffBuilder.compare((Object)controlEnv.getDOM()).withTest((Object)encodedEnv.getDOM()).checkForIdentical().ignoreWhitespace().build();
        Assert.assertFalse((boolean)diff.hasDifferences(), (String)diff.toString());
    }

    @Test
    public void testBasicEncodingAsSOAPEnvelope() throws ComponentInitializationException, MessageEncodingException, UnsupportedEncodingException, XMLParserException, UnmarshallingException {
        Envelope envelope = (Envelope)this.buildXMLObject(Envelope.DEFAULT_ELEMENT_NAME);
        Body body = (Body)this.buildXMLObject(Body.DEFAULT_ELEMENT_NAME);
        envelope.setBody(body);
        XMLObjectBuilder xsAnyBuilder = this.getBuilder(XSAny.TYPE_NAME);
        XSAny payload = (XSAny)xsAnyBuilder.buildObject("http://example.org/soap/ns/message", "GetLastTradePriceResponse", "m");
        XSAny price = (XSAny)xsAnyBuilder.buildObject("http://example.org/soap/ns/message", "Price", "m");
        price.setTextContent("34.5");
        payload.getUnknownXMLObjects().add(price);
        body.getUnknownXMLObjects().add(payload);
        MessageContext messageContext = new MessageContext();
        messageContext.setMessage((Object)envelope);
        final MockHttpServletResponse response = new MockHttpServletResponse();
        HTTPSOAP11Encoder encoder = new HTTPSOAP11Encoder();
        encoder.setMessageContext(messageContext);
        encoder.setHttpServletResponseSupplier((NonnullSupplier)new NonnullSupplier<HttpServletResponse>(){

            public MockHttpServletResponse get() {
                return response;
            }
        });
        encoder.initialize();
        encoder.prepareContext();
        encoder.encode();
        Assert.assertEquals((String)response.getContentType(), (String)"text/xml;charset=UTF-8", (String)"Unexpected content type");
        Assert.assertEquals((String)"UTF-8", (String)response.getCharacterEncoding(), (String)"Unexpected character encoding");
        Assert.assertEquals((String)response.getHeader("Cache-control"), (String)"no-cache, no-store", (String)"Unexpected cache controls");
        Assert.assertEquals((String)response.getHeader("SOAPAction"), (String)"");
        Assert.assertEquals((int)response.getStatus(), (int)200);
        Envelope encodedEnv = (Envelope)this.parseUnmarshallResourceByteArray(response.getContentAsByteArray(), false);
        String soapMessage = "/org/opensaml/soap/soap11/SOAPNoHeaders.xml";
        Envelope controlEnv = (Envelope)this.parseUnmarshallResource(soapMessage, false);
        Diff diff = DiffBuilder.compare((Object)controlEnv.getDOM()).withTest((Object)encodedEnv.getDOM()).checkForIdentical().ignoreWhitespace().build();
        Assert.assertFalse((boolean)diff.hasDifferences(), (String)diff.toString());
    }

    @Test
    public void testEncodingAsPayloadWithHeader() throws ComponentInitializationException, MessageEncodingException, UnsupportedEncodingException, XMLParserException, UnmarshallingException {
        Envelope envelope = (Envelope)this.buildXMLObject(Envelope.DEFAULT_ELEMENT_NAME);
        Header header = (Header)this.buildXMLObject(Header.DEFAULT_ELEMENT_NAME);
        envelope.setHeader(header);
        XMLObjectBuilder xsAnyBuilder = this.getBuilder(XSAny.TYPE_NAME);
        XSAny transactionHeader = (XSAny)xsAnyBuilder.buildObject("http://example.org/soap/ns/transaction", "Transaction", "t");
        SOAPSupport.addSOAP11MustUnderstandAttribute((XMLObject)transactionHeader, (boolean)true);
        transactionHeader.setTextContent("5");
        header.getUnknownXMLObjects().add(transactionHeader);
        XSAny payload = (XSAny)xsAnyBuilder.buildObject("http://example.org/soap/ns/message", "GetLastTradePriceResponse", "m");
        XSAny price = (XSAny)xsAnyBuilder.buildObject("http://example.org/soap/ns/message", "Price", "m");
        price.setTextContent("34.5");
        payload.getUnknownXMLObjects().add(price);
        MessageContext messageContext = new MessageContext();
        messageContext.setMessage((Object)payload);
        ((SOAP11Context)messageContext.getSubcontext(SOAP11Context.class, true)).setEnvelope(envelope);
        final MockHttpServletResponse response = new MockHttpServletResponse();
        HTTPSOAP11Encoder encoder = new HTTPSOAP11Encoder();
        encoder.setMessageContext(messageContext);
        encoder.setHttpServletResponseSupplier((NonnullSupplier)new NonnullSupplier<HttpServletResponse>(){

            public MockHttpServletResponse get() {
                return response;
            }
        });
        encoder.initialize();
        encoder.prepareContext();
        encoder.encode();
        Assert.assertEquals((String)response.getContentType(), (String)"text/xml;charset=UTF-8", (String)"Unexpected content type");
        Assert.assertEquals((String)"UTF-8", (String)response.getCharacterEncoding(), (String)"Unexpected character encoding");
        Assert.assertEquals((String)response.getHeader("Cache-control"), (String)"no-cache, no-store", (String)"Unexpected cache controls");
        Assert.assertEquals((String)response.getHeader("SOAPAction"), (String)"");
        Assert.assertEquals((int)response.getStatus(), (int)200);
        Envelope encodedEnv = (Envelope)this.parseUnmarshallResourceByteArray(response.getContentAsByteArray(), false);
        String soapMessage = "/org/opensaml/soap/soap11/SOAPHeaderMustUnderstand.xml";
        Envelope controlEnv = (Envelope)this.parseUnmarshallResource(soapMessage, false);
        Diff diff = DiffBuilder.compare((Object)controlEnv.getDOM()).withTest((Object)encodedEnv.getDOM()).checkForIdentical().ignoreWhitespace().build();
        Assert.assertFalse((boolean)diff.hasDifferences(), (String)diff.toString());
    }

    @Test
    public void testEncodingWithAction() throws ComponentInitializationException, MessageEncodingException, UnsupportedEncodingException, XMLParserException, UnmarshallingException {
        Envelope envelope = (Envelope)this.buildXMLObject(Envelope.DEFAULT_ELEMENT_NAME);
        Body body = (Body)this.buildXMLObject(Body.DEFAULT_ELEMENT_NAME);
        envelope.setBody(body);
        Header header = (Header)this.buildXMLObject(Header.DEFAULT_ELEMENT_NAME);
        envelope.setHeader(header);
        Action action = (Action)this.buildXMLObject(Action.ELEMENT_NAME);
        action.setURI("urn:test:soap:action");
        header.getUnknownXMLObjects().add(action);
        XMLObjectBuilder xsAnyBuilder = this.getBuilder(XSAny.TYPE_NAME);
        XSAny payload = (XSAny)xsAnyBuilder.buildObject("http://example.org/soap/ns/message", "GetLastTradePriceResponse", "m");
        XSAny price = (XSAny)xsAnyBuilder.buildObject("http://example.org/soap/ns/message", "Price", "m");
        price.setTextContent("34.5");
        payload.getUnknownXMLObjects().add(price);
        body.getUnknownXMLObjects().add(payload);
        MessageContext messageContext = new MessageContext();
        messageContext.setMessage((Object)envelope);
        final MockHttpServletResponse response = new MockHttpServletResponse();
        HTTPSOAP11Encoder encoder = new HTTPSOAP11Encoder();
        encoder.setMessageContext(messageContext);
        encoder.setHttpServletResponseSupplier((NonnullSupplier)new NonnullSupplier<HttpServletResponse>(){

            public MockHttpServletResponse get() {
                return response;
            }
        });
        encoder.initialize();
        encoder.prepareContext();
        encoder.encode();
        Assert.assertEquals((String)response.getContentType(), (String)"text/xml;charset=UTF-8", (String)"Unexpected content type");
        Assert.assertEquals((String)"UTF-8", (String)response.getCharacterEncoding(), (String)"Unexpected character encoding");
        Assert.assertEquals((String)response.getHeader("Cache-control"), (String)"no-cache, no-store", (String)"Unexpected cache controls");
        Assert.assertEquals((int)response.getStatus(), (int)200);
        Assert.assertEquals((String)response.getHeader("SOAPAction"), (String)"urn:test:soap:action");
    }

    @Test
    public void testFaultAsMessage() throws ComponentInitializationException, MessageEncodingException, XMLParserException, UnmarshallingException {
        Fault fault = (Fault)this.buildXMLObject(Fault.DEFAULT_ELEMENT_NAME);
        FaultCode faultCode = (FaultCode)this.buildXMLObject(FaultCode.DEFAULT_ELEMENT_NAME);
        faultCode.setValue(FaultCode.SERVER);
        fault.setCode(faultCode);
        FaultString faultString = (FaultString)this.buildXMLObject(FaultString.DEFAULT_ELEMENT_NAME);
        faultString.setValue("Something bad happened");
        fault.setMessage(faultString);
        MessageContext messageContext = new MessageContext();
        messageContext.setMessage((Object)fault);
        final MockHttpServletResponse response = new MockHttpServletResponse();
        HTTPSOAP11Encoder encoder = new HTTPSOAP11Encoder();
        encoder.setMessageContext(messageContext);
        encoder.setHttpServletResponseSupplier((NonnullSupplier)new NonnullSupplier<HttpServletResponse>(){

            public MockHttpServletResponse get() {
                return response;
            }
        });
        encoder.initialize();
        encoder.prepareContext();
        encoder.encode();
        Assert.assertEquals((String)response.getContentType(), (String)"text/xml;charset=UTF-8", (String)"Unexpected content type");
        Assert.assertEquals((String)"UTF-8", (String)response.getCharacterEncoding(), (String)"Unexpected character encoding");
        Assert.assertEquals((String)response.getHeader("Cache-control"), (String)"no-cache, no-store", (String)"Unexpected cache controls");
        Assert.assertEquals((int)response.getStatus(), (int)500);
        Envelope encodedEnv = (Envelope)this.parseUnmarshallResourceByteArray(response.getContentAsByteArray(), false);
        Assert.assertNotNull((Object)encodedEnv);
        Assert.assertNotNull((Object)encodedEnv.getBody());
        Body encodedBody = encodedEnv.getBody();
        List faults = encodedBody.getUnknownXMLObjects(Fault.DEFAULT_ELEMENT_NAME);
        Assert.assertEquals((int)faults.size(), (int)1);
        Fault encodedFault = (Fault)faults.get(0);
        Assert.assertEquals((Object)encodedFault.getCode().getValue(), (Object)FaultCode.SERVER);
        Assert.assertEquals((String)encodedFault.getMessage().getValue(), (String)"Something bad happened");
    }

    @Test
    public void testFaultFromContextSignal() throws ComponentInitializationException, MessageEncodingException, XMLParserException, UnmarshallingException {
        Fault fault = (Fault)this.buildXMLObject(Fault.DEFAULT_ELEMENT_NAME);
        FaultCode faultCode = (FaultCode)this.buildXMLObject(FaultCode.DEFAULT_ELEMENT_NAME);
        faultCode.setValue(FaultCode.SERVER);
        fault.setCode(faultCode);
        FaultString faultString = (FaultString)this.buildXMLObject(FaultString.DEFAULT_ELEMENT_NAME);
        faultString.setValue("Something bad happened");
        fault.setMessage(faultString);
        XMLObjectBuilder xsAnyBuilder = this.getBuilder(XSAny.TYPE_NAME);
        XSAny payload = (XSAny)xsAnyBuilder.buildObject("http://example.org/soap/ns/message", "GetLastTradePriceResponse", "m");
        XSAny price = (XSAny)xsAnyBuilder.buildObject("http://example.org/soap/ns/message", "Price", "m");
        price.setTextContent("34.5");
        payload.getUnknownXMLObjects().add(price);
        MessageContext messageContext = new MessageContext();
        messageContext.setMessage((Object)payload);
        SOAPMessagingSupport.registerSOAP11Fault((MessageContext)messageContext, (Fault)fault);
        final MockHttpServletResponse response = new MockHttpServletResponse();
        HTTPSOAP11Encoder encoder = new HTTPSOAP11Encoder();
        encoder.setMessageContext(messageContext);
        encoder.setHttpServletResponseSupplier((NonnullSupplier)new NonnullSupplier<HttpServletResponse>(){

            public MockHttpServletResponse get() {
                return response;
            }
        });
        encoder.initialize();
        encoder.prepareContext();
        encoder.encode();
        Assert.assertEquals((String)response.getContentType(), (String)"text/xml;charset=UTF-8", (String)"Unexpected content type");
        Assert.assertEquals((String)"UTF-8", (String)response.getCharacterEncoding(), (String)"Unexpected character encoding");
        Assert.assertEquals((String)response.getHeader("Cache-control"), (String)"no-cache, no-store", (String)"Unexpected cache controls");
        Assert.assertEquals((int)response.getStatus(), (int)500);
        Envelope encodedEnv = (Envelope)this.parseUnmarshallResourceByteArray(response.getContentAsByteArray(), false);
        Assert.assertNotNull((Object)encodedEnv);
        Assert.assertNotNull((Object)encodedEnv.getBody());
        Body encodedBody = encodedEnv.getBody();
        List faults = encodedBody.getUnknownXMLObjects(Fault.DEFAULT_ELEMENT_NAME);
        Assert.assertEquals((int)faults.size(), (int)1);
        Fault encodedFault = (Fault)faults.get(0);
        Assert.assertEquals((Object)encodedFault.getCode().getValue(), (Object)FaultCode.SERVER);
        Assert.assertEquals((String)encodedFault.getMessage().getValue(), (String)"Something bad happened");
    }

    @Test
    public void testContextReturnStatus() throws ComponentInitializationException, MessageEncodingException, XMLParserException, UnmarshallingException {
        XMLObject payload = this.buildXMLObject(simpleXMLObjectQName);
        MessageContext messageContext = new MessageContext();
        messageContext.setMessage((Object)payload);
        ((SOAP11Context)messageContext.getSubcontext(SOAP11Context.class, true)).setHTTPResponseStatus(Integer.valueOf(503));
        final MockHttpServletResponse response = new MockHttpServletResponse();
        HTTPSOAP11Encoder encoder = new HTTPSOAP11Encoder();
        encoder.setMessageContext(messageContext);
        encoder.setHttpServletResponseSupplier((NonnullSupplier)new NonnullSupplier<HttpServletResponse>(){

            public MockHttpServletResponse get() {
                return response;
            }
        });
        encoder.initialize();
        encoder.prepareContext();
        encoder.encode();
        Assert.assertEquals((int)response.getStatus(), (int)503);
    }

    protected XMLObject parseUnmarshallResource(String resource, boolean dropDOM) throws XMLParserException, UnmarshallingException {
        Document soapDoc = parserPool.parse(((Object)((Object)this)).getClass().getResourceAsStream(resource));
        return this.unmarshallXMLObject(soapDoc, dropDOM);
    }

    protected XMLObject parseUnmarshallResourceByteArray(byte[] input, boolean dropDOM) throws XMLParserException, UnmarshallingException {
        ByteArrayInputStream bais = new ByteArrayInputStream(input);
        Document soapDoc = parserPool.parse((InputStream)bais);
        return this.unmarshallXMLObject(soapDoc, dropDOM);
    }

    protected XMLObject unmarshallXMLObject(Document soapDoc, boolean dropDOM) throws UnmarshallingException {
        Element envelopeElem = soapDoc.getDocumentElement();
        Unmarshaller unmarshaller = unmarshallerFactory.getUnmarshaller(envelopeElem);
        Envelope envelope = (Envelope)unmarshaller.unmarshall(envelopeElem);
        if (dropDOM) {
            envelope.releaseDOM();
            envelope.releaseChildrenDOM(true);
        }
        return envelope;
    }
}

