/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.soap.testing;

import com.google.common.base.Strings;
import javax.xml.namespace.QName;
import net.shibboleth.utilities.java.support.xml.XMLParserException;
import org.opensaml.core.testing.XMLObjectBaseTestCase;
import org.opensaml.core.xml.XMLObject;
import org.opensaml.core.xml.XMLObjectBuilder;
import org.opensaml.core.xml.io.MarshallingException;
import org.opensaml.core.xml.io.Unmarshaller;
import org.opensaml.core.xml.io.UnmarshallingException;
import org.opensaml.soap.soap11.Body;
import org.opensaml.soap.soap11.Detail;
import org.opensaml.soap.soap11.Envelope;
import org.opensaml.soap.soap11.Fault;
import org.opensaml.soap.soap11.FaultActor;
import org.opensaml.soap.soap11.FaultCode;
import org.opensaml.soap.soap11.FaultString;
import org.opensaml.soap.soap11.Header;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class SOAPTest
extends XMLObjectBaseTestCase {
    private String soapMessage;
    private String soapFault;
    private String soapFaultMarshall;
    private QName expectedFaultCode;
    private String expectedFaultString;
    private String expectedFaultActor;

    @BeforeMethod
    protected void setUp() throws Exception {
        this.soapMessage = "/org/opensaml/soap/soap11/SOAP.xml";
        this.soapFault = "/org/opensaml/soap/soap11/SOAPFault.xml";
        this.soapFaultMarshall = "/org/opensaml/soap/soap11/SOAPFaultMarshall.xml";
        this.expectedFaultCode = new QName("http://schemas.xmlsoap.org/soap/envelope/", "Server", "soap11");
        this.expectedFaultString = "Server Error";
        this.expectedFaultActor = "http://ws.example.org/someActor";
    }

    @Test
    public void testSOAPMessage() throws XMLParserException, UnmarshallingException {
        Document soapDoc = parserPool.parse(SOAPTest.class.getResourceAsStream(this.soapMessage));
        Element envelopeElem = soapDoc.getDocumentElement();
        Unmarshaller unmarshaller = unmarshallerFactory.getUnmarshaller(envelopeElem);
        Envelope envelope = (Envelope)unmarshaller.unmarshall(envelopeElem);
        QName encodingStyleName = new QName("http://schemas.xmlsoap.org/soap/envelope/", "encodingStyle");
        String encodingStyleValue = envelope.getUnknownAttributes().get((Object)encodingStyleName);
        Assert.assertNotNull((Object)encodingStyleValue, (String)"Encoding style was null");
        Assert.assertEquals((String)encodingStyleValue, (String)"http://schemas.xmlsoap.org/soap/encoding/", (String)"Encoding style had unexpected value");
        Header header = envelope.getHeader();
        Assert.assertNotNull((Object)header, (String)"Header was null");
        Assert.assertEquals((int)header.getUnknownXMLObjects().size(), (int)1, (String)"Unexpected number of Header children");
        Body body = envelope.getBody();
        Assert.assertNotNull((Object)body, (String)"Body was null");
        Assert.assertEquals((int)body.getUnknownXMLObjects().size(), (int)1, (String)"Unexpected number of Body children");
        envelope.releaseDOM();
        envelope.releaseChildrenDOM(true);
        this.assertXMLEquals("Marshalled DOM was not the same as control DOM", soapDoc, (XMLObject)envelope);
    }

    @Test
    public void testSOAPFault() throws XMLParserException, UnmarshallingException {
        Document soapFaultDoc = parserPool.parse(SOAPTest.class.getResourceAsStream(this.soapFault));
        Element envelopeElem = soapFaultDoc.getDocumentElement();
        Unmarshaller unmarshaller = unmarshallerFactory.getUnmarshaller(envelopeElem);
        Envelope envelope = (Envelope)unmarshaller.unmarshall(envelopeElem);
        Header header = envelope.getHeader();
        Assert.assertNull((Object)header, (String)"Header was not null");
        Body body = envelope.getBody();
        Assert.assertNotNull((Object)body, (String)"Body was null");
        Assert.assertEquals((int)body.getUnknownXMLObjects().size(), (int)1, (String)"Unexpected number of Body children");
        Fault fault = (Fault)body.getUnknownXMLObjects().get(0);
        Assert.assertNotNull((Object)fault, (String)"Fault was null");
        FaultActor actor = fault.getActor();
        Assert.assertNotNull((Object)actor, (String)"FaultActor was null");
        Assert.assertEquals((String)actor.getURI(), (String)this.expectedFaultActor, (String)"FaultActor had unexpected value");
        FaultCode code = fault.getCode();
        Assert.assertNotNull((Object)code, (String)"FaultCode was null");
        Assert.assertEquals((Object)code.getValue(), (Object)this.expectedFaultCode, (String)"FaultCode had unexpected value");
        FaultString message = fault.getMessage();
        Assert.assertNotNull((Object)message, (String)"FaultString was null");
        Assert.assertEquals((String)message.getValue(), (String)this.expectedFaultString, (String)"FaultString had unexpected value");
        Detail detail = fault.getDetail();
        Assert.assertNotNull((Object)detail, (String)"Detail was null");
        Assert.assertEquals((int)detail.getUnknownXMLObjects().size(), (int)1, (String)"Unexpected number of Body children");
        envelope.releaseDOM();
        envelope.releaseChildrenDOM(true);
        this.assertXMLEquals("Marshalled DOM was not the same as control DOM", soapFaultDoc, (XMLObject)envelope);
    }

    @Test
    public void testSOAPFaultConstructAndMarshall() throws MarshallingException, XMLParserException {
        Document soapDoc = parserPool.parse(SOAPTest.class.getResourceAsStream(this.soapFaultMarshall));
        Envelope envelope = (Envelope)this.buildXMLObject(Envelope.DEFAULT_ELEMENT_NAME);
        Body body = (Body)this.buildXMLObject(Body.DEFAULT_ELEMENT_NAME);
        envelope.setBody(body);
        Fault fault = (Fault)this.buildXMLObject(Fault.DEFAULT_ELEMENT_NAME);
        body.getUnknownXMLObjects().add(fault);
        FaultCode faultCode = (FaultCode)this.buildXMLObject(FaultCode.DEFAULT_ELEMENT_NAME);
        faultCode.setValue(this.expectedFaultCode);
        fault.setCode(faultCode);
        FaultString faultString = (FaultString)this.buildXMLObject(FaultString.DEFAULT_ELEMENT_NAME);
        faultString.setValue(this.expectedFaultString);
        fault.setMessage(faultString);
        FaultActor faultActor = (FaultActor)this.buildXMLObject(FaultActor.DEFAULT_ELEMENT_NAME);
        faultActor.setURI(this.expectedFaultActor);
        fault.setActor(faultActor);
        Detail detail = (Detail)this.buildXMLObject(Detail.DEFAULT_ELEMENT_NAME);
        fault.setDetail(detail);
        marshallerFactory.getMarshaller((XMLObject)envelope).marshall((XMLObject)envelope);
        this.assertXMLEquals("Marshalled DOM was not the same as control DOM", soapDoc, (XMLObject)envelope);
    }

    @Test
    public void testSOAPFaultBuilders() {
        XMLObjectBuilder detailBuilder = builderFactory.getBuilderOrThrow(Detail.DEFAULT_ELEMENT_NAME);
        Detail detail = (Detail)detailBuilder.buildObject(Detail.DEFAULT_ELEMENT_NAME);
        Assert.assertTrue((boolean)Strings.isNullOrEmpty((String)detail.getElementQName().getNamespaceURI()), (String)"Namespace URI was not empty");
        Assert.assertTrue((boolean)Strings.isNullOrEmpty((String)detail.getElementQName().getPrefix()), (String)"Namespace prefix was not empty");
        XMLObjectBuilder faultActorBuilder = builderFactory.getBuilderOrThrow(FaultActor.DEFAULT_ELEMENT_NAME);
        FaultActor faultActor = (FaultActor)faultActorBuilder.buildObject(FaultActor.DEFAULT_ELEMENT_NAME);
        Assert.assertTrue((boolean)Strings.isNullOrEmpty((String)faultActor.getElementQName().getNamespaceURI()), (String)"Namespace URI was not empty");
        Assert.assertTrue((boolean)Strings.isNullOrEmpty((String)faultActor.getElementQName().getPrefix()), (String)"Namespace prefix was not empty");
        XMLObjectBuilder faultCodeBuilder = builderFactory.getBuilderOrThrow(FaultCode.DEFAULT_ELEMENT_NAME);
        FaultCode faultCode = (FaultCode)faultCodeBuilder.buildObject(FaultCode.DEFAULT_ELEMENT_NAME);
        Assert.assertTrue((boolean)Strings.isNullOrEmpty((String)faultCode.getElementQName().getNamespaceURI()), (String)"Namespace URI was not empty");
        Assert.assertTrue((boolean)Strings.isNullOrEmpty((String)faultCode.getElementQName().getPrefix()), (String)"Namespace prefix was not empty");
        XMLObjectBuilder faultStringBuilder = builderFactory.getBuilderOrThrow(FaultString.DEFAULT_ELEMENT_NAME);
        FaultString faultString = (FaultString)faultStringBuilder.buildObject(FaultString.DEFAULT_ELEMENT_NAME);
        Assert.assertTrue((boolean)Strings.isNullOrEmpty((String)faultString.getElementQName().getNamespaceURI()), (String)"Namespace URI was not empty");
        Assert.assertTrue((boolean)Strings.isNullOrEmpty((String)faultString.getElementQName().getPrefix()), (String)"Namespace prefix was not empty");
    }
}

