/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.soap.wsaddressing.messaging.impl;

import javax.xml.namespace.QName;
import net.shibboleth.utilities.java.support.component.ComponentInitializationException;
import org.opensaml.messaging.context.MessageContext;
import org.opensaml.messaging.handler.MessageHandlerException;
import org.opensaml.soap.messaging.SOAPMessagingSupport;
import org.opensaml.soap.soap11.Fault;
import org.opensaml.soap.soap11.FaultCode;
import org.opensaml.soap.testing.SOAPMessagingBaseTestCase;
import org.opensaml.soap.util.SOAPSupport;
import org.opensaml.soap.wsaddressing.Action;
import org.opensaml.soap.wsaddressing.WSAddressingConstants;
import org.opensaml.soap.wsaddressing.messaging.WSAddressingContext;
import org.opensaml.soap.wsaddressing.messaging.impl.AddActionHandler;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public class AddActionHandlerTest
extends SOAPMessagingBaseTestCase {
    private AddActionHandler handler;

    @BeforeMethod
    protected void setUp() throws ComponentInitializationException {
        this.handler = new AddActionHandler();
    }

    @Test
    public void testNoInput() throws ComponentInitializationException, MessageHandlerException {
        this.handler.initialize();
        this.handler.invoke(this.getMessageContext());
        Assert.assertTrue((boolean)SOAPMessagingSupport.getOutboundHeaderBlock((MessageContext)this.getMessageContext(), (QName)Action.ELEMENT_NAME).isEmpty());
    }

    @Test
    public void testLocal() throws ComponentInitializationException, MessageHandlerException {
        this.handler.setActionURI("urn:test:action1");
        this.handler.initialize();
        this.handler.invoke(this.getMessageContext());
        Assert.assertFalse((boolean)SOAPMessagingSupport.getOutboundHeaderBlock((MessageContext)this.getMessageContext(), (QName)Action.ELEMENT_NAME).isEmpty());
        Action action = (Action)SOAPMessagingSupport.getOutboundHeaderBlock((MessageContext)this.getMessageContext(), (QName)Action.ELEMENT_NAME).get(0);
        Assert.assertEquals((String)action.getURI(), (String)"urn:test:action1");
    }

    @Test
    public void testContext() throws ComponentInitializationException, MessageHandlerException {
        ((WSAddressingContext)this.getMessageContext().getSubcontext(WSAddressingContext.class, true)).setActionURI("urn:test:action1");
        this.handler.initialize();
        this.handler.invoke(this.getMessageContext());
        Assert.assertFalse((boolean)SOAPMessagingSupport.getOutboundHeaderBlock((MessageContext)this.getMessageContext(), (QName)Action.ELEMENT_NAME).isEmpty());
        Action action = (Action)SOAPMessagingSupport.getOutboundHeaderBlock((MessageContext)this.getMessageContext(), (QName)Action.ELEMENT_NAME).get(0);
        Assert.assertEquals((String)action.getURI(), (String)"urn:test:action1");
    }

    @Test
    public void testContextOverride() throws ComponentInitializationException, MessageHandlerException {
        this.handler.setActionURI("urn:test:action1");
        ((WSAddressingContext)this.getMessageContext().getSubcontext(WSAddressingContext.class, true)).setActionURI("urn:test:action2");
        this.handler.initialize();
        this.handler.invoke(this.getMessageContext());
        Assert.assertFalse((boolean)SOAPMessagingSupport.getOutboundHeaderBlock((MessageContext)this.getMessageContext(), (QName)Action.ELEMENT_NAME).isEmpty());
        Action action = (Action)SOAPMessagingSupport.getOutboundHeaderBlock((MessageContext)this.getMessageContext(), (QName)Action.ELEMENT_NAME).get(0);
        Assert.assertEquals((String)action.getURI(), (String)"urn:test:action2");
    }

    @Test
    public void testFaultLocal() throws ComponentInitializationException, MessageHandlerException {
        Fault fault = SOAPSupport.buildSOAP11Fault((QName)FaultCode.SERVER, (String)"MyFault", null, null, null);
        SOAPMessagingSupport.registerSOAP11Fault((MessageContext)this.getMessageContext(), (Fault)fault);
        this.handler.setFaultActionURI("urn:test:action1");
        this.handler.initialize();
        this.handler.invoke(this.getMessageContext());
        Assert.assertFalse((boolean)SOAPMessagingSupport.getOutboundHeaderBlock((MessageContext)this.getMessageContext(), (QName)Action.ELEMENT_NAME).isEmpty());
        Action action = (Action)SOAPMessagingSupport.getOutboundHeaderBlock((MessageContext)this.getMessageContext(), (QName)Action.ELEMENT_NAME).get(0);
        Assert.assertEquals((String)action.getURI(), (String)"urn:test:action1");
    }

    @Test
    public void testFaultContext() throws ComponentInitializationException, MessageHandlerException {
        Fault fault = SOAPSupport.buildSOAP11Fault((QName)FaultCode.SERVER, (String)"MyFault", null, null, null);
        SOAPMessagingSupport.registerSOAP11Fault((MessageContext)this.getMessageContext(), (Fault)fault);
        ((WSAddressingContext)this.getMessageContext().getSubcontext(WSAddressingContext.class, true)).setFaultActionURI("urn:test:action1");
        this.handler.initialize();
        this.handler.invoke(this.getMessageContext());
        Assert.assertFalse((boolean)SOAPMessagingSupport.getOutboundHeaderBlock((MessageContext)this.getMessageContext(), (QName)Action.ELEMENT_NAME).isEmpty());
        Action action = (Action)SOAPMessagingSupport.getOutboundHeaderBlock((MessageContext)this.getMessageContext(), (QName)Action.ELEMENT_NAME).get(0);
        Assert.assertEquals((String)action.getURI(), (String)"urn:test:action1");
    }

    @Test
    public void testFaultContextOverride() throws ComponentInitializationException, MessageHandlerException {
        Fault fault = SOAPSupport.buildSOAP11Fault((QName)FaultCode.SERVER, (String)"MyFault", null, null, null);
        SOAPMessagingSupport.registerSOAP11Fault((MessageContext)this.getMessageContext(), (Fault)fault);
        this.handler.setFaultActionURI("urn:test:action1");
        ((WSAddressingContext)this.getMessageContext().getSubcontext(WSAddressingContext.class, true)).setFaultActionURI("urn:test:action2");
        this.handler.initialize();
        this.handler.invoke(this.getMessageContext());
        Assert.assertFalse((boolean)SOAPMessagingSupport.getOutboundHeaderBlock((MessageContext)this.getMessageContext(), (QName)Action.ELEMENT_NAME).isEmpty());
        Action action = (Action)SOAPMessagingSupport.getOutboundHeaderBlock((MessageContext)this.getMessageContext(), (QName)Action.ELEMENT_NAME).get(0);
        Assert.assertEquals((String)action.getURI(), (String)"urn:test:action2");
    }

    @Test
    public void testFaultDefaultForNonWSAddressing() throws ComponentInitializationException, MessageHandlerException {
        Fault fault = SOAPSupport.buildSOAP11Fault((QName)FaultCode.SERVER, (String)"MyFault", null, null, null);
        SOAPMessagingSupport.registerSOAP11Fault((MessageContext)this.getMessageContext(), (Fault)fault);
        this.handler.initialize();
        this.handler.invoke(this.getMessageContext());
        Assert.assertFalse((boolean)SOAPMessagingSupport.getOutboundHeaderBlock((MessageContext)this.getMessageContext(), (QName)Action.ELEMENT_NAME).isEmpty());
        Action action = (Action)SOAPMessagingSupport.getOutboundHeaderBlock((MessageContext)this.getMessageContext(), (QName)Action.ELEMENT_NAME).get(0);
        Assert.assertEquals((String)action.getURI(), (String)"http://www.w3.org/2005/08/addressing/soap/fault");
    }

    @Test
    public void testFaultDefaultForWSAddressing() throws ComponentInitializationException, MessageHandlerException {
        Fault fault = SOAPSupport.buildSOAP11Fault((QName)WSAddressingConstants.SOAP_FAULT_ACTION_NOT_SUPPORTED, (String)"MyFault", null, null, null);
        SOAPMessagingSupport.registerSOAP11Fault((MessageContext)this.getMessageContext(), (Fault)fault);
        this.handler.initialize();
        this.handler.invoke(this.getMessageContext());
        Assert.assertFalse((boolean)SOAPMessagingSupport.getOutboundHeaderBlock((MessageContext)this.getMessageContext(), (QName)Action.ELEMENT_NAME).isEmpty());
        Action action = (Action)SOAPMessagingSupport.getOutboundHeaderBlock((MessageContext)this.getMessageContext(), (QName)Action.ELEMENT_NAME).get(0);
        Assert.assertEquals((String)action.getURI(), (String)"http://www.w3.org/2005/08/addressing/fault");
    }
}

