/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.soap.wsaddressing.messaging.impl;

import net.shibboleth.utilities.java.support.component.ComponentInitializationException;
import org.opensaml.core.xml.XMLObject;
import org.opensaml.messaging.context.MessageContext;
import org.opensaml.messaging.handler.MessageHandlerException;
import org.opensaml.soap.messaging.SOAPMessagingSupport;
import org.opensaml.soap.testing.SOAPMessagingBaseTestCase;
import org.opensaml.soap.wsaddressing.Action;
import org.opensaml.soap.wsaddressing.messaging.WSAddressingContext;
import org.opensaml.soap.wsaddressing.messaging.impl.ValidateActionHandler;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public class ValidateActionHandlerTest
extends SOAPMessagingBaseTestCase {
    private ValidateActionHandler handler;

    @BeforeMethod
    protected void setUp() throws ComponentInitializationException {
        this.handler = new ValidateActionHandler();
    }

    @Test
    public void testNoExpected() throws ComponentInitializationException, MessageHandlerException {
        Action action = (Action)this.buildXMLObject(Action.ELEMENT_NAME);
        action.setURI("urn:test:action1");
        SOAPMessagingSupport.addHeaderBlock((MessageContext)this.getMessageContext(), (XMLObject)action);
        this.handler.initialize();
        this.handler.invoke(this.getMessageContext());
        Assert.assertFalse((boolean)SOAPMessagingSupport.checkUnderstoodHeader((MessageContext)this.getMessageContext(), (XMLObject)action));
    }

    @Test
    public void testLocalExpected() throws ComponentInitializationException, MessageHandlerException {
        Action action = (Action)this.buildXMLObject(Action.ELEMENT_NAME);
        action.setURI("urn:test:action1");
        SOAPMessagingSupport.addHeaderBlock((MessageContext)this.getMessageContext(), (XMLObject)action);
        this.handler.setExpectedActionURI("urn:test:action1");
        this.handler.initialize();
        this.handler.invoke(this.getMessageContext());
        Assert.assertTrue((boolean)SOAPMessagingSupport.checkUnderstoodHeader((MessageContext)this.getMessageContext(), (XMLObject)action));
    }

    @Test
    public void testContextExpected() throws ComponentInitializationException, MessageHandlerException {
        Action action = (Action)this.buildXMLObject(Action.ELEMENT_NAME);
        action.setURI("urn:test:action1");
        SOAPMessagingSupport.addHeaderBlock((MessageContext)this.getMessageContext(), (XMLObject)action);
        ((WSAddressingContext)this.getMessageContext().getSubcontext(WSAddressingContext.class, true)).setActionURI("urn:test:action1");
        this.handler.initialize();
        this.handler.invoke(this.getMessageContext());
        Assert.assertTrue((boolean)SOAPMessagingSupport.checkUnderstoodHeader((MessageContext)this.getMessageContext(), (XMLObject)action));
    }

    @Test
    public void testContextOverride() throws ComponentInitializationException, MessageHandlerException {
        Action action = (Action)this.buildXMLObject(Action.ELEMENT_NAME);
        action.setURI("urn:test:action1");
        SOAPMessagingSupport.addHeaderBlock((MessageContext)this.getMessageContext(), (XMLObject)action);
        this.handler.setExpectedActionURI("urn:test:action2");
        ((WSAddressingContext)this.getMessageContext().getSubcontext(WSAddressingContext.class, true)).setActionURI("urn:test:action1");
        this.handler.initialize();
        this.handler.invoke(this.getMessageContext());
        Assert.assertTrue((boolean)SOAPMessagingSupport.checkUnderstoodHeader((MessageContext)this.getMessageContext(), (XMLObject)action));
    }

    @Test(expectedExceptions={MessageHandlerException.class})
    public void testNoMatch() throws ComponentInitializationException, MessageHandlerException {
        Action action = (Action)this.buildXMLObject(Action.ELEMENT_NAME);
        action.setURI("urn:test:action1");
        SOAPMessagingSupport.addHeaderBlock((MessageContext)this.getMessageContext(), (XMLObject)action);
        this.handler.setExpectedActionURI("urn:test:action2");
        this.handler.initialize();
        this.handler.invoke(this.getMessageContext());
    }

    @Test(expectedExceptions={MessageHandlerException.class})
    public void testExpectedButNoHeader() throws ComponentInitializationException, MessageHandlerException {
        this.handler.setExpectedActionURI("urn:test:action1");
        this.handler.initialize();
        this.handler.invoke(this.getMessageContext());
    }
}

