/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.soap.wssecurity.messaging.impl;

import java.time.Duration;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import javax.xml.namespace.QName;
import net.shibboleth.utilities.java.support.component.ComponentInitializationException;
import net.shibboleth.utilities.java.support.logic.FunctionSupport;
import org.opensaml.messaging.context.MessageContext;
import org.opensaml.messaging.handler.MessageHandlerException;
import org.opensaml.soap.messaging.SOAPMessagingSupport;
import org.opensaml.soap.testing.SOAPMessagingBaseTestCase;
import org.opensaml.soap.wssecurity.Security;
import org.opensaml.soap.wssecurity.Timestamp;
import org.opensaml.soap.wssecurity.messaging.WSSecurityContext;
import org.opensaml.soap.wssecurity.messaging.impl.AddTimestampHandler;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public class AddTimestampHandlerTest
extends SOAPMessagingBaseTestCase {
    private AddTimestampHandler handler;

    @BeforeMethod
    protected void setUp() throws ComponentInitializationException {
        this.handler = new AddTimestampHandler();
    }

    @Test
    public void testNoInput() throws ComponentInitializationException, MessageHandlerException {
        this.handler.initialize();
        this.handler.invoke(this.getMessageContext());
        Assert.assertTrue((boolean)SOAPMessagingSupport.getOutboundHeaderBlock((MessageContext)this.getMessageContext(), (QName)Security.ELEMENT_NAME).isEmpty());
    }

    @Test
    public void testNoInputUsingCurrentTimeAndOffset() throws ComponentInitializationException, MessageHandlerException {
        this.handler.setUseCurrentTimeAsDefaultCreated(true);
        this.handler.setExpiresOffsetFromCreated(Duration.ofMinutes(5L));
        this.handler.initialize();
        this.handler.invoke(this.getMessageContext());
        Assert.assertFalse((boolean)SOAPMessagingSupport.getOutboundHeaderBlock((MessageContext)this.getMessageContext(), (QName)Security.ELEMENT_NAME).isEmpty());
        Security security = (Security)SOAPMessagingSupport.getOutboundHeaderBlock((MessageContext)this.getMessageContext(), (QName)Security.ELEMENT_NAME).get(0);
        Assert.assertFalse((boolean)security.getUnknownXMLObjects(Timestamp.ELEMENT_NAME).isEmpty());
        Timestamp timestamp = (Timestamp)security.getUnknownXMLObjects(Timestamp.ELEMENT_NAME).get(0);
        Assert.assertNotNull((Object)timestamp.getCreated());
        Assert.assertNotNull((Object)timestamp.getCreated().getDateTime());
        Assert.assertNotNull((Object)timestamp.getExpires());
        Assert.assertEquals((Object)timestamp.getExpires().getDateTime(), (Object)timestamp.getCreated().getDateTime().plusMillis(300000L));
    }

    @Test
    public void testContextBothValues() throws ComponentInitializationException, MessageHandlerException {
        Instant created = Instant.now();
        Instant expires = created.plus(5L, ChronoUnit.MINUTES);
        ((WSSecurityContext)this.getMessageContext().getSubcontext(WSSecurityContext.class, true)).setTimestampCreated(created);
        ((WSSecurityContext)this.getMessageContext().getSubcontext(WSSecurityContext.class, true)).setTimestampExpires(expires);
        this.handler.initialize();
        this.handler.invoke(this.getMessageContext());
        Assert.assertFalse((boolean)SOAPMessagingSupport.getOutboundHeaderBlock((MessageContext)this.getMessageContext(), (QName)Security.ELEMENT_NAME).isEmpty());
        Security security = (Security)SOAPMessagingSupport.getOutboundHeaderBlock((MessageContext)this.getMessageContext(), (QName)Security.ELEMENT_NAME).get(0);
        Assert.assertFalse((boolean)security.getUnknownXMLObjects(Timestamp.ELEMENT_NAME).isEmpty());
        Timestamp timestamp = (Timestamp)security.getUnknownXMLObjects(Timestamp.ELEMENT_NAME).get(0);
        Assert.assertNotNull((Object)timestamp.getCreated());
        Assert.assertEquals((Object)timestamp.getCreated().getDateTime(), (Object)created);
        Assert.assertNotNull((Object)timestamp.getExpires());
        Assert.assertEquals((Object)timestamp.getExpires().getDateTime(), (Object)expires);
    }

    @Test
    public void testContextCreated() throws ComponentInitializationException, MessageHandlerException {
        Instant created = Instant.now();
        ((WSSecurityContext)this.getMessageContext().getSubcontext(WSSecurityContext.class, true)).setTimestampCreated(created);
        this.handler.initialize();
        this.handler.invoke(this.getMessageContext());
        Assert.assertFalse((boolean)SOAPMessagingSupport.getOutboundHeaderBlock((MessageContext)this.getMessageContext(), (QName)Security.ELEMENT_NAME).isEmpty());
        Security security = (Security)SOAPMessagingSupport.getOutboundHeaderBlock((MessageContext)this.getMessageContext(), (QName)Security.ELEMENT_NAME).get(0);
        Assert.assertFalse((boolean)security.getUnknownXMLObjects(Timestamp.ELEMENT_NAME).isEmpty());
        Timestamp timestamp = (Timestamp)security.getUnknownXMLObjects(Timestamp.ELEMENT_NAME).get(0);
        Assert.assertNotNull((Object)timestamp.getCreated());
        Assert.assertEquals((Object)timestamp.getCreated().getDateTime(), (Object)created);
        Assert.assertNull((Object)timestamp.getExpires());
    }

    @Test
    public void testContextExpires() throws ComponentInitializationException, MessageHandlerException {
        Instant created = Instant.now();
        Instant expires = created.plus(5L, ChronoUnit.MINUTES);
        ((WSSecurityContext)this.getMessageContext().getSubcontext(WSSecurityContext.class, true)).setTimestampExpires(expires);
        this.handler.initialize();
        this.handler.invoke(this.getMessageContext());
        Assert.assertFalse((boolean)SOAPMessagingSupport.getOutboundHeaderBlock((MessageContext)this.getMessageContext(), (QName)Security.ELEMENT_NAME).isEmpty());
        Security security = (Security)SOAPMessagingSupport.getOutboundHeaderBlock((MessageContext)this.getMessageContext(), (QName)Security.ELEMENT_NAME).get(0);
        Assert.assertFalse((boolean)security.getUnknownXMLObjects(Timestamp.ELEMENT_NAME).isEmpty());
        Timestamp timestamp = (Timestamp)security.getUnknownXMLObjects(Timestamp.ELEMENT_NAME).get(0);
        Assert.assertNull((Object)timestamp.getCreated());
        Assert.assertNotNull((Object)timestamp.getExpires());
        Assert.assertEquals((Object)timestamp.getExpires().getDateTime(), (Object)expires);
    }

    @Test
    public void testContextCreatedWithOffset() throws ComponentInitializationException, MessageHandlerException {
        Instant created = Instant.now();
        Instant expires = created.plus(5L, ChronoUnit.MINUTES);
        ((WSSecurityContext)this.getMessageContext().getSubcontext(WSSecurityContext.class, true)).setTimestampCreated(created);
        this.handler.setExpiresOffsetFromCreated(Duration.ofMinutes(5L));
        this.handler.initialize();
        this.handler.invoke(this.getMessageContext());
        Assert.assertFalse((boolean)SOAPMessagingSupport.getOutboundHeaderBlock((MessageContext)this.getMessageContext(), (QName)Security.ELEMENT_NAME).isEmpty());
        Security security = (Security)SOAPMessagingSupport.getOutboundHeaderBlock((MessageContext)this.getMessageContext(), (QName)Security.ELEMENT_NAME).get(0);
        Assert.assertFalse((boolean)security.getUnknownXMLObjects(Timestamp.ELEMENT_NAME).isEmpty());
        Timestamp timestamp = (Timestamp)security.getUnknownXMLObjects(Timestamp.ELEMENT_NAME).get(0);
        Assert.assertNotNull((Object)timestamp.getCreated());
        Assert.assertEquals((Object)timestamp.getCreated().getDateTime(), (Object)created);
        Assert.assertNotNull((Object)timestamp.getExpires());
        Assert.assertEquals((Object)timestamp.getExpires().getDateTime(), (Object)expires);
    }

    @Test
    public void testLookupBothValues() throws ComponentInitializationException, MessageHandlerException {
        Instant created = Instant.now();
        Instant expires = created.plus(5L, ChronoUnit.MINUTES);
        this.handler.setCreatedLookup(FunctionSupport.constant((Object)created));
        this.handler.setExpiresLookup(FunctionSupport.constant((Object)expires));
        this.handler.initialize();
        this.handler.invoke(this.getMessageContext());
        Assert.assertFalse((boolean)SOAPMessagingSupport.getOutboundHeaderBlock((MessageContext)this.getMessageContext(), (QName)Security.ELEMENT_NAME).isEmpty());
        Security security = (Security)SOAPMessagingSupport.getOutboundHeaderBlock((MessageContext)this.getMessageContext(), (QName)Security.ELEMENT_NAME).get(0);
        Assert.assertFalse((boolean)security.getUnknownXMLObjects(Timestamp.ELEMENT_NAME).isEmpty());
        Timestamp timestamp = (Timestamp)security.getUnknownXMLObjects(Timestamp.ELEMENT_NAME).get(0);
        Assert.assertNotNull((Object)timestamp.getCreated());
        Assert.assertEquals((Object)timestamp.getCreated().getDateTime(), (Object)created);
        Assert.assertNotNull((Object)timestamp.getExpires());
        Assert.assertEquals((Object)timestamp.getExpires().getDateTime(), (Object)expires);
    }

    @Test
    public void testLookupCreatedWithOffset() throws ComponentInitializationException, MessageHandlerException {
        Instant created = Instant.now();
        Instant expires = created.plus(5L, ChronoUnit.MINUTES);
        this.handler.setCreatedLookup(FunctionSupport.constant((Object)created));
        this.handler.setExpiresOffsetFromCreated(Duration.ofMinutes(5L));
        this.handler.initialize();
        this.handler.invoke(this.getMessageContext());
        Assert.assertFalse((boolean)SOAPMessagingSupport.getOutboundHeaderBlock((MessageContext)this.getMessageContext(), (QName)Security.ELEMENT_NAME).isEmpty());
        Security security = (Security)SOAPMessagingSupport.getOutboundHeaderBlock((MessageContext)this.getMessageContext(), (QName)Security.ELEMENT_NAME).get(0);
        Assert.assertFalse((boolean)security.getUnknownXMLObjects(Timestamp.ELEMENT_NAME).isEmpty());
        Timestamp timestamp = (Timestamp)security.getUnknownXMLObjects(Timestamp.ELEMENT_NAME).get(0);
        Assert.assertNotNull((Object)timestamp.getCreated());
        Assert.assertEquals((Object)timestamp.getCreated().getDateTime(), (Object)created);
        Assert.assertNotNull((Object)timestamp.getExpires());
        Assert.assertEquals((Object)timestamp.getExpires().getDateTime(), (Object)expires);
    }
}

