/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.storage.impl.client;

import java.io.IOException;
import java.util.Collections;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.shibboleth.utilities.java.support.component.ComponentInitializationException;
import net.shibboleth.utilities.java.support.net.HttpServletRequestResponseContext;
import org.opensaml.profile.context.ProfileRequestContext;
import org.opensaml.profile.testing.ActionTestingSupport;
import org.opensaml.profile.testing.RequestContextBuilder;
import org.opensaml.storage.impl.client.AbstractBaseClientStorageServiceTest;
import org.opensaml.storage.impl.client.ClientStorageSaveContext;
import org.opensaml.storage.impl.client.ClientStorageService;
import org.opensaml.storage.impl.client.ClientStorageServiceOperation;
import org.opensaml.storage.impl.client.PopulateClientStorageSaveContext;
import org.springframework.mock.web.MockHttpServletRequest;
import org.springframework.mock.web.MockHttpServletResponse;
import org.testng.Assert;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public class PopulateClientStorageSaveContextTest
extends AbstractBaseClientStorageServiceTest {
    private ProfileRequestContext prc;
    private PopulateClientStorageSaveContext action;

    @BeforeClass
    public void setUpClass() throws ComponentInitializationException {
        this.init();
    }

    @BeforeMethod
    public void setUp() {
        this.prc = new RequestContextBuilder().buildProfileRequestContext();
        this.action = new PopulateClientStorageSaveContext();
    }

    @Test
    public void testNoServices() throws ComponentInitializationException {
        this.action.initialize();
        this.action.execute(this.prc);
        ActionTestingSupport.assertEvent((ProfileRequestContext)this.prc, (Object)"NoSaveNeeded");
        Assert.assertNull((Object)this.prc.getSubcontext(ClientStorageSaveContext.class));
    }

    @Test
    public void testUnloaded() throws ComponentInitializationException {
        this.action.setStorageServices(Collections.singletonList(this.getStorageService()));
        this.action.initialize();
        HttpServletRequestResponseContext.loadCurrent((HttpServletRequest)new MockHttpServletRequest(), (HttpServletResponse)new MockHttpServletResponse());
        this.action.execute(this.prc);
        ActionTestingSupport.assertEvent((ProfileRequestContext)this.prc, (Object)"NoSaveNeeded");
        Assert.assertNull((Object)this.prc.getSubcontext(ClientStorageSaveContext.class));
    }

    @Test
    public void testClean() throws ComponentInitializationException {
        ClientStorageService ss = this.getStorageService();
        this.action.setStorageServices(Collections.singletonList(ss));
        this.action.initialize();
        HttpServletRequestResponseContext.loadCurrent((HttpServletRequest)new MockHttpServletRequest(), (HttpServletResponse)new MockHttpServletResponse());
        ss.load(null, ClientStorageService.ClientStorageSource.HTML_LOCAL_STORAGE);
        this.action.execute(this.prc);
        ActionTestingSupport.assertEvent((ProfileRequestContext)this.prc, (Object)"NoSaveNeeded");
        Assert.assertNull((Object)this.prc.getSubcontext(ClientStorageSaveContext.class));
    }

    @Test
    public void testDirty() throws ComponentInitializationException, IOException {
        ClientStorageService ss = this.getStorageService();
        this.action.setStorageServices(Collections.singletonList(ss));
        this.action.initialize();
        HttpServletRequestResponseContext.loadCurrent((HttpServletRequest)new MockHttpServletRequest(), (HttpServletResponse)new MockHttpServletResponse());
        ss.load(null, ClientStorageService.ClientStorageSource.HTML_LOCAL_STORAGE);
        ss.create("context", "key", "value", null);
        this.action.execute(this.prc);
        ActionTestingSupport.assertProceedEvent((ProfileRequestContext)this.prc);
        ClientStorageSaveContext saveCtx = (ClientStorageSaveContext)this.prc.getSubcontext(ClientStorageSaveContext.class);
        Assert.assertNotNull((Object)saveCtx);
        Assert.assertTrue((boolean)saveCtx.isSourceRequired(ClientStorageService.ClientStorageSource.HTML_LOCAL_STORAGE));
        Assert.assertEquals((int)saveCtx.getStorageOperations().size(), (int)1);
        ClientStorageServiceOperation op = (ClientStorageServiceOperation)saveCtx.getStorageOperations().iterator().next();
        Assert.assertEquals((String)op.getStorageServiceID(), (String)ss.getId());
        Assert.assertEquals((String)op.getKey(), (String)ss.getStorageName());
        Assert.assertEquals((Object)op.getStorageSource(), (Object)ClientStorageService.ClientStorageSource.HTML_LOCAL_STORAGE);
    }
}

