/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.xacml.ctx.impl;

import org.opensaml.core.testing.XMLObjectProviderBaseTestCase;
import org.opensaml.core.xml.XMLObject;
import org.opensaml.xacml.ctx.StatusCodeType;
import org.opensaml.xacml.ctx.impl.StatusCodeTypeImplBuilder;
import org.testng.Assert;
import org.testng.annotations.Test;

public class StatusCodeTest
extends XMLObjectProviderBaseTestCase {
    private String expectedValue;
    private String expectedMinorValue;

    public StatusCodeTest() {
        this.singleElementFile = "/org/opensaml/xacml/ctx/impl/StatusCode.xml";
        this.childElementsFile = "/org/opensaml/xacml/ctx/impl/StatusCodeChildElements.xml";
        this.expectedValue = "https://example.org/Status/Code";
        this.expectedMinorValue = "https://example.org/Status/Code/Minor";
    }

    @Test
    public void testSingleElementUnmarshall() {
        StatusCodeType statusCode = (StatusCodeType)this.unmarshallElement(this.singleElementFile);
        Assert.assertEquals((String)statusCode.getValue(), (String)this.expectedValue);
    }

    @Test
    public void testSingleElementMarshall() {
        StatusCodeType statusCode = new StatusCodeTypeImplBuilder().buildObject();
        statusCode.setValue(this.expectedValue);
        this.assertXMLEquals(this.expectedDOM, (XMLObject)statusCode);
    }

    @Test
    public void testChildElementsUnmarshall() {
        StatusCodeType statusCode = (StatusCodeType)this.unmarshallElement(this.childElementsFile);
        Assert.assertEquals((String)statusCode.getValue(), (String)this.expectedValue);
        Assert.assertEquals((String)statusCode.getStatusCode().getValue(), (String)this.expectedMinorValue);
    }

    @Test
    public void testChildElementsMarshall() {
        StatusCodeType statusCode = new StatusCodeTypeImplBuilder().buildObject();
        statusCode.setValue(this.expectedValue);
        statusCode.setStatusCode(new StatusCodeTypeImplBuilder().buildObject());
        statusCode.getStatusCode().setValue(this.expectedMinorValue);
        this.assertXMLEquals(this.expectedChildElementsDOM, (XMLObject)statusCode);
    }
}

