/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.xacml.ctx.provider.impl;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import org.opensaml.core.testing.XMLObjectBaseTestCase;
import org.opensaml.xacml.ctx.DecisionType;
import org.opensaml.xacml.ctx.ResultType;
import org.opensaml.xacml.ctx.provider.impl.BaseObligationHandler;
import org.opensaml.xacml.ctx.provider.impl.ObligationProcessingContext;
import org.opensaml.xacml.ctx.provider.impl.ObligationProcessingException;
import org.opensaml.xacml.ctx.provider.impl.ObligationService;
import org.opensaml.xacml.policy.EffectType;
import org.opensaml.xacml.policy.ObligationType;
import org.opensaml.xacml.policy.ObligationsType;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public class ObligationServiceTest
extends XMLObjectBaseTestCase {
    private ObligationProcessingContext processingCtx;
    int count;

    @BeforeMethod
    protected void setUp() throws Exception {
        this.count = 0;
        ResultType result = (ResultType)builderFactory.getBuilder(ResultType.TYPE_NAME).buildObject(ResultType.DEFAULT_ELEMENT_NAME);
        result.setResourceId("urn:example.org:resource1");
        DecisionType decision = (DecisionType)builderFactory.getBuilder(DecisionType.TYPE_NAME).buildObject(DecisionType.DEFAULT_ELEMENT_NAME);
        decision.setDecision(DecisionType.DECISION.Permit);
        result.setDecision(decision);
        ObligationsType obligations = (ObligationsType)builderFactory.getBuilder(ObligationsType.SCHEMA_TYPE_NAME).buildObject(ObligationsType.DEFAULT_ELEMENT_QNAME);
        result.setObligations(obligations);
        ObligationType obligation = (ObligationType)builderFactory.getBuilder(ObligationType.SCHEMA_TYPE_NAME).buildObject(ObligationType.DEFAULT_ELEMENT_QNAME);
        obligation.setFulfillOn(EffectType.Permit);
        obligation.setObligationId("add1");
        obligations.getObligations().add(obligation);
        obligation = (ObligationType)builderFactory.getBuilder(ObligationType.SCHEMA_TYPE_NAME).buildObject(ObligationType.DEFAULT_ELEMENT_QNAME);
        obligation.setFulfillOn(EffectType.Permit);
        obligation.setObligationId("add2");
        obligations.getObligations().add(obligation);
        obligation = (ObligationType)builderFactory.getBuilder(ObligationType.SCHEMA_TYPE_NAME).buildObject(ObligationType.DEFAULT_ELEMENT_QNAME);
        obligation.setFulfillOn(EffectType.Permit);
        obligation.setObligationId("multiply1");
        obligations.getObligations().add(obligation);
        obligation = (ObligationType)builderFactory.getBuilder(ObligationType.SCHEMA_TYPE_NAME).buildObject(ObligationType.DEFAULT_ELEMENT_QNAME);
        obligation.setFulfillOn(EffectType.Permit);
        obligation.setObligationId("multiply2");
        obligations.getObligations().add(obligation);
        this.processingCtx = new ObligationProcessingContext(result);
    }

    @Test
    public void testObligationService() throws Exception {
        ObligationService obligSrvc = new ObligationService();
        obligSrvc.addObligationhandler((BaseObligationHandler)new AdditiveObligationHandler("add1", 1, 1));
        obligSrvc.addObligationhandler((BaseObligationHandler)new MultiplicitiveObligationHandler("multiply1", 2, 2));
        obligSrvc.addObligationhandler(Arrays.asList(new BaseObligationHandler[]{new AdditiveObligationHandler("add2", 3, 2), new MultiplicitiveObligationHandler("multiply2", 3, 2)}));
        obligSrvc.addObligationhandler((Collection)Collections.EMPTY_LIST);
        AdditiveObligationHandler toDel = new AdditiveObligationHandler("doo", -1, 3);
        obligSrvc.addObligationhandler((BaseObligationHandler)toDel);
        Assert.assertEquals((int)obligSrvc.getObligationHandlers().size(), (int)5);
        obligSrvc.removeObligationHandler((BaseObligationHandler)toDel);
        Assert.assertEquals((int)obligSrvc.getObligationHandlers().size(), (int)4);
        obligSrvc.processObligations(this.processingCtx);
        Assert.assertEquals((int)this.count, (int)8);
    }

    public class AdditiveObligationHandler
    extends BaseObligationHandler {
        private int addFactor;

        public AdditiveObligationHandler(String id, int precedence, int addFactor) {
            super(id, precedence);
            this.addFactor = addFactor;
        }

        public void evaluateObligation(ObligationProcessingContext context, ObligationType obligation) throws ObligationProcessingException {
            ObligationServiceTest.this.count += this.addFactor;
        }
    }

    public class MultiplicitiveObligationHandler
    extends BaseObligationHandler {
        int multiplyFactor;

        public MultiplicitiveObligationHandler(String id, int precedence, int multiplyFactor) {
            super(id, precedence);
            this.multiplyFactor = multiplyFactor;
        }

        public void evaluateObligation(ObligationProcessingContext context, ObligationType obligation) throws ObligationProcessingException {
            ObligationServiceTest.this.count *= this.multiplyFactor;
        }
    }
}

