/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.xacml.policy.impl;

import org.opensaml.core.testing.XMLObjectProviderBaseTestCase;
import org.opensaml.core.xml.XMLObject;
import org.opensaml.xacml.policy.ActionMatchType;
import org.opensaml.xacml.policy.AttributeDesignatorType;
import org.opensaml.xacml.policy.AttributeSelectorType;
import org.opensaml.xacml.policy.AttributeValueType;
import org.opensaml.xacml.policy.impl.ActionMatchTypeImplBuilder;
import org.testng.Assert;
import org.testng.annotations.Test;

public class ActionMatchTest
extends XMLObjectProviderBaseTestCase {
    private String expectedMatchId;

    public ActionMatchTest() {
        this.singleElementFile = "/org/opensaml/xacml/policy/impl/ActionMatch.xml";
        this.childElementsFile = "/org/opensaml/xacml/policy/impl/ActionMatchChildElements.xml";
        this.expectedMatchId = "http://example.org";
    }

    @Test
    public void testSingleElementUnmarshall() {
        ActionMatchType actionMatch = (ActionMatchType)this.unmarshallElement(this.singleElementFile);
        Assert.assertEquals((String)actionMatch.getMatchId(), (String)this.expectedMatchId, (String)("MatchId URI has a value of " + actionMatch.getMatchId() + ", expected a value of " + this.expectedMatchId));
    }

    @Test
    public void testSingleElementMarshall() {
        ActionMatchType actionMatch = new ActionMatchTypeImplBuilder().buildObject();
        actionMatch.setMatchId(this.expectedMatchId);
        this.assertXMLEquals(this.expectedDOM, (XMLObject)actionMatch);
    }

    @Test
    public void testChildElementsUnmarshall() {
        ActionMatchType actionMatch = (ActionMatchType)this.unmarshallElement(this.childElementsFile);
        Assert.assertNotNull((Object)actionMatch.getActionAttributeDesignator());
        Assert.assertNotNull((Object)actionMatch.getAttributeSelector());
        Assert.assertNotNull((Object)actionMatch.getAttributeValue());
        Assert.assertEquals((String)actionMatch.getMatchId(), (String)this.expectedMatchId, (String)("MatchId URI has a value of " + actionMatch.getMatchId() + ", expected a value of " + this.expectedMatchId));
    }

    @Test
    public void testChildElementsMarshall() {
        ActionMatchType actionMatch = new ActionMatchTypeImplBuilder().buildObject();
        actionMatch.setMatchId(this.expectedMatchId);
        AttributeDesignatorType attributeDesignatorType = (AttributeDesignatorType)this.buildXMLObject(AttributeDesignatorType.ACTION_ATTRIBUTE_DESIGNATOR_ELEMENT_NAME);
        attributeDesignatorType.setMustBePresent(Boolean.valueOf(true));
        actionMatch.setActionAttributeDesignator(attributeDesignatorType);
        attributeDesignatorType = (AttributeDesignatorType)this.buildXMLObject(AttributeDesignatorType.ACTION_ATTRIBUTE_DESIGNATOR_ELEMENT_NAME);
        attributeDesignatorType.setMustBePresent(Boolean.valueOf(false));
        actionMatch.setActionAttributeDesignator(attributeDesignatorType);
        actionMatch.setAttributeSelector((AttributeSelectorType)this.buildXMLObject(AttributeSelectorType.DEFAULT_ELEMENT_NAME));
        actionMatch.setAttributeSelector((AttributeSelectorType)this.buildXMLObject(AttributeSelectorType.DEFAULT_ELEMENT_NAME));
        actionMatch.setAttributeValue((AttributeValueType)this.buildXMLObject(AttributeValueType.DEFAULT_ELEMENT_NAME));
        this.assertXMLEquals(this.expectedChildElementsDOM, (XMLObject)actionMatch);
    }
}

