/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.xacml.policy.impl;

import org.opensaml.core.testing.XMLObjectProviderBaseTestCase;
import org.opensaml.core.xml.XMLObject;
import org.opensaml.xacml.policy.AttributeSelectorType;
import org.opensaml.xacml.policy.impl.AttributeSelectorTypeImplBuilder;
import org.testng.Assert;
import org.testng.annotations.Test;

public class AttributeSelectorTest
extends XMLObjectProviderBaseTestCase {
    private String expectedDataType;
    private String expectedRequestContextPath;
    private Boolean optionalMustBePresent;

    public AttributeSelectorTest() {
        this.singleElementFile = "/org/opensaml/xacml/policy/impl/AttributeSelector.xml";
        this.singleElementOptionalAttributesFile = "/org/opensaml/xacml/policy/impl/AttributeSelectorOptionalAttributes.xml";
        this.expectedDataType = "https://example.org/Data/Attribute/Selector";
        this.expectedRequestContextPath = "ConextPathAttrSelect";
        this.optionalMustBePresent = true;
    }

    @Test
    public void testSingleElementUnmarshall() {
        AttributeSelectorType attributeSelector = (AttributeSelectorType)this.unmarshallElement(this.singleElementFile);
        Assert.assertEquals((String)attributeSelector.getDataType(), (String)this.expectedDataType);
        Assert.assertEquals((String)attributeSelector.getRequestContextPath(), (String)this.expectedRequestContextPath);
        Assert.assertFalse((boolean)attributeSelector.getMustBePresent());
    }

    @Test
    public void testSingleElementMarshall() {
        AttributeSelectorType attributeSelector = new AttributeSelectorTypeImplBuilder().buildObject();
        Assert.assertFalse((boolean)attributeSelector.getMustBePresent());
        attributeSelector.setDataType(this.expectedDataType);
        attributeSelector.setRequestContextPath(this.expectedRequestContextPath);
        attributeSelector.setMustBePresentXSBoolean(null);
        Assert.assertFalse((boolean)attributeSelector.getMustBePresent());
        attributeSelector.setMustBePresent(Boolean.valueOf(true));
        Assert.assertTrue((boolean)attributeSelector.getMustBePresent());
        attributeSelector.setMustBePresent(null);
        this.assertXMLEquals(this.expectedDOM, (XMLObject)attributeSelector);
    }

    @Test
    public void testSingleElementOptionalAttributesUnmarshall() {
        AttributeSelectorType attributeSelector = (AttributeSelectorType)this.unmarshallElement(this.singleElementOptionalAttributesFile);
        Assert.assertEquals((String)attributeSelector.getDataType(), (String)this.expectedDataType);
        Assert.assertEquals((String)attributeSelector.getRequestContextPath(), (String)this.expectedRequestContextPath);
        Assert.assertEquals((Object)attributeSelector.getMustBePresent(), (Object)this.optionalMustBePresent);
    }

    @Test
    public void testSingleElementOptionalAttributesMarshall() {
        AttributeSelectorType attributeSelector = new AttributeSelectorTypeImplBuilder().buildObject();
        attributeSelector.setDataType(this.expectedDataType);
        attributeSelector.setRequestContextPath(this.expectedRequestContextPath);
        attributeSelector.setMustBePresent(this.optionalMustBePresent);
        this.assertXMLEquals(this.expectedOptionalAttributesDOM, (XMLObject)attributeSelector);
    }
}

