/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.xacml.policy.impl;

import org.opensaml.core.testing.XMLObjectProviderBaseTestCase;
import org.opensaml.core.xml.XMLObject;
import org.opensaml.xacml.policy.AttributeDesignatorType;
import org.opensaml.xacml.policy.AttributeSelectorType;
import org.opensaml.xacml.policy.AttributeValueType;
import org.opensaml.xacml.policy.EnvironmentMatchType;
import org.opensaml.xacml.policy.impl.AttributeSelectorTypeImplBuilder;
import org.opensaml.xacml.policy.impl.AttributeValueTypeImplBuilder;
import org.opensaml.xacml.policy.impl.EnvironmentMatchTypeImplBuilder;
import org.testng.Assert;
import org.testng.annotations.Test;

public class EnvironmentMatchTest
extends XMLObjectProviderBaseTestCase {
    private String expectedMatchId;
    private String expectedDataType;
    private String expectedAttributeId;
    private String expectedRequestContextPath;

    public EnvironmentMatchTest() {
        this.singleElementFile = "/org/opensaml/xacml/policy/impl/EnvironmentMatch.xml";
        this.childElementsFile = "/org/opensaml/xacml/policy/impl/EnvironmentMatchChildElements.xml";
        this.expectedMatchId = "https://example.org/Environment/Match/Id";
        this.expectedDataType = "https://example.org/Environment/Match/Data/Type";
        this.expectedAttributeId = "https://example.org/Environment/Match/Attribute/Id";
        this.expectedRequestContextPath = "ConextPathAttrSelect";
    }

    @Test
    public void testSingleElementUnmarshall() {
        EnvironmentMatchType environmentMatch = (EnvironmentMatchType)this.unmarshallElement(this.singleElementFile);
        Assert.assertEquals((String)environmentMatch.getMatchId(), (String)this.expectedMatchId);
    }

    @Test
    public void testSingleElementMarshall() {
        EnvironmentMatchType environmentMatch = new EnvironmentMatchTypeImplBuilder().buildObject();
        environmentMatch.setMatchId(this.expectedMatchId);
        this.assertXMLEquals(this.expectedDOM, (XMLObject)environmentMatch);
    }

    @Test
    public void testChildElementsMarshall() {
        EnvironmentMatchType environmentMatch = new EnvironmentMatchTypeImplBuilder().buildObject();
        environmentMatch.setMatchId(this.expectedMatchId);
        AttributeValueType attrValue = new AttributeValueTypeImplBuilder().buildObject();
        attrValue.setDataType(this.expectedDataType);
        environmentMatch.setAttributeValue(attrValue);
        AttributeDesignatorType attrDesignator = (AttributeDesignatorType)this.buildXMLObject(AttributeDesignatorType.ENVIRONMENT_ATTRIBUTE_DESIGNATOR_ELEMENT_NAME);
        attrDesignator.setAttributeId(this.expectedAttributeId + "g");
        attrDesignator.setDataType(this.expectedDataType + "t");
        attrDesignator.setMustBePresent(Boolean.valueOf(true));
        environmentMatch.setEnvironmentAttributeDesignator(attrDesignator);
        attrDesignator = (AttributeDesignatorType)this.buildXMLObject(AttributeDesignatorType.ENVIRONMENT_ATTRIBUTE_DESIGNATOR_ELEMENT_NAME);
        attrDesignator.setAttributeId(this.expectedAttributeId);
        attrDesignator.setDataType(this.expectedDataType);
        attrDesignator.setMustBePresentXSBoolean(null);
        environmentMatch.setEnvironmentAttributeDesignator(attrDesignator);
        AttributeSelectorType attrSelector = new AttributeSelectorTypeImplBuilder().buildObject();
        attrSelector.setRequestContextPath(this.expectedRequestContextPath + "ds");
        attrSelector.setDataType(this.expectedDataType + "*");
        attrSelector.setMustBePresent(Boolean.valueOf(true));
        environmentMatch.setAttributeSelector(attrSelector);
        attrSelector = new AttributeSelectorTypeImplBuilder().buildObject();
        attrSelector.setRequestContextPath(this.expectedRequestContextPath);
        attrSelector.setDataType(this.expectedDataType);
        attrSelector.setMustBePresentXSBoolean(null);
        environmentMatch.setAttributeSelector(attrSelector);
        this.assertXMLEquals(this.expectedChildElementsDOM, (XMLObject)environmentMatch);
    }

    @Test
    public void testChildElementsUnmarshall() {
        EnvironmentMatchType environmentMatch = (EnvironmentMatchType)this.unmarshallElement(this.childElementsFile);
        Assert.assertEquals((String)environmentMatch.getMatchId(), (String)this.expectedMatchId);
        AttributeValueType attrValue = environmentMatch.getAttributeValue();
        Assert.assertEquals((String)attrValue.getDataType(), (String)this.expectedDataType);
        AttributeDesignatorType attrDesignator = environmentMatch.getEnvironmentAttributeDesignator();
        Assert.assertEquals((String)attrDesignator.getAttributeId(), (String)this.expectedAttributeId);
        Assert.assertEquals((String)attrDesignator.getDataType(), (String)this.expectedDataType);
        attrDesignator.setMustBePresent(null);
        AttributeSelectorType attrSelector = environmentMatch.getAttributeSelector();
        Assert.assertEquals((String)attrSelector.getRequestContextPath(), (String)this.expectedRequestContextPath);
        Assert.assertEquals((String)attrSelector.getDataType(), (String)this.expectedDataType);
    }
}

