/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.xacml.policy.impl;

import org.opensaml.core.testing.XMLObjectProviderBaseTestCase;
import org.opensaml.core.xml.XMLObject;
import org.opensaml.xacml.policy.ResourceMatchType;
import org.opensaml.xacml.policy.ResourceType;
import org.opensaml.xacml.policy.impl.ResourceMatchTypeImplBuilder;
import org.opensaml.xacml.policy.impl.ResourceTypeImplBuilder;
import org.testng.Assert;
import org.testng.annotations.Test;

public class ResourceTest
extends XMLObjectProviderBaseTestCase {
    private String expectedMatchId;
    private int expectedResourceMatches;

    public ResourceTest() {
        this.singleElementFile = "/org/opensaml/xacml/policy/impl/Resource.xml";
        this.childElementsFile = "/org/opensaml/xacml/policy/impl/ResourceChildElements.xml";
        this.expectedMatchId = "http://example.org/Resource/Match/Id";
        this.expectedResourceMatches = 4;
    }

    @Test
    public void testSingleElementUnmarshall() {
        ResourceType resource = (ResourceType)this.unmarshallElement(this.singleElementFile);
        Assert.assertTrue((boolean)resource.getResourceMatches().isEmpty());
    }

    @Test
    public void testSingleElementMarshall() {
        ResourceType resource = new ResourceTypeImplBuilder().buildObject();
        this.assertXMLEquals(this.expectedDOM, (XMLObject)resource);
    }

    @Test
    public void testChildElementsUnmarshall() {
        ResourceType resource = (ResourceType)this.unmarshallElement(this.childElementsFile);
        Assert.assertEquals((int)resource.getResourceMatches().size(), (int)this.expectedResourceMatches);
        for (ResourceMatchType resourceMatch : resource.getResourceMatches()) {
            Assert.assertEquals((String)resourceMatch.getMatchId(), (String)this.expectedMatchId);
        }
    }

    @Test
    public void testChildElementsMarshall() {
        ResourceType resource = new ResourceTypeImplBuilder().buildObject();
        ResourceMatchTypeImplBuilder builder = new ResourceMatchTypeImplBuilder();
        for (int i = 0; i < this.expectedResourceMatches; ++i) {
            ResourceMatchType resourceMatch = builder.buildObject();
            resourceMatch.setMatchId(this.expectedMatchId);
            resource.getResourceMatches().add(resourceMatch);
        }
        this.assertXMLEquals(this.expectedChildElementsDOM, (XMLObject)resource);
    }
}

