/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.xmlsec.agreement;

import java.util.Set;
import org.opensaml.security.credential.Credential;
import org.opensaml.xmlsec.agreement.KeyAgreementCredential;
import org.opensaml.xmlsec.agreement.KeyAgreementException;
import org.opensaml.xmlsec.agreement.KeyAgreementParameters;
import org.opensaml.xmlsec.agreement.KeyAgreementProcessor;
import org.opensaml.xmlsec.agreement.KeyAgreementProcessorRegistry;
import org.testng.Assert;
import org.testng.annotations.Test;

public class KeyAgreementProcessorRegistryTest {
    @Test
    public void basic() {
        KeyAgreementProcessorRegistry registry = new KeyAgreementProcessorRegistry();
        Assert.assertEquals((int)registry.getRegisteredAlgorithms().size(), (int)0);
        MockProcessorFoo foo1 = new MockProcessorFoo();
        MockProcessorFoo foo2 = new MockProcessorFoo();
        MockProcessorBar bar = new MockProcessorBar();
        registry.register((KeyAgreementProcessor)foo1);
        Assert.assertEquals((int)registry.getRegisteredAlgorithms().size(), (int)1);
        Assert.assertEquals((Set)registry.getRegisteredAlgorithms(), Set.of("urn:test:KeyAgreementProcessor:Foo"));
        Assert.assertSame((Object)registry.getProcessor("urn:test:KeyAgreementProcessor:Foo"), (Object)foo1);
        registry.register((KeyAgreementProcessor)foo2);
        Assert.assertEquals((int)registry.getRegisteredAlgorithms().size(), (int)1);
        Assert.assertEquals((Set)registry.getRegisteredAlgorithms(), Set.of("urn:test:KeyAgreementProcessor:Foo"));
        Assert.assertSame((Object)registry.getProcessor("urn:test:KeyAgreementProcessor:Foo"), (Object)foo2);
        registry.register((KeyAgreementProcessor)bar);
        Assert.assertEquals((int)registry.getRegisteredAlgorithms().size(), (int)2);
        Assert.assertEquals((Set)registry.getRegisteredAlgorithms(), Set.of("urn:test:KeyAgreementProcessor:Foo", "urn:test:KeyAgreementProcessor:Bar"));
        Assert.assertSame((Object)registry.getProcessor("urn:test:KeyAgreementProcessor:Foo"), (Object)foo2);
        Assert.assertSame((Object)registry.getProcessor("urn:test:KeyAgreementProcessor:Bar"), (Object)bar);
        registry.deregister("urn:test:KeyAgreementProcessor:Foo");
        Assert.assertEquals((int)registry.getRegisteredAlgorithms().size(), (int)1);
        Assert.assertEquals((Set)registry.getRegisteredAlgorithms(), Set.of("urn:test:KeyAgreementProcessor:Bar"));
        Assert.assertNull((Object)registry.getProcessor("urn:test:KeyAgreementProcessor:Foo"));
        Assert.assertSame((Object)registry.getProcessor("urn:test:KeyAgreementProcessor:Bar"), (Object)bar);
        registry.clear();
        Assert.assertEquals((int)registry.getRegisteredAlgorithms().size(), (int)0);
        Assert.assertEquals((Set)registry.getRegisteredAlgorithms(), Set.of());
        Assert.assertNull((Object)registry.getProcessor("urn:test:KeyAgreementProcessor:Foo"));
        Assert.assertNull((Object)registry.getProcessor("urn:test:KeyAgreementProcessor:Bar"));
    }

    public static class MockProcessorFoo
    implements KeyAgreementProcessor {
        public String getAlgorithm() {
            return "urn:test:KeyAgreementProcessor:Foo";
        }

        public KeyAgreementCredential execute(Credential publicCredential, String keyAlgorithm, KeyAgreementParameters parameters) throws KeyAgreementException {
            return null;
        }
    }

    public static class MockProcessorBar
    implements KeyAgreementProcessor {
        public String getAlgorithm() {
            return "urn:test:KeyAgreementProcessor:Bar";
        }

        public KeyAgreementCredential execute(Credential publicCredential, String keyAlgorithm, KeyAgreementParameters parameters) throws KeyAgreementException {
            return null;
        }
    }
}

