/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.xmlsec.algorithm;

import org.opensaml.xmlsec.algorithm.AlgorithmDescriptor;
import org.opensaml.xmlsec.algorithm.descriptors.BlockEncryptionAES128CBC;
import org.opensaml.xmlsec.algorithm.descriptors.BlockEncryptionAES128GCM;
import org.opensaml.xmlsec.algorithm.descriptors.BlockEncryptionAES192CBC;
import org.opensaml.xmlsec.algorithm.descriptors.BlockEncryptionAES192GCM;
import org.opensaml.xmlsec.algorithm.descriptors.BlockEncryptionAES256CBC;
import org.opensaml.xmlsec.algorithm.descriptors.BlockEncryptionAES256GCM;
import org.opensaml.xmlsec.algorithm.descriptors.BlockEncryptionDESede;
import org.opensaml.xmlsec.algorithm.descriptors.DigestMD5;
import org.opensaml.xmlsec.algorithm.descriptors.DigestRIPEMD160;
import org.opensaml.xmlsec.algorithm.descriptors.DigestSHA1;
import org.opensaml.xmlsec.algorithm.descriptors.DigestSHA224;
import org.opensaml.xmlsec.algorithm.descriptors.DigestSHA256;
import org.opensaml.xmlsec.algorithm.descriptors.DigestSHA384;
import org.opensaml.xmlsec.algorithm.descriptors.DigestSHA512;
import org.opensaml.xmlsec.algorithm.descriptors.HMACMD5;
import org.opensaml.xmlsec.algorithm.descriptors.HMACRIPEMD160;
import org.opensaml.xmlsec.algorithm.descriptors.HMACSHA1;
import org.opensaml.xmlsec.algorithm.descriptors.HMACSHA224;
import org.opensaml.xmlsec.algorithm.descriptors.HMACSHA256;
import org.opensaml.xmlsec.algorithm.descriptors.HMACSHA384;
import org.opensaml.xmlsec.algorithm.descriptors.HMACSHA512;
import org.opensaml.xmlsec.algorithm.descriptors.KeyAgreementDHExplicitKDF;
import org.opensaml.xmlsec.algorithm.descriptors.KeyAgreementDHLegacyKDF;
import org.opensaml.xmlsec.algorithm.descriptors.KeyAgreementECDH;
import org.opensaml.xmlsec.algorithm.descriptors.KeyTransportRSA15;
import org.opensaml.xmlsec.algorithm.descriptors.KeyTransportRSAOAEP;
import org.opensaml.xmlsec.algorithm.descriptors.KeyTransportRSAOAEPMGF1P;
import org.opensaml.xmlsec.algorithm.descriptors.SignatureDSASHA1;
import org.opensaml.xmlsec.algorithm.descriptors.SignatureDSASHA256;
import org.opensaml.xmlsec.algorithm.descriptors.SignatureECDSASHA1;
import org.opensaml.xmlsec.algorithm.descriptors.SignatureECDSASHA224;
import org.opensaml.xmlsec.algorithm.descriptors.SignatureECDSASHA256;
import org.opensaml.xmlsec.algorithm.descriptors.SignatureECDSASHA384;
import org.opensaml.xmlsec.algorithm.descriptors.SignatureECDSASHA512;
import org.opensaml.xmlsec.algorithm.descriptors.SignatureRSAMD5;
import org.opensaml.xmlsec.algorithm.descriptors.SignatureRSARIPEMD160;
import org.opensaml.xmlsec.algorithm.descriptors.SignatureRSASHA1;
import org.opensaml.xmlsec.algorithm.descriptors.SignatureRSASHA224;
import org.opensaml.xmlsec.algorithm.descriptors.SignatureRSASHA256;
import org.opensaml.xmlsec.algorithm.descriptors.SignatureRSASHA384;
import org.opensaml.xmlsec.algorithm.descriptors.SignatureRSASHA512;
import org.opensaml.xmlsec.algorithm.descriptors.SymmetricKeyWrapAES128;
import org.opensaml.xmlsec.algorithm.descriptors.SymmetricKeyWrapAES192;
import org.opensaml.xmlsec.algorithm.descriptors.SymmetricKeyWrapAES256;
import org.opensaml.xmlsec.algorithm.descriptors.SymmetricKeyWrapDESede;
import org.testng.Assert;
import org.testng.annotations.Test;

public class AlgorithmDescriptorsTest {
    @Test
    public void testBlockEncryption() {
        BlockEncryptionAES128CBC descriptor = new BlockEncryptionAES128CBC();
        Assert.assertEquals((String)descriptor.getCipherMode(), (String)"CBC");
        Assert.assertEquals((String)descriptor.getJCAAlgorithmID(), (String)"AES/CBC/ISO10126Padding");
        Assert.assertEquals((String)descriptor.getKey(), (String)"AES");
        Assert.assertEquals((String)descriptor.getPadding(), (String)"ISO10126Padding");
        Assert.assertEquals((String)descriptor.getURI(), (String)"http://www.w3.org/2001/04/xmlenc#aes128-cbc");
        Assert.assertEquals((Object)descriptor.getKeyLength(), (Object)128);
        Assert.assertEquals((Object)descriptor.getType(), (Object)AlgorithmDescriptor.AlgorithmType.BlockEncryption);
        descriptor = new BlockEncryptionAES128GCM();
        Assert.assertEquals((String)descriptor.getCipherMode(), (String)"GCM");
        Assert.assertEquals((String)descriptor.getJCAAlgorithmID(), (String)"AES/GCM/NoPadding");
        Assert.assertEquals((String)descriptor.getKey(), (String)"AES");
        Assert.assertEquals((String)descriptor.getPadding(), (String)"NoPadding");
        Assert.assertEquals((String)descriptor.getURI(), (String)"http://www.w3.org/2009/xmlenc11#aes128-gcm");
        Assert.assertEquals((Object)descriptor.getKeyLength(), (Object)128);
        Assert.assertEquals((Object)descriptor.getType(), (Object)AlgorithmDescriptor.AlgorithmType.BlockEncryption);
        descriptor = new BlockEncryptionAES192CBC();
        Assert.assertEquals((String)descriptor.getCipherMode(), (String)"CBC");
        Assert.assertEquals((String)descriptor.getJCAAlgorithmID(), (String)"AES/CBC/ISO10126Padding");
        Assert.assertEquals((String)descriptor.getKey(), (String)"AES");
        Assert.assertEquals((String)descriptor.getPadding(), (String)"ISO10126Padding");
        Assert.assertEquals((String)descriptor.getURI(), (String)"http://www.w3.org/2001/04/xmlenc#aes192-cbc");
        Assert.assertEquals((Object)descriptor.getKeyLength(), (Object)192);
        Assert.assertEquals((Object)descriptor.getType(), (Object)AlgorithmDescriptor.AlgorithmType.BlockEncryption);
        descriptor = new BlockEncryptionAES192GCM();
        Assert.assertEquals((String)descriptor.getCipherMode(), (String)"GCM");
        Assert.assertEquals((String)descriptor.getJCAAlgorithmID(), (String)"AES/GCM/NoPadding");
        Assert.assertEquals((String)descriptor.getKey(), (String)"AES");
        Assert.assertEquals((String)descriptor.getPadding(), (String)"NoPadding");
        Assert.assertEquals((String)descriptor.getURI(), (String)"http://www.w3.org/2009/xmlenc11#aes192-gcm");
        Assert.assertEquals((Object)descriptor.getKeyLength(), (Object)192);
        Assert.assertEquals((Object)descriptor.getType(), (Object)AlgorithmDescriptor.AlgorithmType.BlockEncryption);
        descriptor = new BlockEncryptionAES256CBC();
        Assert.assertEquals((String)descriptor.getCipherMode(), (String)"CBC");
        Assert.assertEquals((String)descriptor.getJCAAlgorithmID(), (String)"AES/CBC/ISO10126Padding");
        Assert.assertEquals((String)descriptor.getKey(), (String)"AES");
        Assert.assertEquals((String)descriptor.getPadding(), (String)"ISO10126Padding");
        Assert.assertEquals((String)descriptor.getURI(), (String)"http://www.w3.org/2001/04/xmlenc#aes256-cbc");
        Assert.assertEquals((Object)descriptor.getKeyLength(), (Object)256);
        Assert.assertEquals((Object)descriptor.getType(), (Object)AlgorithmDescriptor.AlgorithmType.BlockEncryption);
        descriptor = new BlockEncryptionAES256GCM();
        Assert.assertEquals((String)descriptor.getCipherMode(), (String)"GCM");
        Assert.assertEquals((String)descriptor.getJCAAlgorithmID(), (String)"AES/GCM/NoPadding");
        Assert.assertEquals((String)descriptor.getKey(), (String)"AES");
        Assert.assertEquals((String)descriptor.getPadding(), (String)"NoPadding");
        Assert.assertEquals((String)descriptor.getURI(), (String)"http://www.w3.org/2009/xmlenc11#aes256-gcm");
        Assert.assertEquals((Object)descriptor.getKeyLength(), (Object)256);
        Assert.assertEquals((Object)descriptor.getType(), (Object)AlgorithmDescriptor.AlgorithmType.BlockEncryption);
        descriptor = new BlockEncryptionDESede();
        Assert.assertEquals((String)descriptor.getCipherMode(), (String)"CBC");
        Assert.assertEquals((String)descriptor.getJCAAlgorithmID(), (String)"DESede/CBC/ISO10126Padding");
        Assert.assertEquals((String)descriptor.getKey(), (String)"DESede");
        Assert.assertEquals((String)descriptor.getPadding(), (String)"ISO10126Padding");
        Assert.assertEquals((String)descriptor.getURI(), (String)"http://www.w3.org/2001/04/xmlenc#tripledes-cbc");
        Assert.assertEquals((Object)descriptor.getKeyLength(), (Object)192);
        Assert.assertEquals((Object)descriptor.getType(), (Object)AlgorithmDescriptor.AlgorithmType.BlockEncryption);
    }

    @Test
    public void testDigest() {
        DigestMD5 descriptor = new DigestMD5();
        Assert.assertEquals((String)descriptor.getJCAAlgorithmID(), (String)"MD5");
        Assert.assertEquals((String)descriptor.getURI(), (String)"http://www.w3.org/2001/04/xmldsig-more#md5");
        Assert.assertEquals((Object)descriptor.getType(), (Object)AlgorithmDescriptor.AlgorithmType.MessageDigest);
        descriptor = new DigestRIPEMD160();
        Assert.assertEquals((String)descriptor.getJCAAlgorithmID(), (String)"RIPEMD160");
        Assert.assertEquals((String)descriptor.getURI(), (String)"http://www.w3.org/2001/04/xmlenc#ripemd160");
        Assert.assertEquals((Object)descriptor.getType(), (Object)AlgorithmDescriptor.AlgorithmType.MessageDigest);
        descriptor = new DigestSHA1();
        Assert.assertEquals((String)descriptor.getJCAAlgorithmID(), (String)"SHA-1");
        Assert.assertEquals((String)descriptor.getURI(), (String)"http://www.w3.org/2000/09/xmldsig#sha1");
        Assert.assertEquals((Object)descriptor.getType(), (Object)AlgorithmDescriptor.AlgorithmType.MessageDigest);
        descriptor = new DigestSHA224();
        Assert.assertEquals((String)descriptor.getJCAAlgorithmID(), (String)"SHA-224");
        Assert.assertEquals((String)descriptor.getURI(), (String)"http://www.w3.org/2001/04/xmldsig-more#sha224");
        Assert.assertEquals((Object)descriptor.getType(), (Object)AlgorithmDescriptor.AlgorithmType.MessageDigest);
        descriptor = new DigestSHA256();
        Assert.assertEquals((String)descriptor.getJCAAlgorithmID(), (String)"SHA-256");
        Assert.assertEquals((String)descriptor.getURI(), (String)"http://www.w3.org/2001/04/xmlenc#sha256");
        Assert.assertEquals((Object)descriptor.getType(), (Object)AlgorithmDescriptor.AlgorithmType.MessageDigest);
        descriptor = new DigestSHA384();
        Assert.assertEquals((String)descriptor.getJCAAlgorithmID(), (String)"SHA-384");
        Assert.assertEquals((String)descriptor.getURI(), (String)"http://www.w3.org/2001/04/xmldsig-more#sha384");
        Assert.assertEquals((Object)descriptor.getType(), (Object)AlgorithmDescriptor.AlgorithmType.MessageDigest);
        descriptor = new DigestSHA512();
        Assert.assertEquals((String)descriptor.getJCAAlgorithmID(), (String)"SHA-512");
        Assert.assertEquals((String)descriptor.getURI(), (String)"http://www.w3.org/2001/04/xmlenc#sha512");
        Assert.assertEquals((Object)descriptor.getType(), (Object)AlgorithmDescriptor.AlgorithmType.MessageDigest);
    }

    @Test
    public void testHMAC() {
        HMACMD5 descriptor = new HMACMD5();
        Assert.assertEquals((String)descriptor.getDigest(), (String)"MD5");
        Assert.assertEquals((String)descriptor.getJCAAlgorithmID(), (String)"HmacMD5");
        Assert.assertEquals((String)descriptor.getURI(), (String)"http://www.w3.org/2001/04/xmldsig-more#hmac-md5");
        Assert.assertEquals((Object)descriptor.getType(), (Object)AlgorithmDescriptor.AlgorithmType.Mac);
        descriptor = new HMACRIPEMD160();
        Assert.assertEquals((String)descriptor.getDigest(), (String)"RIPEMD160");
        Assert.assertEquals((String)descriptor.getJCAAlgorithmID(), (String)"HMACRIPEMD160");
        Assert.assertEquals((String)descriptor.getURI(), (String)"http://www.w3.org/2001/04/xmldsig-more#hmac-ripemd160");
        Assert.assertEquals((Object)descriptor.getType(), (Object)AlgorithmDescriptor.AlgorithmType.Mac);
        descriptor = new HMACSHA1();
        Assert.assertEquals((String)descriptor.getDigest(), (String)"SHA-1");
        Assert.assertEquals((String)descriptor.getJCAAlgorithmID(), (String)"HmacSHA1");
        Assert.assertEquals((String)descriptor.getURI(), (String)"http://www.w3.org/2000/09/xmldsig#hmac-sha1");
        Assert.assertEquals((Object)descriptor.getType(), (Object)AlgorithmDescriptor.AlgorithmType.Mac);
        descriptor = new HMACSHA224();
        Assert.assertEquals((String)descriptor.getDigest(), (String)"SHA-224");
        Assert.assertEquals((String)descriptor.getJCAAlgorithmID(), (String)"HmacSHA224");
        Assert.assertEquals((String)descriptor.getURI(), (String)"http://www.w3.org/2001/04/xmldsig-more#hmac-sha224");
        Assert.assertEquals((Object)descriptor.getType(), (Object)AlgorithmDescriptor.AlgorithmType.Mac);
        descriptor = new HMACSHA256();
        Assert.assertEquals((String)descriptor.getDigest(), (String)"SHA-256");
        Assert.assertEquals((String)descriptor.getJCAAlgorithmID(), (String)"HmacSHA256");
        Assert.assertEquals((String)descriptor.getURI(), (String)"http://www.w3.org/2001/04/xmldsig-more#hmac-sha256");
        Assert.assertEquals((Object)descriptor.getType(), (Object)AlgorithmDescriptor.AlgorithmType.Mac);
        descriptor = new HMACSHA384();
        Assert.assertEquals((String)descriptor.getDigest(), (String)"SHA-384");
        Assert.assertEquals((String)descriptor.getJCAAlgorithmID(), (String)"HmacSHA384");
        Assert.assertEquals((String)descriptor.getURI(), (String)"http://www.w3.org/2001/04/xmldsig-more#hmac-sha384");
        Assert.assertEquals((Object)descriptor.getType(), (Object)AlgorithmDescriptor.AlgorithmType.Mac);
        descriptor = new HMACSHA512();
        Assert.assertEquals((String)descriptor.getDigest(), (String)"SHA-512");
        Assert.assertEquals((String)descriptor.getJCAAlgorithmID(), (String)"HmacSHA512");
        Assert.assertEquals((String)descriptor.getURI(), (String)"http://www.w3.org/2001/04/xmldsig-more#hmac-sha512");
        Assert.assertEquals((Object)descriptor.getType(), (Object)AlgorithmDescriptor.AlgorithmType.Mac);
    }

    @Test
    public void testKeyAgreement() {
        KeyAgreementDHExplicitKDF descriptor = new KeyAgreementDHExplicitKDF();
        Assert.assertEquals((String)descriptor.getJCAAlgorithmID(), (String)"DiffieHellman");
        Assert.assertEquals((String)descriptor.getURI(), (String)"http://www.w3.org/2009/xmlenc11#dh-es");
        Assert.assertEquals((Object)descriptor.getType(), (Object)AlgorithmDescriptor.AlgorithmType.KeyAgreement);
        descriptor = new KeyAgreementDHLegacyKDF();
        Assert.assertEquals((String)descriptor.getJCAAlgorithmID(), (String)"DiffieHellman");
        Assert.assertEquals((String)descriptor.getURI(), (String)"http://www.w3.org/2001/04/xmlenc#dh");
        Assert.assertEquals((Object)descriptor.getType(), (Object)AlgorithmDescriptor.AlgorithmType.KeyAgreement);
        descriptor = new KeyAgreementECDH();
        Assert.assertEquals((String)descriptor.getJCAAlgorithmID(), (String)"ECDH");
        Assert.assertEquals((String)descriptor.getURI(), (String)"http://www.w3.org/2009/xmlenc11#ECDH-ES");
        Assert.assertEquals((Object)descriptor.getType(), (Object)AlgorithmDescriptor.AlgorithmType.KeyAgreement);
    }

    @Test
    public void testKeyTransport() {
        KeyTransportRSA15 descriptor = new KeyTransportRSA15();
        Assert.assertEquals((String)descriptor.getCipherMode(), (String)"ECB");
        Assert.assertEquals((String)descriptor.getJCAAlgorithmID(), (String)"RSA/ECB/PKCS1Padding");
        Assert.assertEquals((String)descriptor.getKey(), (String)"RSA");
        Assert.assertEquals((String)descriptor.getPadding(), (String)"PKCS1Padding");
        Assert.assertEquals((String)descriptor.getURI(), (String)"http://www.w3.org/2001/04/xmlenc#rsa-1_5");
        Assert.assertEquals((Object)descriptor.getType(), (Object)AlgorithmDescriptor.AlgorithmType.KeyTransport);
        descriptor = new KeyTransportRSAOAEPMGF1P();
        Assert.assertEquals((String)descriptor.getCipherMode(), (String)"ECB");
        Assert.assertEquals((String)descriptor.getJCAAlgorithmID(), (String)"RSA/ECB/OAEPPadding");
        Assert.assertEquals((String)descriptor.getKey(), (String)"RSA");
        Assert.assertEquals((String)descriptor.getPadding(), (String)"OAEPPadding");
        Assert.assertEquals((String)descriptor.getURI(), (String)"http://www.w3.org/2001/04/xmlenc#rsa-oaep-mgf1p");
        Assert.assertEquals((Object)descriptor.getType(), (Object)AlgorithmDescriptor.AlgorithmType.KeyTransport);
        descriptor = new KeyTransportRSAOAEP();
        Assert.assertEquals((String)descriptor.getCipherMode(), (String)"ECB");
        Assert.assertEquals((String)descriptor.getJCAAlgorithmID(), (String)"RSA/ECB/OAEPPadding");
        Assert.assertEquals((String)descriptor.getKey(), (String)"RSA");
        Assert.assertEquals((String)descriptor.getPadding(), (String)"OAEPPadding");
        Assert.assertEquals((String)descriptor.getURI(), (String)"http://www.w3.org/2009/xmlenc11#rsa-oaep");
        Assert.assertEquals((Object)descriptor.getType(), (Object)AlgorithmDescriptor.AlgorithmType.KeyTransport);
    }

    @Test
    public void testSignature() {
        SignatureDSASHA1 descriptor = new SignatureDSASHA1();
        Assert.assertEquals((String)descriptor.getDigest(), (String)"SHA-1");
        Assert.assertEquals((String)descriptor.getJCAAlgorithmID(), (String)"SHA1withDSA");
        Assert.assertEquals((String)descriptor.getKey(), (String)"DSA");
        Assert.assertEquals((String)descriptor.getURI(), (String)"http://www.w3.org/2000/09/xmldsig#dsa-sha1");
        Assert.assertEquals((Object)descriptor.getType(), (Object)AlgorithmDescriptor.AlgorithmType.Signature);
        descriptor = new SignatureDSASHA256();
        Assert.assertEquals((String)descriptor.getDigest(), (String)"SHA-256");
        Assert.assertEquals((String)descriptor.getJCAAlgorithmID(), (String)"SHA256withDSA");
        Assert.assertEquals((String)descriptor.getKey(), (String)"DSA");
        Assert.assertEquals((String)descriptor.getURI(), (String)"http://www.w3.org/2009/xmldsig11#dsa-sha256");
        Assert.assertEquals((Object)descriptor.getType(), (Object)AlgorithmDescriptor.AlgorithmType.Signature);
        descriptor = new SignatureECDSASHA1();
        Assert.assertEquals((String)descriptor.getDigest(), (String)"SHA-1");
        Assert.assertEquals((String)descriptor.getJCAAlgorithmID(), (String)"SHA1withECDSA");
        Assert.assertEquals((String)descriptor.getKey(), (String)"EC");
        Assert.assertEquals((String)descriptor.getURI(), (String)"http://www.w3.org/2001/04/xmldsig-more#ecdsa-sha1");
        Assert.assertEquals((Object)descriptor.getType(), (Object)AlgorithmDescriptor.AlgorithmType.Signature);
        descriptor = new SignatureECDSASHA224();
        Assert.assertEquals((String)descriptor.getDigest(), (String)"SHA-224");
        Assert.assertEquals((String)descriptor.getJCAAlgorithmID(), (String)"SHA224withECDSA");
        Assert.assertEquals((String)descriptor.getKey(), (String)"EC");
        Assert.assertEquals((String)descriptor.getURI(), (String)"http://www.w3.org/2001/04/xmldsig-more#ecdsa-sha224");
        Assert.assertEquals((Object)descriptor.getType(), (Object)AlgorithmDescriptor.AlgorithmType.Signature);
        descriptor = new SignatureECDSASHA256();
        Assert.assertEquals((String)descriptor.getDigest(), (String)"SHA-256");
        Assert.assertEquals((String)descriptor.getJCAAlgorithmID(), (String)"SHA256withECDSA");
        Assert.assertEquals((String)descriptor.getKey(), (String)"EC");
        Assert.assertEquals((String)descriptor.getURI(), (String)"http://www.w3.org/2001/04/xmldsig-more#ecdsa-sha256");
        Assert.assertEquals((Object)descriptor.getType(), (Object)AlgorithmDescriptor.AlgorithmType.Signature);
        descriptor = new SignatureECDSASHA384();
        Assert.assertEquals((String)descriptor.getDigest(), (String)"SHA-384");
        Assert.assertEquals((String)descriptor.getJCAAlgorithmID(), (String)"SHA384withECDSA");
        Assert.assertEquals((String)descriptor.getKey(), (String)"EC");
        Assert.assertEquals((String)descriptor.getURI(), (String)"http://www.w3.org/2001/04/xmldsig-more#ecdsa-sha384");
        Assert.assertEquals((Object)descriptor.getType(), (Object)AlgorithmDescriptor.AlgorithmType.Signature);
        descriptor = new SignatureECDSASHA512();
        Assert.assertEquals((String)descriptor.getDigest(), (String)"SHA-512");
        Assert.assertEquals((String)descriptor.getJCAAlgorithmID(), (String)"SHA512withECDSA");
        Assert.assertEquals((String)descriptor.getKey(), (String)"EC");
        Assert.assertEquals((String)descriptor.getURI(), (String)"http://www.w3.org/2001/04/xmldsig-more#ecdsa-sha512");
        Assert.assertEquals((Object)descriptor.getType(), (Object)AlgorithmDescriptor.AlgorithmType.Signature);
        descriptor = new SignatureRSAMD5();
        Assert.assertEquals((String)descriptor.getDigest(), (String)"MD5");
        Assert.assertEquals((String)descriptor.getJCAAlgorithmID(), (String)"MD5withRSA");
        Assert.assertEquals((String)descriptor.getKey(), (String)"RSA");
        Assert.assertEquals((String)descriptor.getURI(), (String)"http://www.w3.org/2001/04/xmldsig-more#rsa-md5");
        Assert.assertEquals((Object)descriptor.getType(), (Object)AlgorithmDescriptor.AlgorithmType.Signature);
        descriptor = new SignatureRSARIPEMD160();
        Assert.assertEquals((String)descriptor.getDigest(), (String)"RIPEMD160");
        Assert.assertEquals((String)descriptor.getJCAAlgorithmID(), (String)"RIPEMD160withRSA");
        Assert.assertEquals((String)descriptor.getKey(), (String)"RSA");
        Assert.assertEquals((String)descriptor.getURI(), (String)"http://www.w3.org/2001/04/xmldsig-more#rsa-ripemd160");
        Assert.assertEquals((Object)descriptor.getType(), (Object)AlgorithmDescriptor.AlgorithmType.Signature);
        descriptor = new SignatureRSASHA1();
        Assert.assertEquals((String)descriptor.getDigest(), (String)"SHA-1");
        Assert.assertEquals((String)descriptor.getJCAAlgorithmID(), (String)"SHA1withRSA");
        Assert.assertEquals((String)descriptor.getKey(), (String)"RSA");
        Assert.assertEquals((String)descriptor.getURI(), (String)"http://www.w3.org/2000/09/xmldsig#rsa-sha1");
        Assert.assertEquals((Object)descriptor.getType(), (Object)AlgorithmDescriptor.AlgorithmType.Signature);
        descriptor = new SignatureRSASHA224();
        Assert.assertEquals((String)descriptor.getDigest(), (String)"SHA-224");
        Assert.assertEquals((String)descriptor.getJCAAlgorithmID(), (String)"SHA224withRSA");
        Assert.assertEquals((String)descriptor.getKey(), (String)"RSA");
        Assert.assertEquals((String)descriptor.getURI(), (String)"http://www.w3.org/2001/04/xmldsig-more#rsa-sha224");
        Assert.assertEquals((Object)descriptor.getType(), (Object)AlgorithmDescriptor.AlgorithmType.Signature);
        descriptor = new SignatureRSASHA256();
        Assert.assertEquals((String)descriptor.getDigest(), (String)"SHA-256");
        Assert.assertEquals((String)descriptor.getJCAAlgorithmID(), (String)"SHA256withRSA");
        Assert.assertEquals((String)descriptor.getKey(), (String)"RSA");
        Assert.assertEquals((String)descriptor.getURI(), (String)"http://www.w3.org/2001/04/xmldsig-more#rsa-sha256");
        Assert.assertEquals((Object)descriptor.getType(), (Object)AlgorithmDescriptor.AlgorithmType.Signature);
        descriptor = new SignatureRSASHA384();
        Assert.assertEquals((String)descriptor.getDigest(), (String)"SHA-384");
        Assert.assertEquals((String)descriptor.getJCAAlgorithmID(), (String)"SHA384withRSA");
        Assert.assertEquals((String)descriptor.getKey(), (String)"RSA");
        Assert.assertEquals((String)descriptor.getURI(), (String)"http://www.w3.org/2001/04/xmldsig-more#rsa-sha384");
        Assert.assertEquals((Object)descriptor.getType(), (Object)AlgorithmDescriptor.AlgorithmType.Signature);
        descriptor = new SignatureRSASHA512();
        Assert.assertEquals((String)descriptor.getDigest(), (String)"SHA-512");
        Assert.assertEquals((String)descriptor.getJCAAlgorithmID(), (String)"SHA512withRSA");
        Assert.assertEquals((String)descriptor.getKey(), (String)"RSA");
        Assert.assertEquals((String)descriptor.getURI(), (String)"http://www.w3.org/2001/04/xmldsig-more#rsa-sha512");
        Assert.assertEquals((Object)descriptor.getType(), (Object)AlgorithmDescriptor.AlgorithmType.Signature);
    }

    @Test
    public void testSymmetricKeyWrap() {
        SymmetricKeyWrapAES128 descriptor = new SymmetricKeyWrapAES128();
        Assert.assertEquals((String)descriptor.getJCAAlgorithmID(), (String)"AESWrap");
        Assert.assertEquals((String)descriptor.getKey(), (String)"AES");
        Assert.assertEquals((String)descriptor.getURI(), (String)"http://www.w3.org/2001/04/xmlenc#kw-aes128");
        Assert.assertEquals((Object)descriptor.getKeyLength(), (Object)128);
        Assert.assertEquals((Object)descriptor.getType(), (Object)AlgorithmDescriptor.AlgorithmType.SymmetricKeyWrap);
        descriptor = new SymmetricKeyWrapAES192();
        Assert.assertEquals((String)descriptor.getJCAAlgorithmID(), (String)"AESWrap");
        Assert.assertEquals((String)descriptor.getKey(), (String)"AES");
        Assert.assertEquals((String)descriptor.getURI(), (String)"http://www.w3.org/2001/04/xmlenc#kw-aes192");
        Assert.assertEquals((Object)descriptor.getKeyLength(), (Object)192);
        Assert.assertEquals((Object)descriptor.getType(), (Object)AlgorithmDescriptor.AlgorithmType.SymmetricKeyWrap);
        descriptor = new SymmetricKeyWrapAES256();
        Assert.assertEquals((String)descriptor.getJCAAlgorithmID(), (String)"AESWrap");
        Assert.assertEquals((String)descriptor.getKey(), (String)"AES");
        Assert.assertEquals((String)descriptor.getURI(), (String)"http://www.w3.org/2001/04/xmlenc#kw-aes256");
        Assert.assertEquals((Object)descriptor.getKeyLength(), (Object)256);
        Assert.assertEquals((Object)descriptor.getType(), (Object)AlgorithmDescriptor.AlgorithmType.SymmetricKeyWrap);
        descriptor = new SymmetricKeyWrapDESede();
        Assert.assertEquals((String)descriptor.getJCAAlgorithmID(), (String)"DESedeWrap");
        Assert.assertEquals((String)descriptor.getKey(), (String)"DESede");
        Assert.assertEquals((String)descriptor.getURI(), (String)"http://www.w3.org/2001/04/xmlenc#kw-tripledes");
        Assert.assertEquals((Object)descriptor.getKeyLength(), (Object)192);
        Assert.assertEquals((Object)descriptor.getType(), (Object)AlgorithmDescriptor.AlgorithmType.SymmetricKeyWrap);
    }
}

