/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.xmlsec.algorithm;

import java.util.Objects;
import java.util.Set;
import org.opensaml.core.config.ConfigurationService;
import org.opensaml.core.config.InitializationException;
import org.opensaml.core.testing.OpenSAMLInitBaseTestCase;
import org.opensaml.security.testing.SecurityProviderTestSupport;
import org.opensaml.xmlsec.algorithm.AlgorithmDescriptor;
import org.opensaml.xmlsec.algorithm.AlgorithmRegistry;
import org.opensaml.xmlsec.algorithm.AlgorithmSupport;
import org.opensaml.xmlsec.algorithm.descriptors.DigestSHA256;
import org.opensaml.xmlsec.algorithm.descriptors.SignatureRSASHA256;
import org.opensaml.xmlsec.config.GlobalAlgorithmRegistryInitializer;
import org.testng.Assert;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Test;

public class AlgorithmRegistryTest
extends OpenSAMLInitBaseTestCase {
    private SecurityProviderTestSupport providerSupport = new SecurityProviderTestSupport();

    @DataProvider
    public Object[][] loadBCTestData() {
        return new Object[][]{{Boolean.FALSE}, {Boolean.TRUE}};
    }

    @Test
    public void testRegistrationAndDeregistration() {
        AlgorithmRegistry registry = new AlgorithmRegistry();
        Assert.assertNull((Object)registry.get("http://www.w3.org/2001/04/xmldsig-more#rsa-sha256"));
        Assert.assertNull((Object)registry.get("http://www.w3.org/2001/04/xmlenc#sha256"));
        registry.register((AlgorithmDescriptor)new SignatureRSASHA256());
        registry.register((AlgorithmDescriptor)new DigestSHA256());
        Assert.assertNotNull((Object)registry.get("http://www.w3.org/2001/04/xmldsig-more#rsa-sha256"));
        Assert.assertNotNull((Object)registry.get("http://www.w3.org/2001/04/xmlenc#sha256"));
        registry.deregister((AlgorithmDescriptor)new SignatureRSASHA256());
        Assert.assertNull((Object)registry.get("http://www.w3.org/2001/04/xmldsig-more#rsa-sha256"));
        registry.deregister("http://www.w3.org/2001/04/xmlenc#sha256");
        Assert.assertNull((Object)registry.get("http://www.w3.org/2001/04/xmlenc#sha256"));
    }

    @Test
    public void testTypeIndexing() {
        AlgorithmRegistry registry = new AlgorithmRegistry();
        Assert.assertNull((Object)registry.get("http://www.w3.org/2001/04/xmlenc#sha256"));
        Assert.assertTrue((boolean)registry.getRegisteredURIsByType(AlgorithmDescriptor.AlgorithmType.MessageDigest).isEmpty());
        Assert.assertTrue((boolean)registry.getRegisteredByType(AlgorithmDescriptor.AlgorithmType.MessageDigest).isEmpty());
        registry.register((AlgorithmDescriptor)new DigestSHA256());
        Assert.assertEquals((int)registry.getRegisteredURIsByType(AlgorithmDescriptor.AlgorithmType.MessageDigest).size(), (int)1);
        Assert.assertTrue((boolean)registry.getRegisteredURIsByType(AlgorithmDescriptor.AlgorithmType.MessageDigest).contains("http://www.w3.org/2001/04/xmlenc#sha256"));
        Assert.assertEquals((int)registry.getRegisteredByType(AlgorithmDescriptor.AlgorithmType.MessageDigest).size(), (int)1);
        Assert.assertTrue((boolean)DigestSHA256.class.isInstance(registry.getRegisteredByType(AlgorithmDescriptor.AlgorithmType.MessageDigest).iterator().next()));
        registry.deregister((AlgorithmDescriptor)new DigestSHA256());
        Assert.assertTrue((boolean)registry.getRegisteredURIsByType(AlgorithmDescriptor.AlgorithmType.MessageDigest).isEmpty());
        Assert.assertTrue((boolean)registry.getRegisteredByType(AlgorithmDescriptor.AlgorithmType.MessageDigest).isEmpty());
    }

    @Test
    public void testSignatureIndexing() {
        AlgorithmRegistry registry = new AlgorithmRegistry();
        Assert.assertNull((Object)registry.get("http://www.w3.org/2001/04/xmldsig-more#rsa-sha256"));
        Assert.assertNull((Object)registry.getSignatureAlgorithm("RSA", "SHA-256"));
        registry.register((AlgorithmDescriptor)new SignatureRSASHA256());
        Assert.assertNotNull((Object)registry.get("http://www.w3.org/2001/04/xmldsig-more#rsa-sha256"));
        Assert.assertNotNull((Object)registry.getSignatureAlgorithm("RSA", "SHA-256"));
        registry.deregister((AlgorithmDescriptor)new SignatureRSASHA256());
        Assert.assertNull((Object)registry.get("http://www.w3.org/2001/04/xmldsig-more#rsa-sha256"));
        Assert.assertNull((Object)registry.getSignatureAlgorithm("RSA", "SHA-256"));
    }

    @Test
    public void testDigestIndexing() {
        AlgorithmRegistry registry = new AlgorithmRegistry();
        Assert.assertNull((Object)registry.get("http://www.w3.org/2001/04/xmlenc#sha256"));
        Assert.assertNull((Object)registry.getDigestAlgorithm("SHA-256"));
        registry.register((AlgorithmDescriptor)new DigestSHA256());
        Assert.assertNotNull((Object)registry.get("http://www.w3.org/2001/04/xmlenc#sha256"));
        Assert.assertNotNull((Object)registry.getDigestAlgorithm("SHA-256"));
        registry.deregister((AlgorithmDescriptor)new DigestSHA256());
        Assert.assertNull((Object)registry.get("http://www.w3.org/2001/04/xmlenc#sha256"));
        Assert.assertNull((Object)registry.getDigestAlgorithm("SHA-256"));
    }

    @Test
    public void testGlobalRegistryPresence() {
        AlgorithmRegistry registry = AlgorithmSupport.getGlobalAlgorithmRegistry();
        Assert.assertNotNull((Object)registry);
        Assert.assertNotNull((Object)registry.get("http://www.w3.org/2001/04/xmlenc#aes128-cbc"));
        Assert.assertNotNull((Object)registry.get("http://www.w3.org/2009/xmlenc11#aes128-gcm"));
        Assert.assertNotNull((Object)registry.get("http://www.w3.org/2001/04/xmlenc#aes192-cbc"));
        Assert.assertNotNull((Object)registry.get("http://www.w3.org/2009/xmlenc11#aes192-gcm"));
        Assert.assertNotNull((Object)registry.get("http://www.w3.org/2001/04/xmlenc#aes256-cbc"));
        Assert.assertNotNull((Object)registry.get("http://www.w3.org/2009/xmlenc11#aes256-gcm"));
        Assert.assertNotNull((Object)registry.get("http://www.w3.org/2001/04/xmlenc#tripledes-cbc"));
        Assert.assertNotNull((Object)registry.get("http://www.w3.org/2001/04/xmldsig-more#md5"));
        Assert.assertNotNull((Object)registry.get("http://www.w3.org/2001/04/xmlenc#ripemd160"));
        Assert.assertNotNull((Object)registry.get("http://www.w3.org/2000/09/xmldsig#sha1"));
        Assert.assertNotNull((Object)registry.get("http://www.w3.org/2001/04/xmldsig-more#sha224"));
        Assert.assertNotNull((Object)registry.get("http://www.w3.org/2001/04/xmlenc#sha256"));
        Assert.assertNotNull((Object)registry.get("http://www.w3.org/2001/04/xmldsig-more#sha384"));
        Assert.assertNotNull((Object)registry.get("http://www.w3.org/2001/04/xmlenc#sha512"));
        Assert.assertNotNull((Object)registry.get("http://www.w3.org/2001/04/xmldsig-more#hmac-md5"));
        Assert.assertNotNull((Object)registry.get("http://www.w3.org/2001/04/xmldsig-more#hmac-ripemd160"));
        Assert.assertNotNull((Object)registry.get("http://www.w3.org/2000/09/xmldsig#hmac-sha1"));
        Assert.assertNotNull((Object)registry.get("http://www.w3.org/2001/04/xmldsig-more#hmac-sha224"));
        Assert.assertNotNull((Object)registry.get("http://www.w3.org/2001/04/xmldsig-more#hmac-sha256"));
        Assert.assertNotNull((Object)registry.get("http://www.w3.org/2001/04/xmldsig-more#hmac-sha384"));
        Assert.assertNotNull((Object)registry.get("http://www.w3.org/2001/04/xmldsig-more#hmac-sha512"));
        Assert.assertNotNull((Object)registry.get("http://www.w3.org/2001/04/xmlenc#dh"));
        Assert.assertNotNull((Object)registry.get("http://www.w3.org/2009/xmlenc11#dh-es"));
        Assert.assertNotNull((Object)registry.get("http://www.w3.org/2009/xmlenc11#ECDH-ES"));
        Assert.assertNotNull((Object)registry.get("http://www.w3.org/2001/04/xmlenc#rsa-1_5"));
        Assert.assertNotNull((Object)registry.get("http://www.w3.org/2001/04/xmlenc#rsa-oaep-mgf1p"));
        Assert.assertNotNull((Object)registry.get("http://www.w3.org/2009/xmlenc11#rsa-oaep"));
        Assert.assertNotNull((Object)registry.get("http://www.w3.org/2000/09/xmldsig#dsa-sha1"));
        Assert.assertNotNull((Object)registry.get("http://www.w3.org/2009/xmldsig11#dsa-sha256"));
        Assert.assertNotNull((Object)registry.get("http://www.w3.org/2001/04/xmldsig-more#ecdsa-sha1"));
        Assert.assertNotNull((Object)registry.get("http://www.w3.org/2001/04/xmldsig-more#ecdsa-sha224"));
        Assert.assertNotNull((Object)registry.get("http://www.w3.org/2001/04/xmldsig-more#ecdsa-sha256"));
        Assert.assertNotNull((Object)registry.get("http://www.w3.org/2001/04/xmldsig-more#ecdsa-sha384"));
        Assert.assertNotNull((Object)registry.get("http://www.w3.org/2001/04/xmldsig-more#ecdsa-sha512"));
        Assert.assertNotNull((Object)registry.get("http://www.w3.org/2001/04/xmldsig-more#rsa-md5"));
        Assert.assertNotNull((Object)registry.get("http://www.w3.org/2001/04/xmldsig-more#rsa-ripemd160"));
        Assert.assertNotNull((Object)registry.get("http://www.w3.org/2000/09/xmldsig#rsa-sha1"));
        Assert.assertNotNull((Object)registry.get("http://www.w3.org/2001/04/xmldsig-more#rsa-sha224"));
        Assert.assertNotNull((Object)registry.get("http://www.w3.org/2001/04/xmldsig-more#rsa-sha256"));
        Assert.assertNotNull((Object)registry.get("http://www.w3.org/2001/04/xmldsig-more#rsa-sha384"));
        Assert.assertNotNull((Object)registry.get("http://www.w3.org/2001/04/xmldsig-more#rsa-sha512"));
        Assert.assertNotNull((Object)registry.get("http://www.w3.org/2001/04/xmlenc#kw-aes128"));
        Assert.assertNotNull((Object)registry.get("http://www.w3.org/2001/04/xmlenc#kw-aes192"));
        Assert.assertNotNull((Object)registry.get("http://www.w3.org/2001/04/xmlenc#kw-aes256"));
        Assert.assertNotNull((Object)registry.get("http://www.w3.org/2001/04/xmlenc#kw-tripledes"));
    }

    @Test
    public void testGlobalRegistryGetByType() {
        AlgorithmRegistry registry = AlgorithmSupport.getGlobalAlgorithmRegistry();
        Assert.assertNotNull((Object)registry);
        Set byType = null;
        byType = registry.getRegisteredURIsByType(AlgorithmDescriptor.AlgorithmType.BlockEncryption);
        Assert.assertTrue((boolean)byType.contains("http://www.w3.org/2001/04/xmlenc#aes128-cbc"));
        Assert.assertTrue((boolean)byType.contains("http://www.w3.org/2009/xmlenc11#aes128-gcm"));
        Assert.assertTrue((boolean)byType.contains("http://www.w3.org/2001/04/xmlenc#aes192-cbc"));
        Assert.assertTrue((boolean)byType.contains("http://www.w3.org/2009/xmlenc11#aes192-gcm"));
        Assert.assertTrue((boolean)byType.contains("http://www.w3.org/2001/04/xmlenc#aes256-cbc"));
        Assert.assertTrue((boolean)byType.contains("http://www.w3.org/2009/xmlenc11#aes256-gcm"));
        Assert.assertTrue((boolean)byType.contains("http://www.w3.org/2001/04/xmlenc#tripledes-cbc"));
        Assert.assertEquals((long)registry.getRegisteredByType(AlgorithmDescriptor.AlgorithmType.BlockEncryption).stream().filter(Objects::nonNull).count(), (long)byType.size());
        byType = registry.getRegisteredURIsByType(AlgorithmDescriptor.AlgorithmType.MessageDigest);
        Assert.assertTrue((boolean)byType.contains("http://www.w3.org/2001/04/xmldsig-more#md5"));
        Assert.assertTrue((boolean)byType.contains("http://www.w3.org/2001/04/xmlenc#ripemd160"));
        Assert.assertTrue((boolean)byType.contains("http://www.w3.org/2000/09/xmldsig#sha1"));
        Assert.assertTrue((boolean)byType.contains("http://www.w3.org/2001/04/xmldsig-more#sha224"));
        Assert.assertTrue((boolean)byType.contains("http://www.w3.org/2001/04/xmlenc#sha256"));
        Assert.assertTrue((boolean)byType.contains("http://www.w3.org/2001/04/xmldsig-more#sha384"));
        Assert.assertTrue((boolean)byType.contains("http://www.w3.org/2001/04/xmlenc#sha512"));
        Assert.assertEquals((long)registry.getRegisteredByType(AlgorithmDescriptor.AlgorithmType.MessageDigest).stream().filter(Objects::nonNull).count(), (long)byType.size());
        byType = registry.getRegisteredURIsByType(AlgorithmDescriptor.AlgorithmType.Mac);
        Assert.assertTrue((boolean)byType.contains("http://www.w3.org/2001/04/xmldsig-more#hmac-md5"));
        Assert.assertTrue((boolean)byType.contains("http://www.w3.org/2001/04/xmldsig-more#hmac-ripemd160"));
        Assert.assertTrue((boolean)byType.contains("http://www.w3.org/2000/09/xmldsig#hmac-sha1"));
        Assert.assertTrue((boolean)byType.contains("http://www.w3.org/2001/04/xmldsig-more#hmac-sha224"));
        Assert.assertTrue((boolean)byType.contains("http://www.w3.org/2001/04/xmldsig-more#hmac-sha256"));
        Assert.assertTrue((boolean)byType.contains("http://www.w3.org/2001/04/xmldsig-more#hmac-sha384"));
        Assert.assertTrue((boolean)byType.contains("http://www.w3.org/2001/04/xmldsig-more#hmac-sha512"));
        Assert.assertEquals((long)registry.getRegisteredByType(AlgorithmDescriptor.AlgorithmType.Mac).stream().filter(Objects::nonNull).count(), (long)byType.size());
        byType = registry.getRegisteredURIsByType(AlgorithmDescriptor.AlgorithmType.KeyAgreement);
        Assert.assertTrue((boolean)byType.contains("http://www.w3.org/2001/04/xmlenc#dh"));
        Assert.assertTrue((boolean)byType.contains("http://www.w3.org/2009/xmlenc11#dh-es"));
        Assert.assertTrue((boolean)byType.contains("http://www.w3.org/2009/xmlenc11#ECDH-ES"));
        Assert.assertEquals((long)registry.getRegisteredByType(AlgorithmDescriptor.AlgorithmType.KeyAgreement).stream().filter(Objects::nonNull).count(), (long)byType.size());
        byType = registry.getRegisteredURIsByType(AlgorithmDescriptor.AlgorithmType.KeyTransport);
        Assert.assertTrue((boolean)byType.contains("http://www.w3.org/2001/04/xmlenc#rsa-1_5"));
        Assert.assertTrue((boolean)byType.contains("http://www.w3.org/2001/04/xmlenc#rsa-oaep-mgf1p"));
        Assert.assertTrue((boolean)byType.contains("http://www.w3.org/2009/xmlenc11#rsa-oaep"));
        Assert.assertEquals((long)registry.getRegisteredByType(AlgorithmDescriptor.AlgorithmType.KeyTransport).stream().filter(Objects::nonNull).count(), (long)byType.size());
        byType = registry.getRegisteredURIsByType(AlgorithmDescriptor.AlgorithmType.Signature);
        Assert.assertTrue((boolean)byType.contains("http://www.w3.org/2000/09/xmldsig#dsa-sha1"));
        Assert.assertTrue((boolean)byType.contains("http://www.w3.org/2009/xmldsig11#dsa-sha256"));
        Assert.assertTrue((boolean)byType.contains("http://www.w3.org/2001/04/xmldsig-more#ecdsa-sha1"));
        Assert.assertTrue((boolean)byType.contains("http://www.w3.org/2001/04/xmldsig-more#ecdsa-sha224"));
        Assert.assertTrue((boolean)byType.contains("http://www.w3.org/2001/04/xmldsig-more#ecdsa-sha256"));
        Assert.assertTrue((boolean)byType.contains("http://www.w3.org/2001/04/xmldsig-more#ecdsa-sha384"));
        Assert.assertTrue((boolean)byType.contains("http://www.w3.org/2001/04/xmldsig-more#ecdsa-sha512"));
        Assert.assertTrue((boolean)byType.contains("http://www.w3.org/2001/04/xmldsig-more#rsa-md5"));
        Assert.assertTrue((boolean)byType.contains("http://www.w3.org/2001/04/xmldsig-more#rsa-ripemd160"));
        Assert.assertTrue((boolean)byType.contains("http://www.w3.org/2000/09/xmldsig#rsa-sha1"));
        Assert.assertTrue((boolean)byType.contains("http://www.w3.org/2001/04/xmldsig-more#rsa-sha224"));
        Assert.assertTrue((boolean)byType.contains("http://www.w3.org/2001/04/xmldsig-more#rsa-sha256"));
        Assert.assertTrue((boolean)byType.contains("http://www.w3.org/2001/04/xmldsig-more#rsa-sha384"));
        Assert.assertTrue((boolean)byType.contains("http://www.w3.org/2001/04/xmldsig-more#rsa-sha512"));
        Assert.assertEquals((long)registry.getRegisteredByType(AlgorithmDescriptor.AlgorithmType.Signature).stream().filter(Objects::nonNull).count(), (long)byType.size());
        byType = registry.getRegisteredURIsByType(AlgorithmDescriptor.AlgorithmType.SymmetricKeyWrap);
        Assert.assertTrue((boolean)byType.contains("http://www.w3.org/2001/04/xmlenc#kw-aes128"));
        Assert.assertTrue((boolean)byType.contains("http://www.w3.org/2001/04/xmlenc#kw-aes192"));
        Assert.assertTrue((boolean)byType.contains("http://www.w3.org/2001/04/xmlenc#kw-aes256"));
        Assert.assertTrue((boolean)byType.contains("http://www.w3.org/2001/04/xmlenc#kw-tripledes"));
        Assert.assertEquals((long)registry.getRegisteredByType(AlgorithmDescriptor.AlgorithmType.SymmetricKeyWrap).stream().filter(Objects::nonNull).count(), (long)byType.size());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(dataProvider="loadBCTestData")
    public void testGlobalRegistryRuntimeSupported(boolean loadBC) throws InitializationException {
        AlgorithmRegistry originalRegistry = AlgorithmSupport.getGlobalAlgorithmRegistry();
        Assert.assertNotNull((Object)originalRegistry);
        AlgorithmRegistry registry = originalRegistry;
        if (loadBC) {
            this.providerSupport.loadBC();
            new GlobalAlgorithmRegistryInitializer().init();
            registry = AlgorithmSupport.getGlobalAlgorithmRegistry();
        }
        Assert.assertNotNull((Object)registry);
        try {
            Assert.assertTrue((boolean)registry.isRuntimeSupported("http://www.w3.org/2001/04/xmlenc#aes128-cbc"));
            Assert.assertTrue((boolean)registry.isRuntimeSupported("http://www.w3.org/2001/04/xmlenc#aes192-cbc"));
            Assert.assertTrue((boolean)registry.isRuntimeSupported("http://www.w3.org/2001/04/xmlenc#aes256-cbc"));
            Assert.assertTrue((boolean)registry.isRuntimeSupported("http://www.w3.org/2001/04/xmlenc#tripledes-cbc"));
            Assert.assertTrue((boolean)registry.isRuntimeSupported("http://www.w3.org/2001/04/xmldsig-more#md5"));
            Assert.assertTrue((boolean)registry.isRuntimeSupported("http://www.w3.org/2000/09/xmldsig#sha1"));
            Assert.assertTrue((boolean)registry.isRuntimeSupported("http://www.w3.org/2001/04/xmlenc#sha256"));
            Assert.assertTrue((boolean)registry.isRuntimeSupported("http://www.w3.org/2001/04/xmldsig-more#sha384"));
            Assert.assertTrue((boolean)registry.isRuntimeSupported("http://www.w3.org/2001/04/xmlenc#sha512"));
            Assert.assertTrue((boolean)registry.isRuntimeSupported("http://www.w3.org/2001/04/xmldsig-more#hmac-md5"));
            Assert.assertTrue((boolean)registry.isRuntimeSupported("http://www.w3.org/2000/09/xmldsig#hmac-sha1"));
            Assert.assertTrue((boolean)registry.isRuntimeSupported("http://www.w3.org/2001/04/xmldsig-more#hmac-sha256"));
            Assert.assertTrue((boolean)registry.isRuntimeSupported("http://www.w3.org/2001/04/xmldsig-more#hmac-sha384"));
            Assert.assertTrue((boolean)registry.isRuntimeSupported("http://www.w3.org/2001/04/xmldsig-more#hmac-sha512"));
            Assert.assertTrue((boolean)registry.isRuntimeSupported("http://www.w3.org/2001/04/xmlenc#dh"));
            Assert.assertTrue((boolean)registry.isRuntimeSupported("http://www.w3.org/2009/xmlenc11#dh-es"));
            Assert.assertTrue((boolean)registry.isRuntimeSupported("http://www.w3.org/2001/04/xmlenc#rsa-1_5"));
            Assert.assertTrue((boolean)registry.isRuntimeSupported("http://www.w3.org/2001/04/xmlenc#rsa-oaep-mgf1p"));
            Assert.assertTrue((boolean)registry.isRuntimeSupported("http://www.w3.org/2000/09/xmldsig#dsa-sha1"));
            Assert.assertTrue((boolean)registry.isRuntimeSupported("http://www.w3.org/2001/04/xmldsig-more#rsa-md5"));
            Assert.assertTrue((boolean)registry.isRuntimeSupported("http://www.w3.org/2000/09/xmldsig#rsa-sha1"));
            Assert.assertTrue((boolean)registry.isRuntimeSupported("http://www.w3.org/2001/04/xmldsig-more#rsa-sha256"));
            Assert.assertTrue((boolean)registry.isRuntimeSupported("http://www.w3.org/2001/04/xmldsig-more#rsa-sha384"));
            Assert.assertTrue((boolean)registry.isRuntimeSupported("http://www.w3.org/2001/04/xmldsig-more#rsa-sha512"));
            Assert.assertTrue((boolean)registry.isRuntimeSupported("http://www.w3.org/2001/04/xmlenc#kw-aes128"));
            Assert.assertTrue((boolean)registry.isRuntimeSupported("http://www.w3.org/2001/04/xmlenc#kw-aes192"));
            Assert.assertTrue((boolean)registry.isRuntimeSupported("http://www.w3.org/2001/04/xmlenc#kw-aes256"));
            Assert.assertTrue((boolean)registry.isRuntimeSupported("http://www.w3.org/2001/04/xmlenc#kw-tripledes"));
            if (this.providerSupport.haveSunEC() || this.providerSupport.haveBC()) {
                Assert.assertTrue((boolean)registry.isRuntimeSupported("http://www.w3.org/2001/04/xmldsig-more#ecdsa-sha1"));
                Assert.assertTrue((boolean)registry.isRuntimeSupported("http://www.w3.org/2001/04/xmldsig-more#ecdsa-sha256"));
                Assert.assertTrue((boolean)registry.isRuntimeSupported("http://www.w3.org/2001/04/xmldsig-more#ecdsa-sha384"));
                Assert.assertTrue((boolean)registry.isRuntimeSupported("http://www.w3.org/2001/04/xmldsig-more#ecdsa-sha512"));
                Assert.assertTrue((boolean)registry.isRuntimeSupported("http://www.w3.org/2009/xmlenc11#ECDH-ES"));
                Assert.assertTrue((boolean)registry.isRuntimeSupported("http://www.w3.org/2001/04/xmldsig-more#ecdsa-sha224"));
            } else {
                Assert.assertFalse((boolean)registry.isRuntimeSupported("http://www.w3.org/2001/04/xmldsig-more#ecdsa-sha1"));
                Assert.assertFalse((boolean)registry.isRuntimeSupported("http://www.w3.org/2001/04/xmldsig-more#ecdsa-sha224"));
                Assert.assertFalse((boolean)registry.isRuntimeSupported("http://www.w3.org/2001/04/xmldsig-more#ecdsa-sha256"));
                Assert.assertFalse((boolean)registry.isRuntimeSupported("http://www.w3.org/2001/04/xmldsig-more#ecdsa-sha384"));
                Assert.assertFalse((boolean)registry.isRuntimeSupported("http://www.w3.org/2001/04/xmldsig-more#ecdsa-sha512"));
                Assert.assertFalse((boolean)registry.isRuntimeSupported("http://www.w3.org/2009/xmlenc11#ECDH-ES"));
            }
            Assert.assertTrue((boolean)registry.isRuntimeSupported("http://www.w3.org/2001/04/xmldsig-more#sha224"));
            Assert.assertTrue((boolean)registry.isRuntimeSupported("http://www.w3.org/2001/04/xmldsig-more#rsa-sha224"));
            Assert.assertTrue((boolean)registry.isRuntimeSupported("http://www.w3.org/2001/04/xmldsig-more#hmac-sha224"));
            Assert.assertTrue((boolean)registry.isRuntimeSupported("http://www.w3.org/2009/xmldsig11#dsa-sha256"));
            Assert.assertTrue((boolean)registry.isRuntimeSupported("http://www.w3.org/2009/xmlenc11#aes128-gcm"));
            Assert.assertTrue((boolean)registry.isRuntimeSupported("http://www.w3.org/2009/xmlenc11#aes192-gcm"));
            Assert.assertTrue((boolean)registry.isRuntimeSupported("http://www.w3.org/2009/xmlenc11#aes256-gcm"));
            Assert.assertTrue((boolean)registry.isRuntimeSupported("http://www.w3.org/2009/xmlenc11#rsa-oaep"));
            if (this.providerSupport.haveBC()) {
                Assert.assertTrue((boolean)registry.isRuntimeSupported("http://www.w3.org/2001/04/xmlenc#ripemd160"));
                Assert.assertTrue((boolean)registry.isRuntimeSupported("http://www.w3.org/2001/04/xmldsig-more#hmac-ripemd160"));
                Assert.assertTrue((boolean)registry.isRuntimeSupported("http://www.w3.org/2001/04/xmldsig-more#rsa-ripemd160"));
            } else {
                Assert.assertFalse((boolean)registry.isRuntimeSupported("http://www.w3.org/2001/04/xmlenc#ripemd160"));
                Assert.assertFalse((boolean)registry.isRuntimeSupported("http://www.w3.org/2001/04/xmldsig-more#hmac-ripemd160"));
                Assert.assertFalse((boolean)registry.isRuntimeSupported("http://www.w3.org/2001/04/xmldsig-more#rsa-ripemd160"));
            }
        }
        finally {
            this.providerSupport.unloadBC();
            ConfigurationService.register(AlgorithmRegistry.class, (Object)originalRegistry);
        }
    }
}

