/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.xmlsec.derivation;

import org.opensaml.core.testing.OpenSAMLInitBaseTestCase;
import org.opensaml.xmlsec.derivation.KeyDerivationException;
import org.opensaml.xmlsec.derivation.KeyDerivationSupport;
import org.testng.Assert;
import org.testng.annotations.Test;

public class KeyDerivationSupportTest
extends OpenSAMLInitBaseTestCase {
    @Test
    public void getJCAKeyAlgorithm() throws Exception {
        Assert.assertEquals((String)KeyDerivationSupport.getJCAKeyAlgorithm((String)"http://www.w3.org/2009/xmlenc11#aes128-gcm"), (String)"AES");
        Assert.assertEquals((String)KeyDerivationSupport.getJCAKeyAlgorithm((String)"http://www.w3.org/2001/04/xmlenc#tripledes-cbc"), (String)"DESede");
        Assert.assertEquals((String)KeyDerivationSupport.getJCAKeyAlgorithm((String)"http://www.w3.org/2001/04/xmlenc#kw-aes128"), (String)"AES");
        try {
            KeyDerivationSupport.getJCAKeyAlgorithm((String)"INVALID");
            Assert.fail((String)"Should have failed invalid URI");
        }
        catch (KeyDerivationException keyDerivationException) {
            // empty catch block
        }
    }

    @Test
    public void getEffectiveKeyLength() throws Exception {
        Assert.assertEquals((int)KeyDerivationSupport.getEffectiveKeyLength((String)"http://www.w3.org/2009/xmlenc11#aes128-gcm", null), (int)128);
        Assert.assertEquals((int)KeyDerivationSupport.getEffectiveKeyLength((String)"http://www.w3.org/2009/xmlenc11#aes128-gcm", (Integer)128), (int)128);
        Assert.assertEquals((int)KeyDerivationSupport.getEffectiveKeyLength((String)"http://www.w3.org/2001/04/xmlenc#tripledes-cbc", null), (int)192);
        Assert.assertEquals((int)KeyDerivationSupport.getEffectiveKeyLength((String)"http://www.w3.org/2001/04/xmlenc#tripledes-cbc", (Integer)192), (int)192);
        Assert.assertEquals((int)KeyDerivationSupport.getEffectiveKeyLength((String)"http://www.w3.org/2001/04/xmlenc#kw-aes128", null), (int)128);
        Assert.assertEquals((int)KeyDerivationSupport.getEffectiveKeyLength((String)"http://www.w3.org/2001/04/xmlenc#kw-aes128", (Integer)128), (int)128);
        Assert.assertEquals((int)KeyDerivationSupport.getEffectiveKeyLength((String)"SomeAlgo", (Integer)128), (int)128);
        try {
            KeyDerivationSupport.getEffectiveKeyLength((String)"http://www.w3.org/2009/xmlenc11#aes128-gcm", (Integer)256);
            Assert.fail((String)"Should have failed mismatched specified length");
        }
        catch (KeyDerivationException keyDerivationException) {
            // empty catch block
        }
        try {
            KeyDerivationSupport.getEffectiveKeyLength((String)"SomeAlgo", null);
            Assert.fail((String)"Should have failed non-length URI and null specified length");
        }
        catch (KeyDerivationException keyDerivationException) {
            // empty catch block
        }
    }
}

