/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.xmlsec.encryption.support;

import org.opensaml.xmlsec.encryption.support.RSAOAEPParameters;
import org.testng.Assert;
import org.testng.annotations.Test;

public class RSAOAEPParametersTest {
    @Test
    public void testConstructor() {
        RSAOAEPParameters params = new RSAOAEPParameters();
        Assert.assertNull((Object)params.getDigestMethod());
        Assert.assertNull((Object)params.getMaskGenerationFunction());
        Assert.assertNull((Object)params.getOAEPParams());
        params = new RSAOAEPParameters("  digest  ", "  MGF  ", " OAEPParams    ");
        Assert.assertEquals((String)params.getDigestMethod(), (String)"digest");
        Assert.assertEquals((String)params.getMaskGenerationFunction(), (String)"MGF");
        Assert.assertEquals((String)params.getOAEPParams(), (String)"OAEPParams");
    }

    @Test
    public void testGettersAndSetters() {
        RSAOAEPParameters params = new RSAOAEPParameters();
        params.setDigestMethod("  digest   ");
        params.setMaskGenerationFunction("    MGF    ");
        params.setOAEPparams("    OAEPParams     ");
        Assert.assertEquals((String)params.getDigestMethod(), (String)"digest");
        Assert.assertEquals((String)params.getMaskGenerationFunction(), (String)"MGF");
        Assert.assertEquals((String)params.getOAEPParams(), (String)"OAEPParams");
    }

    @Test
    public void testIsEmpty() {
        RSAOAEPParameters params = new RSAOAEPParameters();
        Assert.assertTrue((boolean)params.isEmpty());
        params = new RSAOAEPParameters(null, null, null);
        Assert.assertTrue((boolean)params.isEmpty());
        params = new RSAOAEPParameters("digest", null, null);
        Assert.assertFalse((boolean)params.isEmpty());
        params = new RSAOAEPParameters(null, "MGF", null);
        Assert.assertFalse((boolean)params.isEmpty());
        params = new RSAOAEPParameters(null, null, "OAEPParams");
        Assert.assertFalse((boolean)params.isEmpty());
    }

    @Test
    public void testIsComplete() {
        RSAOAEPParameters params = new RSAOAEPParameters();
        Assert.assertFalse((boolean)params.isComplete());
        params = new RSAOAEPParameters(null, null, null);
        Assert.assertFalse((boolean)params.isComplete());
        params = new RSAOAEPParameters("digest", null, null);
        Assert.assertFalse((boolean)params.isComplete());
        params = new RSAOAEPParameters("digest", "MGF", null);
        Assert.assertFalse((boolean)params.isComplete());
        params = new RSAOAEPParameters("digest", null, "OAEPParams");
        Assert.assertFalse((boolean)params.isComplete());
        params = new RSAOAEPParameters(null, "MGF", null);
        Assert.assertFalse((boolean)params.isComplete());
        params = new RSAOAEPParameters(null, "MGF", "OAEPParams");
        Assert.assertFalse((boolean)params.isComplete());
        params = new RSAOAEPParameters(null, null, "OAEPParams");
        Assert.assertFalse((boolean)params.isComplete());
        params = new RSAOAEPParameters("digest", "MGF", "OAEPParams");
        Assert.assertTrue((boolean)params.isComplete());
    }
}

