/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.xmlsec.agreement.impl;

import java.security.Key;
import java.security.KeyPair;
import java.security.PrivateKey;
import java.security.PublicKey;
import org.opensaml.core.testing.OpenSAMLInitBaseTestCase;
import org.opensaml.security.credential.BasicCredential;
import org.opensaml.security.credential.Credential;
import org.opensaml.security.credential.CredentialSupport;
import org.opensaml.security.crypto.KeySupport;
import org.opensaml.xmlsec.agreement.KeyAgreementCredential;
import org.opensaml.xmlsec.agreement.KeyAgreementException;
import org.opensaml.xmlsec.agreement.KeyAgreementParameters;
import org.opensaml.xmlsec.agreement.impl.DHWithLegacyKDFKeyAgreementProcessor;
import org.opensaml.xmlsec.agreement.impl.DigestMethod;
import org.opensaml.xmlsec.agreement.impl.KANonce;
import org.opensaml.xmlsec.agreement.impl.KeySize;
import org.opensaml.xmlsec.agreement.impl.PrivateCredential;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public class DHWithLegacyKDFKeyAgreementProcessorTest
extends OpenSAMLInitBaseTestCase {
    private DHWithLegacyKDFKeyAgreementProcessor processor;

    @BeforeMethod
    public void setUp() {
        this.processor = new DHWithLegacyKDFKeyAgreementProcessor();
    }

    @Test
    public void encryptingCase() throws Exception {
        KeyPair recipientKeyPair = KeySupport.generateKeyPair((String)"DiffieHellman", (int)2048, null);
        BasicCredential recipientCredential = CredentialSupport.getSimpleCredential((PublicKey)recipientKeyPair.getPublic(), null);
        KeyAgreementParameters params = new KeyAgreementParameters();
        DigestMethod dm = new DigestMethod();
        dm.setAlgorithm("http://www.w3.org/2001/04/xmlenc#sha256");
        dm.initialize();
        params.add((Object)dm);
        KANonce nonce = new KANonce();
        nonce.setValue("AABBCCDD");
        nonce.initialize();
        params.add((Object)nonce);
        KeyAgreementCredential keyAgreementCredential = this.processor.execute((Credential)recipientCredential, "http://www.w3.org/2001/04/xmlenc#aes128-cbc", params);
        Assert.assertNotNull((Object)keyAgreementCredential);
        Assert.assertNotNull((Object)keyAgreementCredential.getSecretKey());
        Assert.assertEquals((String)keyAgreementCredential.getSecretKey().getAlgorithm(), (String)"AES");
        Assert.assertEquals((Object)KeySupport.getKeyLength((Key)keyAgreementCredential.getSecretKey()), (Object)128);
        Assert.assertNull((Object)keyAgreementCredential.getPublicKey());
        Assert.assertNull((Object)keyAgreementCredential.getPrivateKey());
        Assert.assertNotNull((Object)keyAgreementCredential.getRecipientCredential());
        Assert.assertNotNull((Object)keyAgreementCredential.getRecipientCredential().getPublicKey());
        Assert.assertNull((Object)keyAgreementCredential.getRecipientCredential().getPrivateKey());
        Assert.assertNull((Object)keyAgreementCredential.getRecipientCredential().getSecretKey());
        Assert.assertNotNull((Object)keyAgreementCredential.getOriginatorCredential());
        Assert.assertNotNull((Object)keyAgreementCredential.getOriginatorCredential().getPublicKey());
        Assert.assertNotNull((Object)keyAgreementCredential.getOriginatorCredential().getPrivateKey());
        Assert.assertNull((Object)keyAgreementCredential.getOriginatorCredential().getSecretKey());
        Assert.assertEquals((String)keyAgreementCredential.getAlgorithm(), (String)"http://www.w3.org/2001/04/xmlenc#dh");
        Assert.assertEquals((int)keyAgreementCredential.getParameters().size(), (int)2);
        Assert.assertTrue((boolean)keyAgreementCredential.getParameters().contains(DigestMethod.class));
        Assert.assertEquals((String)((DigestMethod)keyAgreementCredential.getParameters().get(DigestMethod.class)).getAlgorithm(), (String)"http://www.w3.org/2001/04/xmlenc#sha256");
        Assert.assertTrue((boolean)keyAgreementCredential.getParameters().contains(KANonce.class));
        Assert.assertEquals((String)((KANonce)keyAgreementCredential.getParameters().get(KANonce.class)).getValue(), (String)"AABBCCDD");
    }

    @Test
    public void decryptingCase() throws Exception {
        KeyPair originatorKeyPair = KeySupport.generateKeyPair((String)"DiffieHellman", (int)2048, null);
        BasicCredential originatorCredential = CredentialSupport.getSimpleCredential((PublicKey)originatorKeyPair.getPublic(), null);
        KeyPair recipientKeyPair = KeySupport.generateKeyPair((String)"DiffieHellman", (int)2048, null);
        BasicCredential recipientCredential = CredentialSupport.getSimpleCredential((PublicKey)recipientKeyPair.getPublic(), (PrivateKey)recipientKeyPair.getPrivate());
        KeyAgreementParameters params = new KeyAgreementParameters();
        params.add((Object)new PrivateCredential((Credential)recipientCredential));
        DigestMethod dm = new DigestMethod();
        dm.setAlgorithm("http://www.w3.org/2001/04/xmlenc#sha256");
        dm.initialize();
        params.add((Object)dm);
        KANonce nonce = new KANonce();
        nonce.setValue("AABBCCDD");
        nonce.initialize();
        params.add((Object)nonce);
        KeyAgreementCredential keyAgreementCredential = this.processor.execute((Credential)originatorCredential, "http://www.w3.org/2001/04/xmlenc#aes128-cbc", params);
        Assert.assertNotNull((Object)keyAgreementCredential);
        Assert.assertNotNull((Object)keyAgreementCredential.getSecretKey());
        Assert.assertEquals((String)keyAgreementCredential.getSecretKey().getAlgorithm(), (String)"AES");
        Assert.assertEquals((Object)KeySupport.getKeyLength((Key)keyAgreementCredential.getSecretKey()), (Object)128);
        Assert.assertNull((Object)keyAgreementCredential.getPublicKey());
        Assert.assertNull((Object)keyAgreementCredential.getPrivateKey());
        Assert.assertNotNull((Object)keyAgreementCredential.getRecipientCredential());
        Assert.assertNotNull((Object)keyAgreementCredential.getRecipientCredential().getPublicKey());
        Assert.assertNotNull((Object)keyAgreementCredential.getRecipientCredential().getPrivateKey());
        Assert.assertNull((Object)keyAgreementCredential.getRecipientCredential().getSecretKey());
        Assert.assertNotNull((Object)keyAgreementCredential.getOriginatorCredential());
        Assert.assertNotNull((Object)keyAgreementCredential.getOriginatorCredential().getPublicKey());
        Assert.assertNull((Object)keyAgreementCredential.getOriginatorCredential().getPrivateKey());
        Assert.assertNull((Object)keyAgreementCredential.getOriginatorCredential().getSecretKey());
        Assert.assertEquals((String)keyAgreementCredential.getAlgorithm(), (String)"http://www.w3.org/2001/04/xmlenc#dh");
        Assert.assertEquals((int)keyAgreementCredential.getParameters().size(), (int)3);
        Assert.assertTrue((boolean)keyAgreementCredential.getParameters().contains(PrivateCredential.class));
        Assert.assertTrue((boolean)keyAgreementCredential.getParameters().contains(DigestMethod.class));
        Assert.assertEquals((String)((DigestMethod)keyAgreementCredential.getParameters().get(DigestMethod.class)).getAlgorithm(), (String)"http://www.w3.org/2001/04/xmlenc#sha256");
        Assert.assertTrue((boolean)keyAgreementCredential.getParameters().contains(KANonce.class));
        Assert.assertEquals((String)((KANonce)keyAgreementCredential.getParameters().get(KANonce.class)).getValue(), (String)"AABBCCDD");
    }

    @Test(expectedExceptions={KeyAgreementException.class})
    public void nonECCred() throws Exception {
        KeyPair kp = KeySupport.generateKeyPair((String)"RSA", (int)2048, null);
        BasicCredential publicCredential = CredentialSupport.getSimpleCredential((PublicKey)kp.getPublic(), null);
        KeyAgreementParameters params = new KeyAgreementParameters();
        DigestMethod dm = new DigestMethod();
        dm.setAlgorithm("http://www.w3.org/2001/04/xmlenc#sha256");
        dm.initialize();
        params.add((Object)dm);
        KANonce nonce = new KANonce();
        nonce.setValue("AABBCCDD");
        nonce.initialize();
        params.add((Object)nonce);
        this.processor.execute((Credential)publicCredential, "http://www.w3.org/2001/04/xmlenc#aes128-cbc", params);
    }

    @Test(expectedExceptions={KeyAgreementException.class})
    public void invalidKeyAlgorithm() throws Exception {
        KeyPair kp = KeySupport.generateKeyPair((String)"DiffieHellman", (int)2048, null);
        BasicCredential publicCredential = CredentialSupport.getSimpleCredential((PublicKey)kp.getPublic(), null);
        KeyAgreementParameters params = new KeyAgreementParameters();
        DigestMethod dm = new DigestMethod();
        dm.setAlgorithm("http://www.w3.org/2001/04/xmlenc#sha256");
        dm.initialize();
        params.add((Object)dm);
        KANonce nonce = new KANonce();
        nonce.setValue("AABBCCDD");
        nonce.initialize();
        params.add((Object)nonce);
        this.processor.execute((Credential)publicCredential, "urn:test:InvalidBlockEncryption", params);
    }

    @Test(expectedExceptions={KeyAgreementException.class})
    public void specifiedKeySizeMismatch() throws Exception {
        KeyPair kp = KeySupport.generateKeyPair((String)"DiffieHellman", (int)2048, null);
        BasicCredential publicCredential = CredentialSupport.getSimpleCredential((PublicKey)kp.getPublic(), null);
        KeyAgreementParameters params = new KeyAgreementParameters();
        params.add((Object)new KeySize(Integer.valueOf(256)));
        DigestMethod dm = new DigestMethod();
        dm.setAlgorithm("http://www.w3.org/2001/04/xmlenc#sha256");
        dm.initialize();
        params.add((Object)dm);
        KANonce nonce = new KANonce();
        nonce.setValue("AABBCCDD");
        nonce.initialize();
        params.add((Object)nonce);
        this.processor.execute((Credential)publicCredential, "http://www.w3.org/2001/04/xmlenc#aes128-cbc", params);
    }
}

