/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.xmlsec.config.impl;

import java.util.Map;
import java.util.Properties;
import org.opensaml.core.config.provider.ThreadLocalConfigurationPropertiesHolder;
import org.opensaml.xmlsec.config.impl.DefaultSecurityConfigurationBootstrap;
import org.opensaml.xmlsec.derivation.KeyDerivation;
import org.opensaml.xmlsec.derivation.impl.ConcatKDF;
import org.opensaml.xmlsec.derivation.impl.PBKDF2;
import org.opensaml.xmlsec.encryption.support.KeyAgreementEncryptionConfiguration;
import org.testng.Assert;
import org.testng.annotations.Test;

public class DefaultSecurityConfigurationBootstrapTest {
    @Test
    public void testECDHDefaultKDF() {
        Map kaConfigs = DefaultSecurityConfigurationBootstrap.buildKeyAgreementConfigurations();
        Assert.assertTrue((boolean)kaConfigs.containsKey("EC"));
        KeyAgreementEncryptionConfiguration config = (KeyAgreementEncryptionConfiguration)kaConfigs.get("EC");
        KeyDerivation keyDerivation = config.getParameters().stream().filter(KeyDerivation.class::isInstance).map(KeyDerivation.class::cast).findFirst().orElse(null);
        Assert.assertNotNull((Object)keyDerivation);
        Assert.assertTrue((boolean)ConcatKDF.class.isInstance(keyDerivation));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testECDHConcatKDF() {
        try {
            Properties props = new Properties();
            props.setProperty("opensaml.config.ecdh.defaultKDF", "ConcatKDF");
            ThreadLocalConfigurationPropertiesHolder.setProperties((Properties)props);
            Map kaConfigs = DefaultSecurityConfigurationBootstrap.buildKeyAgreementConfigurations();
            Assert.assertTrue((boolean)kaConfigs.containsKey("EC"));
            KeyAgreementEncryptionConfiguration config = (KeyAgreementEncryptionConfiguration)kaConfigs.get("EC");
            KeyDerivation keyDerivation = config.getParameters().stream().filter(KeyDerivation.class::isInstance).map(KeyDerivation.class::cast).findFirst().orElse(null);
            Assert.assertNotNull((Object)keyDerivation);
            Assert.assertTrue((boolean)ConcatKDF.class.isInstance(keyDerivation));
        }
        finally {
            ThreadLocalConfigurationPropertiesHolder.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testECDHPBKDF2() {
        try {
            Properties props = new Properties();
            props.setProperty("opensaml.config.ecdh.defaultKDF", "PBKDF2");
            ThreadLocalConfigurationPropertiesHolder.setProperties((Properties)props);
            Map kaConfigs = DefaultSecurityConfigurationBootstrap.buildKeyAgreementConfigurations();
            Assert.assertTrue((boolean)kaConfigs.containsKey("EC"));
            KeyAgreementEncryptionConfiguration config = (KeyAgreementEncryptionConfiguration)kaConfigs.get("EC");
            KeyDerivation keyDerivation = config.getParameters().stream().filter(KeyDerivation.class::isInstance).map(KeyDerivation.class::cast).findFirst().orElse(null);
            Assert.assertNotNull((Object)keyDerivation);
            Assert.assertTrue((boolean)PBKDF2.class.isInstance(keyDerivation));
        }
        finally {
            ThreadLocalConfigurationPropertiesHolder.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testECDHBadKDF() {
        try {
            Properties props = new Properties();
            props.setProperty("opensaml.config.ecdh.defaultKDF", "BADBADBAD");
            ThreadLocalConfigurationPropertiesHolder.setProperties((Properties)props);
            Map kaConfigs = DefaultSecurityConfigurationBootstrap.buildKeyAgreementConfigurations();
            Assert.assertTrue((boolean)kaConfigs.containsKey("EC"));
            KeyAgreementEncryptionConfiguration config = (KeyAgreementEncryptionConfiguration)kaConfigs.get("EC");
            KeyDerivation keyDerivation = config.getParameters().stream().filter(KeyDerivation.class::isInstance).map(KeyDerivation.class::cast).findFirst().orElse(null);
            Assert.assertNull((Object)keyDerivation);
        }
        finally {
            ThreadLocalConfigurationPropertiesHolder.clear();
        }
    }
}

