/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.xmlsec.derivation.impl;

import javax.crypto.SecretKey;
import net.shibboleth.utilities.java.support.codec.EncodingException;
import net.shibboleth.utilities.java.support.component.ComponentInitializationException;
import org.apache.commons.codec.DecoderException;
import org.apache.commons.codec.binary.Hex;
import org.opensaml.core.testing.XMLObjectBaseTestCase;
import org.opensaml.core.xml.XMLObject;
import org.opensaml.core.xml.util.XMLObjectSupport;
import org.opensaml.xmlsec.derivation.KeyDerivationException;
import org.opensaml.xmlsec.derivation.impl.ConcatKDF;
import org.opensaml.xmlsec.encryption.ConcatKDFParams;
import org.opensaml.xmlsec.encryption.KeyDerivationMethod;
import org.opensaml.xmlsec.signature.DigestMethod;
import org.testng.Assert;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Test;

public class ConcatKDFTest
extends XMLObjectBaseTestCase {
    @Test
    public void defaultProperties() throws Exception {
        ConcatKDF kdf = new ConcatKDF();
        kdf.initialize();
        Assert.assertEquals((String)kdf.getAlgorithm(), (String)"http://www.w3.org/2009/xmlenc11#ConcatKDF");
        Assert.assertNull((Object)kdf.getAlgorithmID());
        Assert.assertNull((Object)kdf.getPartyUInfo());
        Assert.assertNull((Object)kdf.getPartyVInfo());
        Assert.assertNull((Object)kdf.getSuppPubInfo());
        Assert.assertNull((Object)kdf.getSuppPrivInfo());
        Assert.assertEquals((String)kdf.getDigestMethod(), (String)"http://www.w3.org/2001/04/xmlenc#sha256");
    }

    @Test
    public void explicitProperties() throws Exception {
        ConcatKDF kdf = new ConcatKDF();
        kdf.setAlgorithmID("  AA  ");
        kdf.setPartyUInfo("  BB  ");
        kdf.setPartyVInfo("  CC  ");
        kdf.setSuppPubInfo("  DD  ");
        kdf.setSuppPrivInfo("  EE  ");
        kdf.setDigestMethod("http://www.w3.org/2001/04/xmlenc#sha512");
        kdf.initialize();
        Assert.assertEquals((String)kdf.getAlgorithm(), (String)"http://www.w3.org/2009/xmlenc11#ConcatKDF");
        Assert.assertEquals((String)kdf.getAlgorithmID(), (String)"AA");
        Assert.assertEquals((String)kdf.getPartyUInfo(), (String)"BB");
        Assert.assertEquals((String)kdf.getPartyVInfo(), (String)"CC");
        Assert.assertEquals((String)kdf.getSuppPubInfo(), (String)"DD");
        Assert.assertEquals((String)kdf.getSuppPrivInfo(), (String)"EE");
        Assert.assertEquals((String)kdf.getDigestMethod(), (String)"http://www.w3.org/2001/04/xmlenc#sha512");
    }

    @Test(expectedExceptions={ComponentInitializationException.class})
    public void initNonDigestMethod() throws Exception {
        ConcatKDF kdf = new ConcatKDF();
        kdf.setDigestMethod("http://www.w3.org/2000/09/xmldsig#rsa-sha1");
        kdf.initialize();
    }

    @Test(expectedExceptions={ComponentInitializationException.class})
    public void initUnsupportedDigest() throws Exception {
        ConcatKDF kdf = new ConcatKDF();
        kdf.setDigestMethod("http://www.w3.org/2001/04/xmldsig-more#md5");
        kdf.initialize();
    }

    @Test(expectedExceptions={ComponentInitializationException.class})
    public void initBadAlgorithmID() throws Exception {
        ConcatKDF kdf = new ConcatKDF();
        kdf.setAlgorithmID("INVALID");
        kdf.initialize();
    }

    @Test(expectedExceptions={ComponentInitializationException.class})
    public void initBadPartyUInfo() throws Exception {
        ConcatKDF kdf = new ConcatKDF();
        kdf.setPartyUInfo("INVALID");
        kdf.initialize();
    }

    @Test(expectedExceptions={ComponentInitializationException.class})
    public void initBadPartyVInfo() throws Exception {
        ConcatKDF kdf = new ConcatKDF();
        kdf.setPartyVInfo("INVALID");
        kdf.initialize();
    }

    @Test(expectedExceptions={ComponentInitializationException.class})
    public void initBadSuppPubInfo() throws Exception {
        ConcatKDF kdf = new ConcatKDF();
        kdf.setSuppPubInfo("INVALID");
        kdf.initialize();
    }

    @Test(expectedExceptions={ComponentInitializationException.class})
    public void initBadSuppPrivInfo() throws Exception {
        ConcatKDF kdf = new ConcatKDF();
        kdf.setSuppPrivInfo("INVALID");
        kdf.initialize();
    }

    @Test
    public void xmlGenerationSuccess() throws Exception {
        ConcatKDF kdf = new ConcatKDF();
        kdf.setAlgorithmID("AA");
        kdf.setPartyUInfo("BB");
        kdf.setPartyVInfo("CC");
        kdf.setSuppPubInfo("DD");
        kdf.setSuppPrivInfo("EE");
        kdf.setDigestMethod("http://www.w3.org/2001/04/xmlenc#sha512");
        kdf.initialize();
        XMLObject xmlObject = kdf.buildXMLObject();
        Assert.assertNotNull((Object)xmlObject);
        Assert.assertTrue((boolean)KeyDerivationMethod.class.isInstance(xmlObject));
        KeyDerivationMethod kdm = (KeyDerivationMethod)KeyDerivationMethod.class.cast(xmlObject);
        Assert.assertEquals((String)kdm.getAlgorithm(), (String)"http://www.w3.org/2009/xmlenc11#ConcatKDF");
        Assert.assertEquals((int)kdm.getUnknownXMLObjects().size(), (int)1);
        ConcatKDFParams kdmParams = (ConcatKDFParams)ConcatKDFParams.class.cast(kdm.getUnknownXMLObjects().get(0));
        Assert.assertEquals((String)kdmParams.getAlgorithmID(), (String)"00AA");
        Assert.assertEquals((String)kdmParams.getPartyUInfo(), (String)"00BB");
        Assert.assertEquals((String)kdmParams.getPartyVInfo(), (String)"00CC");
        Assert.assertEquals((String)kdmParams.getSuppPubInfo(), (String)"00DD");
        Assert.assertEquals((String)kdmParams.getSuppPrivInfo(), (String)"00EE");
        Assert.assertNotNull((Object)kdmParams.getDigestMethod());
        Assert.assertEquals((String)kdmParams.getDigestMethod().getAlgorithm(), (String)"http://www.w3.org/2001/04/xmlenc#sha512");
    }

    @Test
    public void fromXMLObject_Basic() throws Exception {
        KeyDerivationMethod xmlKDM = (KeyDerivationMethod)this.buildXMLObject(KeyDerivationMethod.DEFAULT_ELEMENT_NAME);
        xmlKDM.setAlgorithm("http://www.w3.org/2009/xmlenc11#ConcatKDF");
        ConcatKDFParams xmlParams = (ConcatKDFParams)this.buildXMLObject(ConcatKDFParams.DEFAULT_ELEMENT_NAME);
        xmlKDM.getUnknownXMLObjects().add(xmlParams);
        DigestMethod xmlDigest = (DigestMethod)this.buildXMLObject(DigestMethod.DEFAULT_ELEMENT_NAME);
        xmlDigest.setAlgorithm("http://www.w3.org/2001/04/xmlenc#sha256");
        xmlParams.setDigestMethod(xmlDigest);
        xmlParams.setAlgorithmID("00AA");
        xmlParams.setPartyUInfo("00BB");
        xmlParams.setPartyVInfo("00CC");
        xmlParams.setSuppPubInfo("00DD");
        xmlParams.setSuppPrivInfo("00EE");
        ConcatKDF parameter = ConcatKDF.fromXMLObject((KeyDerivationMethod)xmlKDM);
        Assert.assertNotNull((Object)parameter);
        Assert.assertTrue((boolean)parameter.isInitialized());
        Assert.assertEquals((String)parameter.getAlgorithm(), (String)"http://www.w3.org/2009/xmlenc11#ConcatKDF");
        Assert.assertEquals((String)parameter.getDigestMethod(), (String)"http://www.w3.org/2001/04/xmlenc#sha256");
        Assert.assertEquals((String)parameter.getAlgorithmID(), (String)"AA");
        Assert.assertEquals((String)parameter.getPartyUInfo(), (String)"BB");
        Assert.assertEquals((String)parameter.getPartyVInfo(), (String)"CC");
        Assert.assertEquals((String)parameter.getSuppPubInfo(), (String)"DD");
        Assert.assertEquals((String)parameter.getSuppPrivInfo(), (String)"EE");
    }

    @Test
    public void fromXMLObject_NullBitstrings() throws Exception {
        KeyDerivationMethod xmlKDM = (KeyDerivationMethod)this.buildXMLObject(KeyDerivationMethod.DEFAULT_ELEMENT_NAME);
        xmlKDM.setAlgorithm("http://www.w3.org/2009/xmlenc11#ConcatKDF");
        ConcatKDFParams xmlParams = (ConcatKDFParams)this.buildXMLObject(ConcatKDFParams.DEFAULT_ELEMENT_NAME);
        xmlKDM.getUnknownXMLObjects().add(xmlParams);
        DigestMethod xmlDigest = (DigestMethod)this.buildXMLObject(DigestMethod.DEFAULT_ELEMENT_NAME);
        xmlDigest.setAlgorithm("http://www.w3.org/2001/04/xmlenc#sha256");
        xmlParams.setDigestMethod(xmlDigest);
        xmlParams.setAlgorithmID(null);
        xmlParams.setPartyUInfo(null);
        xmlParams.setPartyVInfo(null);
        xmlParams.setSuppPubInfo(null);
        xmlParams.setSuppPrivInfo(null);
        ConcatKDF parameter = ConcatKDF.fromXMLObject((KeyDerivationMethod)xmlKDM);
        Assert.assertNotNull((Object)parameter);
        Assert.assertTrue((boolean)parameter.isInitialized());
        Assert.assertEquals((String)parameter.getAlgorithm(), (String)"http://www.w3.org/2009/xmlenc11#ConcatKDF");
        Assert.assertEquals((String)parameter.getDigestMethod(), (String)"http://www.w3.org/2001/04/xmlenc#sha256");
        Assert.assertEquals((String)parameter.getAlgorithmID(), null);
        Assert.assertEquals((String)parameter.getPartyUInfo(), null);
        Assert.assertEquals((String)parameter.getPartyVInfo(), null);
        Assert.assertEquals((String)parameter.getSuppPubInfo(), null);
        Assert.assertEquals((String)parameter.getSuppPrivInfo(), null);
    }

    @Test
    public void fromXMLObject_EmptyBitstrings_OSJ_355() throws Exception {
        KeyDerivationMethod xmlKDM = (KeyDerivationMethod)this.buildXMLObject(KeyDerivationMethod.DEFAULT_ELEMENT_NAME);
        xmlKDM.setAlgorithm("http://www.w3.org/2009/xmlenc11#ConcatKDF");
        ConcatKDFParams xmlParams = (ConcatKDFParams)this.buildXMLObject(ConcatKDFParams.DEFAULT_ELEMENT_NAME);
        xmlKDM.getUnknownXMLObjects().add(xmlParams);
        DigestMethod xmlDigest = (DigestMethod)this.buildXMLObject(DigestMethod.DEFAULT_ELEMENT_NAME);
        xmlDigest.setAlgorithm("http://www.w3.org/2001/04/xmlenc#sha256");
        xmlParams.setDigestMethod(xmlDigest);
        xmlParams.setAlgorithmID("00");
        xmlParams.setPartyUInfo("00");
        xmlParams.setPartyVInfo("00");
        xmlParams.setSuppPubInfo("00");
        xmlParams.setSuppPrivInfo("00");
        ConcatKDF parameter = ConcatKDF.fromXMLObject((KeyDerivationMethod)xmlKDM);
        Assert.assertNotNull((Object)parameter);
        Assert.assertTrue((boolean)parameter.isInitialized());
        Assert.assertEquals((String)parameter.getAlgorithm(), (String)"http://www.w3.org/2009/xmlenc11#ConcatKDF");
        Assert.assertEquals((String)parameter.getDigestMethod(), (String)"http://www.w3.org/2001/04/xmlenc#sha256");
        Assert.assertEquals((String)parameter.getAlgorithmID(), null);
        Assert.assertEquals((String)parameter.getPartyUInfo(), null);
        Assert.assertEquals((String)parameter.getPartyVInfo(), null);
        Assert.assertEquals((String)parameter.getSuppPubInfo(), null);
        Assert.assertEquals((String)parameter.getSuppPrivInfo(), null);
    }

    @Test
    public void fromXMLObject_InvalidValues() throws Exception {
        KeyDerivationMethod xmlKDM = (KeyDerivationMethod)this.buildXMLObject(KeyDerivationMethod.DEFAULT_ELEMENT_NAME);
        xmlKDM.setAlgorithm("http://www.w3.org/2009/xmlenc11#ConcatKDF");
        ConcatKDFParams xmlParams = (ConcatKDFParams)this.buildXMLObject(ConcatKDFParams.DEFAULT_ELEMENT_NAME);
        xmlKDM.getUnknownXMLObjects().add(xmlParams);
        DigestMethod xmlDigest = (DigestMethod)this.buildXMLObject(DigestMethod.DEFAULT_ELEMENT_NAME);
        xmlDigest.setAlgorithm("http://www.w3.org/2001/04/xmlenc#sha256");
        xmlParams.setDigestMethod(xmlDigest);
        xmlParams.setAlgorithmID("00AA");
        xmlParams.setPartyUInfo("00BB");
        xmlParams.setPartyVInfo("00CC");
        xmlParams.setSuppPubInfo("00DD");
        xmlParams.setSuppPrivInfo("00EE");
        ConcatKDF parameter = ConcatKDF.fromXMLObject((KeyDerivationMethod)xmlKDM);
        Assert.assertNotNull((Object)parameter);
        Assert.assertTrue((boolean)parameter.isInitialized());
        KeyDerivationMethod xmlKDMBad = null;
        ConcatKDFParams xmlParamsBad = null;
        xmlKDMBad = (KeyDerivationMethod)XMLObjectSupport.cloneXMLObject((XMLObject)xmlKDM);
        xmlKDMBad.setAlgorithm("http://www.w3.org/2009/xmlenc11#pbkdf2");
        try {
            ConcatKDF.fromXMLObject((KeyDerivationMethod)xmlKDMBad);
            Assert.fail((String)"Should have failed invalid XMLObject");
        }
        catch (ComponentInitializationException componentInitializationException) {
            // empty catch block
        }
        xmlKDMBad = (KeyDerivationMethod)XMLObjectSupport.cloneXMLObject((XMLObject)xmlKDM);
        xmlKDMBad.getUnknownXMLObjects().add(this.buildXMLObject(simpleXMLObjectQName));
        try {
            ConcatKDF.fromXMLObject((KeyDerivationMethod)xmlKDMBad);
            Assert.fail((String)"Should have failed invalid XMLObject");
        }
        catch (ComponentInitializationException componentInitializationException) {
            // empty catch block
        }
        xmlKDMBad = (KeyDerivationMethod)XMLObjectSupport.cloneXMLObject((XMLObject)xmlKDM);
        xmlParamsBad = (ConcatKDFParams)xmlKDMBad.getUnknownXMLObjects().get(0);
        xmlParamsBad.setDigestMethod(null);
        try {
            ConcatKDF.fromXMLObject((KeyDerivationMethod)xmlKDMBad);
            Assert.fail((String)"Should have failed invalid XMLObject");
        }
        catch (ComponentInitializationException componentInitializationException) {
            // empty catch block
        }
        xmlKDMBad = (KeyDerivationMethod)XMLObjectSupport.cloneXMLObject((XMLObject)xmlKDM);
        xmlParamsBad = (ConcatKDFParams)xmlKDMBad.getUnknownXMLObjects().get(0);
        xmlParamsBad.setAlgorithmID("01AA");
        try {
            ConcatKDF.fromXMLObject((KeyDerivationMethod)xmlKDMBad);
            Assert.fail((String)"Should have failed invalid XMLObject");
        }
        catch (ComponentInitializationException componentInitializationException) {
            // empty catch block
        }
        xmlKDMBad = (KeyDerivationMethod)XMLObjectSupport.cloneXMLObject((XMLObject)xmlKDM);
        xmlParamsBad = (ConcatKDFParams)xmlKDMBad.getUnknownXMLObjects().get(0);
        xmlParamsBad.setPartyUInfo("01BB");
        try {
            ConcatKDF.fromXMLObject((KeyDerivationMethod)xmlKDMBad);
            Assert.fail((String)"Should have failed invalid XMLObject");
        }
        catch (ComponentInitializationException componentInitializationException) {
            // empty catch block
        }
        xmlKDMBad = (KeyDerivationMethod)XMLObjectSupport.cloneXMLObject((XMLObject)xmlKDM);
        xmlParamsBad = (ConcatKDFParams)xmlKDMBad.getUnknownXMLObjects().get(0);
        xmlParamsBad.setPartyVInfo("01CC");
        try {
            ConcatKDF.fromXMLObject((KeyDerivationMethod)xmlKDMBad);
            Assert.fail((String)"Should have failed invalid XMLObject");
        }
        catch (ComponentInitializationException componentInitializationException) {
            // empty catch block
        }
        xmlKDMBad = (KeyDerivationMethod)XMLObjectSupport.cloneXMLObject((XMLObject)xmlKDM);
        xmlParamsBad = (ConcatKDFParams)xmlKDMBad.getUnknownXMLObjects().get(0);
        xmlParamsBad.setSuppPubInfo("01DD");
        try {
            ConcatKDF.fromXMLObject((KeyDerivationMethod)xmlKDMBad);
            Assert.fail((String)"Should have failed invalid XMLObject");
        }
        catch (ComponentInitializationException componentInitializationException) {
            // empty catch block
        }
        xmlKDMBad = (KeyDerivationMethod)XMLObjectSupport.cloneXMLObject((XMLObject)xmlKDM);
        xmlParamsBad = (ConcatKDFParams)xmlKDMBad.getUnknownXMLObjects().get(0);
        xmlParamsBad.setSuppPrivInfo("01EE");
        try {
            ConcatKDF.fromXMLObject((KeyDerivationMethod)xmlKDMBad);
            Assert.fail((String)"Should have failed invalid XMLObject");
        }
        catch (ComponentInitializationException componentInitializationException) {
            // empty catch block
        }
    }

    @Test
    public void cloning() throws Exception {
        ConcatKDF kdf = new ConcatKDF();
        kdf.setAlgorithmID("AA");
        kdf.setPartyUInfo("BB");
        kdf.setPartyVInfo("CC");
        kdf.setSuppPubInfo("DD");
        kdf.setSuppPrivInfo("EE");
        kdf.setDigestMethod("http://www.w3.org/2001/04/xmlenc#sha512");
        kdf.initialize();
        Assert.assertEquals((String)kdf.getAlgorithm(), (String)"http://www.w3.org/2009/xmlenc11#ConcatKDF");
        ConcatKDF cloned = kdf.clone();
        Assert.assertEquals((String)cloned.getAlgorithmID(), (String)"AA");
        Assert.assertEquals((String)cloned.getPartyUInfo(), (String)"BB");
        Assert.assertEquals((String)cloned.getPartyVInfo(), (String)"CC");
        Assert.assertEquals((String)cloned.getSuppPubInfo(), (String)"DD");
        Assert.assertEquals((String)cloned.getSuppPrivInfo(), (String)"EE");
        Assert.assertEquals((String)cloned.getDigestMethod(), (String)"http://www.w3.org/2001/04/xmlenc#sha512");
    }

    @Test
    public void deriveWithDefaults() throws Exception {
        ConcatKDF kdf = new ConcatKDF();
        kdf.initialize();
        byte[] secret = Hex.decodeHex((String)"DEADBEEF");
        SecretKey derivedKey = kdf.derive(secret, "http://www.w3.org/2009/xmlenc11#aes128-gcm", null);
        Assert.assertNotNull((Object)derivedKey);
        Assert.assertEquals((String)derivedKey.getAlgorithm(), (String)"AES");
        Assert.assertEquals((int)(derivedKey.getEncoded().length * 8), (int)128);
    }

    @Test
    public void deriveWithExplicitProperties() throws Exception {
        ConcatKDF kdf = new ConcatKDF();
        kdf.setAlgorithmID("AA");
        kdf.setPartyUInfo("BB");
        kdf.setPartyVInfo("CC");
        kdf.setSuppPubInfo("DD");
        kdf.setSuppPrivInfo("EE");
        kdf.initialize();
        byte[] secret = Hex.decodeHex((String)"DEADBEEF");
        SecretKey derivedKey = kdf.derive(secret, "http://www.w3.org/2009/xmlenc11#aes128-gcm", null);
        Assert.assertNotNull((Object)derivedKey);
        Assert.assertEquals((String)derivedKey.getAlgorithm(), (String)"AES");
        Assert.assertEquals((int)(derivedKey.getEncoded().length * 8), (int)128);
    }

    @Test(expectedExceptions={KeyDerivationException.class})
    public void unknownKeyAlgorithm() throws Exception {
        ConcatKDF kdf = new ConcatKDF();
        kdf.initialize();
        byte[] secret = Hex.decodeHex((String)"DEADBEEF");
        kdf.derive(secret, "urn:test:InvalidKeyAlgorithm", null);
    }

    @Test(expectedExceptions={KeyDerivationException.class})
    public void nonKeyLengthAlgorithm() throws Exception {
        ConcatKDF kdf = new ConcatKDF();
        kdf.initialize();
        byte[] secret = Hex.decodeHex((String)"DEADBEEF");
        kdf.derive(secret, "http://www.w3.org/2001/04/xmldsig-more#rsa-sha256", null);
    }

    @Test
    public void nonKeyLengthAlgorithmWithSpecifiedLength() throws Exception {
        ConcatKDF kdf = new ConcatKDF();
        kdf.initialize();
        byte[] secret = Hex.decodeHex((String)"DEADBEEF");
        SecretKey derivedKey = kdf.derive(secret, "http://www.w3.org/2001/04/xmldsig-more#rsa-sha256", Integer.valueOf(256));
        Assert.assertNotNull((Object)derivedKey);
        Assert.assertEquals((String)derivedKey.getAlgorithm(), (String)"RSA");
        Assert.assertEquals((int)(derivedKey.getEncoded().length * 8), (int)256);
    }

    @Test
    public void decodeParam() throws Exception {
        ConcatKDF kdf = new ConcatKDF();
        kdf.initialize();
        Assert.assertEquals((byte[])kdf.decodeParam(null, "test"), (byte[])new byte[0]);
        Assert.assertEquals((byte[])kdf.decodeParam("    ", "test"), (byte[])new byte[0]);
        Assert.assertEquals((byte[])kdf.decodeParam("00", "test"), (byte[])new byte[]{0});
        Assert.assertEquals((byte[])kdf.decodeParam("000000", "test"), (byte[])new byte[]{0, 0, 0});
        Assert.assertEquals((byte[])kdf.decodeParam("AB", "test"), (byte[])new byte[]{-85});
        Assert.assertEquals((byte[])kdf.decodeParam("ABCD", "test"), (byte[])new byte[]{-85, -51});
        Assert.assertEquals((byte[])kdf.decodeParam("DEADBEEF", "test"), (byte[])new byte[]{-34, -83, -66, -17});
        try {
            kdf.decodeParam("INVALID", "test");
            Assert.fail((String)"Invalid value should have failed");
        }
        catch (KeyDerivationException keyDerivationException) {
            // empty catch block
        }
        try {
            kdf.decodeParam("A", "test");
            Assert.fail((String)"Invalid value should have failed");
        }
        catch (KeyDerivationException keyDerivationException) {
            // empty catch block
        }
        try {
            kdf.decodeParam("ABC", "test");
            Assert.fail((String)"Invalid value should have failed");
        }
        catch (KeyDerivationException keyDerivationException) {
            // empty catch block
        }
    }

    @Test
    public void padParam() throws Exception {
        Assert.assertEquals((String)ConcatKDF.padParam(null), null);
        Assert.assertEquals((String)ConcatKDF.padParam((String)"   "), null);
        Assert.assertEquals((String)ConcatKDF.padParam((String)"AA"), (String)"00AA");
        Assert.assertEquals((String)ConcatKDF.padParam((String)"   AABBCC   "), (String)"00AABBCC");
    }

    @Test
    public void unpadParam() throws Exception {
        Assert.assertEquals((String)ConcatKDF.unpadParam(null, (String)"test"), null);
        Assert.assertEquals((String)ConcatKDF.unpadParam((String)"   ", (String)"test"), null);
        Assert.assertEquals((String)ConcatKDF.unpadParam((String)"00AA", (String)"test"), (String)"AA");
        Assert.assertEquals((String)ConcatKDF.unpadParam((String)"   00AABBCC   ", (String)"test"), (String)"AABBCC");
        Assert.assertEquals((String)ConcatKDF.unpadParam((String)"00", (String)"test"), (String)"");
        try {
            ConcatKDF.unpadParam((String)"01AA", (String)"test");
            Assert.fail((String)"Invalid value should have failed");
        }
        catch (KeyDerivationException keyDerivationException) {
            // empty catch block
        }
        try {
            ConcatKDF.unpadParam((String)"0", (String)"test");
            Assert.fail((String)"Invalid value should have failed");
        }
        catch (KeyDerivationException keyDerivationException) {
            // empty catch block
        }
        try {
            ConcatKDF.unpadParam((String)"00A", (String)"test");
            Assert.fail((String)"Invalid value should have failed");
        }
        catch (KeyDerivationException keyDerivationException) {
            // empty catch block
        }
    }

    @DataProvider(name="testVectors")
    public Object[][] testVectors() throws DecoderException, EncodingException {
        return new Object[][]{{Hex.decodeHex((String)"d09a6b1a472f930db4f5e6b967900744"), Hex.decodeHex((String)"b117255ab5f1b6b96fc434b0"), 128, "http://www.w3.org/2000/09/xmldsig#sha1", Hex.decodeHex((String)"b5a3c52e97ae6e8c5069954354eab3c7")}, {Hex.decodeHex((String)"343666c0dd34b756e70f759f14c304f5"), Hex.decodeHex((String)"722b28448d7eab85491bce09"), 128, "http://www.w3.org/2000/09/xmldsig#sha1", Hex.decodeHex((String)"1003b650ddd3f0891a15166db5ec881d")}, {Hex.decodeHex((String)"b84acf03ab08652dd7f82fa956933261"), Hex.decodeHex((String)"3d8773ec068c86053a918565"), 128, "http://www.w3.org/2000/09/xmldsig#sha1", Hex.decodeHex((String)"1635dcd1ce698f736831b4badb68ab2b")}, {Hex.decodeHex((String)"8cc24ca3f1d1a8b34783780b79890430"), Hex.decodeHex((String)"f08d4f2d9a8e6d7105c0bc16"), 128, "http://www.w3.org/2000/09/xmldsig#sha1", Hex.decodeHex((String)"b8e716fb84a420aed4812cd76d9700ee")}, {Hex.decodeHex((String)"ebe28edbae5a410b87a479243db3f690"), Hex.decodeHex((String)"e60dd8b28228ce5b9be74d3b"), 128, "http://www.w3.org/2000/09/xmldsig#sha1", Hex.decodeHex((String)"b4a23963e07f485382cb358a493daec1")}, {Hex.decodeHex((String)"ebe28edbae5a410b87a479243db3f690"), Hex.decodeHex((String)"e60dd8b28228ce5b9be74d3b"), 192, "http://www.w3.org/2000/09/xmldsig#sha1", Hex.decodeHex((String)"b4a23963e07f485382cb358a493daec1759ac7043dbeac37")}, {Hex.decodeHex((String)"ebe28edbae5a410b87a479243db3f690"), Hex.decodeHex((String)"e60dd8b28228ce5b9be74d3b"), 256, "http://www.w3.org/2000/09/xmldsig#sha1", Hex.decodeHex((String)"b4a23963e07f485382cb358a493daec1759ac7043dbeac37152c6ddf105031f0")}, {Hex.decodeHex((String)"afc4e154498d4770aa8365f6903dc83b"), Hex.decodeHex((String)"662af20379b29d5ef813e655"), 128, "http://www.w3.org/2001/04/xmlenc#sha256", Hex.decodeHex((String)"f0b80d6ae4c1e19e2105a37024e35dc6")}, {Hex.decodeHex((String)"a3ce8d61d699ad150e196a7ab6736a63"), Hex.decodeHex((String)"ce5cd95a44ee83a8fb83f34c"), 128, "http://www.w3.org/2001/04/xmlenc#sha256", Hex.decodeHex((String)"5db3455a22b65edfcfde3da3e8d724cd")}, {Hex.decodeHex((String)"a9723e56045f0847fdd9c1c78781c8b7"), Hex.decodeHex((String)"e69b6005b78f7d42d0a8ed2a"), 128, "http://www.w3.org/2001/04/xmlenc#sha256", Hex.decodeHex((String)"ac3878b8cf357976f7fd8266923e1882")}, {Hex.decodeHex((String)"a07a5e8df7ee1b2ce2a3d1348edfa8ab"), Hex.decodeHex((String)"e22a8ee34296dd39b56b31fb"), 128, "http://www.w3.org/2001/04/xmlenc#sha256", Hex.decodeHex((String)"70927d218b6d119268381e9930a4f256")}, {Hex.decodeHex((String)"3f892bd8b84dae64a782a35f6eaa8f00"), Hex.decodeHex((String)"ec3f1cd873d28858a58cc39e"), 128, "http://www.w3.org/2001/04/xmlenc#sha256", Hex.decodeHex((String)"a7c0665298252531e0db37737a374651")}, {Hex.decodeHex((String)"3f892bd8b84dae64a782a35f6eaa8f00"), Hex.decodeHex((String)"ec3f1cd873d28858a58cc39e"), 192, "http://www.w3.org/2001/04/xmlenc#sha256", Hex.decodeHex((String)"a7c0665298252531e0db37737a374651b368275f2048284d")}, {Hex.decodeHex((String)"3f892bd8b84dae64a782a35f6eaa8f00"), Hex.decodeHex((String)"ec3f1cd873d28858a58cc39e"), 256, "http://www.w3.org/2001/04/xmlenc#sha256", Hex.decodeHex((String)"a7c0665298252531e0db37737a374651b368275f2048284d16a166c6d8a90a91")}, {Hex.decodeHex((String)"108cf63318555c787fa578731dd4f037"), Hex.decodeHex((String)"53191b1dd3f94d83084d61d6"), 128, "http://www.w3.org/2001/04/xmlenc#sha512", Hex.decodeHex((String)"0ad475c1826da3007637970c8b92b993")}, {Hex.decodeHex((String)"35fa6d42e65014f04bdd80ff1404ab27"), Hex.decodeHex((String)"506d9cfe967748d1e6f84bd9"), 128, "http://www.w3.org/2001/04/xmlenc#sha512", Hex.decodeHex((String)"16739821c3b13dee57e24c092211ddd6")}, {Hex.decodeHex((String)"775e83546ce8b41a83656bd723d63c9e"), Hex.decodeHex((String)"514f4d06bf8c1646aeae28fa"), 128, "http://www.w3.org/2001/04/xmlenc#sha512", Hex.decodeHex((String)"0bce0e54a721367088495c0c4c0683f5")}, {Hex.decodeHex((String)"03f1dea7561b885a5601c6e75e405140"), Hex.decodeHex((String)"1e366c4b697d20aa9a54d6f5"), 128, "http://www.w3.org/2001/04/xmlenc#sha512", Hex.decodeHex((String)"56a2ac8f0eb55fdc4d8a891664edfbdb")}, {Hex.decodeHex((String)"e65b1905878b95f68b5535bd3b2b1013"), Hex.decodeHex((String)"830221b1730d9176f807d407"), 128, "http://www.w3.org/2001/04/xmlenc#sha512", Hex.decodeHex((String)"b8c44bdf0b85a64b6a51c12a06710e37")}, {Hex.decodeHex((String)"e65b1905878b95f68b5535bd3b2b1013"), Hex.decodeHex((String)"830221b1730d9176f807d407"), 192, "http://www.w3.org/2001/04/xmlenc#sha512", Hex.decodeHex((String)"b8c44bdf0b85a64b6a51c12a06710e373d829bb1fda5b4e1")}, {Hex.decodeHex((String)"e65b1905878b95f68b5535bd3b2b1013"), Hex.decodeHex((String)"830221b1730d9176f807d407"), 256, "http://www.w3.org/2001/04/xmlenc#sha512", Hex.decodeHex((String)"b8c44bdf0b85a64b6a51c12a06710e373d829bb1fda5b4e1a20795c6199594f6")}};
    }

    @Test(dataProvider="testVectors")
    public void deriveTestVectors(byte[] secret, byte[] otherInfo, Integer keyLength, String digestMethod, byte[] keyBytes) throws Exception {
        ConcatKDF kdf = new ConcatKDF();
        kdf.setDigestMethod(digestMethod);
        kdf.initialize();
        byte[] deriveKeyBytes = kdf.derive(secret, otherInfo, keyLength);
        Assert.assertNotNull((Object)deriveKeyBytes);
        Assert.assertEquals((int)(deriveKeyBytes.length * 8), (int)keyLength);
        Assert.assertEquals((byte[])deriveKeyBytes, (byte[])keyBytes);
    }
}

