/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.xmlsec.derivation.impl;

import javax.crypto.SecretKey;
import org.opensaml.security.crypto.KeySupport;
import org.opensaml.xmlsec.algorithm.AlgorithmSupport;
import org.opensaml.xmlsec.derivation.KeyDerivation;
import org.opensaml.xmlsec.derivation.KeyDerivationException;

public class MockKeyDerivation
implements KeyDerivation {
    public String getAlgorithm() {
        return "urn:test:MockKeyDerivation";
    }

    public SecretKey derive(byte[] secret, String keyAlgorithm, Integer keyLength) throws KeyDerivationException {
        try {
            String algo = AlgorithmSupport.getKeyAlgorithm((String)keyAlgorithm);
            Integer length = AlgorithmSupport.getKeyLength((String)keyAlgorithm);
            return KeySupport.generateKey((String)algo, (int)length, null);
        }
        catch (Exception e) {
            throw new KeyDerivationException("Error generating mock derived key", (Throwable)e);
        }
    }
}

