/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.xmlsec.derivation.impl;

import com.google.common.base.Charsets;
import java.security.SecureRandom;
import javax.crypto.SecretKey;
import net.shibboleth.utilities.java.support.codec.Base64Support;
import net.shibboleth.utilities.java.support.codec.EncodingException;
import net.shibboleth.utilities.java.support.component.ComponentInitializationException;
import org.apache.commons.codec.DecoderException;
import org.apache.commons.codec.binary.Hex;
import org.opensaml.core.testing.XMLObjectBaseTestCase;
import org.opensaml.core.xml.XMLObject;
import org.opensaml.core.xml.util.XMLObjectSupport;
import org.opensaml.xmlsec.algorithm.AlgorithmDescriptor;
import org.opensaml.xmlsec.algorithm.AlgorithmRegistry;
import org.opensaml.xmlsec.algorithm.AlgorithmSupport;
import org.opensaml.xmlsec.algorithm.BlockEncryptionAlgorithm;
import org.opensaml.xmlsec.derivation.KeyDerivationException;
import org.opensaml.xmlsec.derivation.impl.PBKDF2;
import org.opensaml.xmlsec.encryption.IterationCount;
import org.opensaml.xmlsec.encryption.KeyDerivationMethod;
import org.opensaml.xmlsec.encryption.KeyLength;
import org.opensaml.xmlsec.encryption.PBKDF2Params;
import org.opensaml.xmlsec.encryption.PRF;
import org.opensaml.xmlsec.encryption.Salt;
import org.opensaml.xmlsec.encryption.Specified;
import org.testng.Assert;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Test;

public class PBKDF2Test
extends XMLObjectBaseTestCase {
    @Test
    public void defaultProperties() throws Exception {
        PBKDF2 kdf = new PBKDF2();
        kdf.initialize();
        Assert.assertEquals((String)kdf.getAlgorithm(), (String)"http://www.w3.org/2009/xmlenc11#pbkdf2");
        Assert.assertEquals((Object)kdf.getGeneratedSaltLength(), (Object)PBKDF2.DEFAULT_GENERATED_SALT_LENGTH);
        Assert.assertEquals((Object)kdf.getIterationCount(), (Object)PBKDF2.DEFAULT_ITERATION_COUNT);
        Assert.assertNull((Object)kdf.getKeyLength());
        Assert.assertEquals((String)kdf.getPRF(), (String)"http://www.w3.org/2001/04/xmldsig-more#hmac-sha256");
        Assert.assertNotNull((Object)kdf.getRandom());
        Assert.assertNull((Object)kdf.getSalt());
    }

    @Test
    public void explicitProperties() throws Exception {
        SecureRandom sr = new SecureRandom();
        PBKDF2 kdf = new PBKDF2();
        kdf.setGeneratedSaltLength(Integer.valueOf(16));
        kdf.setIterationCount(Integer.valueOf(3000));
        kdf.setKeyLength(Integer.valueOf(256));
        kdf.setPRF("http://www.w3.org/2001/04/xmldsig-more#hmac-sha512");
        kdf.setRandom(sr);
        kdf.setSalt("ABCD");
        kdf.initialize();
        Assert.assertEquals((String)kdf.getAlgorithm(), (String)"http://www.w3.org/2009/xmlenc11#pbkdf2");
        Assert.assertEquals((int)kdf.getGeneratedSaltLength(), (int)16);
        Assert.assertEquals((int)kdf.getIterationCount(), (int)3000);
        Assert.assertEquals((int)kdf.getKeyLength(), (int)256);
        Assert.assertEquals((String)kdf.getPRF(), (String)"http://www.w3.org/2001/04/xmldsig-more#hmac-sha512");
        Assert.assertSame((Object)kdf.getRandom(), (Object)sr);
        Assert.assertEquals((String)kdf.getSalt(), (String)"ABCD");
    }

    @Test(expectedExceptions={ComponentInitializationException.class})
    public void initBadSalt() throws Exception {
        PBKDF2 kdf = new PBKDF2();
        kdf.setSalt("INVALID BASE64");
        kdf.initialize();
    }

    @Test(expectedExceptions={ComponentInitializationException.class})
    public void initBadKeyLength() throws Exception {
        PBKDF2 kdf = new PBKDF2();
        kdf.setKeyLength(Integer.valueOf(129));
        kdf.initialize();
    }

    @Test(expectedExceptions={ComponentInitializationException.class})
    public void initBadPRF() throws Exception {
        PBKDF2 kdf = new PBKDF2();
        kdf.setPRF("http://www.w3.org/2001/04/xmlenc#sha256");
        kdf.initialize();
    }

    @Test
    public void xmlGenerationSuccess() throws Exception {
        PBKDF2 kdf = new PBKDF2();
        kdf.setIterationCount(Integer.valueOf(3000));
        kdf.setKeyLength(Integer.valueOf(256));
        kdf.setPRF("http://www.w3.org/2001/04/xmldsig-more#hmac-sha512");
        kdf.setSalt("ABCD");
        kdf.initialize();
        XMLObject xmlObject = kdf.buildXMLObject();
        Assert.assertNotNull((Object)xmlObject);
        Assert.assertTrue((boolean)KeyDerivationMethod.class.isInstance(xmlObject));
        KeyDerivationMethod kdm = (KeyDerivationMethod)KeyDerivationMethod.class.cast(xmlObject);
        Assert.assertEquals((String)kdm.getAlgorithm(), (String)"http://www.w3.org/2009/xmlenc11#pbkdf2");
        Assert.assertEquals((int)kdm.getUnknownXMLObjects().size(), (int)1);
        PBKDF2Params kdmParams = (PBKDF2Params)PBKDF2Params.class.cast(kdm.getUnknownXMLObjects().get(0));
        Assert.assertNotNull((Object)kdmParams.getIterationCount());
        Assert.assertEquals((int)kdmParams.getIterationCount().getValue(), (int)3000);
        Assert.assertNotNull((Object)kdmParams.getKeyLength());
        Assert.assertEquals((int)kdmParams.getKeyLength().getValue(), (int)32);
        Assert.assertNotNull((Object)kdmParams.getPRF());
        Assert.assertEquals((String)kdmParams.getPRF().getAlgorithm(), (String)"http://www.w3.org/2001/04/xmldsig-more#hmac-sha512");
        Assert.assertNotNull((Object)kdmParams.getSalt());
        Assert.assertNotNull((Object)kdmParams.getSalt().getSpecified());
        Assert.assertEquals((String)kdmParams.getSalt().getSpecified().getValue(), (String)"ABCD");
    }

    @Test
    public void fromXMLObject() throws Exception {
        KeyDerivationMethod xmlKDM = (KeyDerivationMethod)this.buildXMLObject(KeyDerivationMethod.DEFAULT_ELEMENT_NAME);
        xmlKDM.setAlgorithm("http://www.w3.org/2009/xmlenc11#pbkdf2");
        PBKDF2Params xmlParams = (PBKDF2Params)this.buildXMLObject(PBKDF2Params.DEFAULT_ELEMENT_NAME);
        xmlKDM.getUnknownXMLObjects().add(xmlParams);
        IterationCount xmlIterationCount = (IterationCount)this.buildXMLObject(IterationCount.DEFAULT_ELEMENT_NAME);
        xmlIterationCount.setValue(Integer.valueOf(3000));
        xmlParams.setIterationCount(xmlIterationCount);
        KeyLength xmlKeyLength = (KeyLength)this.buildXMLObject(KeyLength.DEFAULT_ELEMENT_NAME);
        xmlKeyLength.setValue(Integer.valueOf(16));
        xmlParams.setKeyLength(xmlKeyLength);
        PRF xmlPRF = (PRF)this.buildXMLObject(PRF.DEFAULT_ELEMENT_NAME);
        xmlPRF.setAlgorithm("http://www.w3.org/2001/04/xmldsig-more#hmac-sha256");
        xmlParams.setPRF(xmlPRF);
        Salt xmlSalt = (Salt)this.buildXMLObject(Salt.DEFAULT_ELEMENT_NAME);
        Specified xmlSpecified = (Specified)this.buildXMLObject(Specified.DEFAULT_ELEMENT_NAME);
        xmlSpecified.setValue("ABCD");
        xmlSalt.setSpecified(xmlSpecified);
        xmlParams.setSalt(xmlSalt);
        PBKDF2 parameter = PBKDF2.fromXMLObject((KeyDerivationMethod)xmlKDM);
        Assert.assertNotNull((Object)parameter);
        Assert.assertTrue((boolean)parameter.isInitialized());
        Assert.assertEquals((int)parameter.getIterationCount(), (int)3000);
        Assert.assertEquals((int)parameter.getKeyLength(), (int)128);
        Assert.assertEquals((String)parameter.getPRF(), (String)"http://www.w3.org/2001/04/xmldsig-more#hmac-sha256");
        Assert.assertEquals((String)parameter.getSalt(), (String)"ABCD");
        KeyDerivationMethod xmlKDMBad = null;
        PBKDF2Params xmlParamsBad = null;
        xmlKDMBad = (KeyDerivationMethod)XMLObjectSupport.cloneXMLObject((XMLObject)xmlKDM);
        xmlKDMBad.setAlgorithm("http://www.w3.org/2009/xmlenc11#ConcatKDF");
        try {
            PBKDF2.fromXMLObject((KeyDerivationMethod)xmlKDMBad);
            Assert.fail((String)"Should have failed invalid XMLObject");
        }
        catch (ComponentInitializationException componentInitializationException) {
            // empty catch block
        }
        xmlKDMBad = (KeyDerivationMethod)XMLObjectSupport.cloneXMLObject((XMLObject)xmlKDM);
        xmlKDMBad.getUnknownXMLObjects().add(this.buildXMLObject(simpleXMLObjectQName));
        try {
            PBKDF2.fromXMLObject((KeyDerivationMethod)xmlKDMBad);
            Assert.fail((String)"Should have failed invalid XMLObject");
        }
        catch (ComponentInitializationException componentInitializationException) {
            // empty catch block
        }
        xmlKDMBad = (KeyDerivationMethod)XMLObjectSupport.cloneXMLObject((XMLObject)xmlKDM);
        xmlParamsBad = (PBKDF2Params)xmlKDMBad.getUnknownXMLObjects(PBKDF2Params.DEFAULT_ELEMENT_NAME).get(0);
        xmlParamsBad.setIterationCount(null);
        try {
            PBKDF2.fromXMLObject((KeyDerivationMethod)xmlKDMBad);
            Assert.fail((String)"Should have failed invalid XMLObject");
        }
        catch (ComponentInitializationException componentInitializationException) {
            // empty catch block
        }
        xmlKDMBad = (KeyDerivationMethod)XMLObjectSupport.cloneXMLObject((XMLObject)xmlKDM);
        xmlParamsBad = (PBKDF2Params)xmlKDMBad.getUnknownXMLObjects(PBKDF2Params.DEFAULT_ELEMENT_NAME).get(0);
        xmlParamsBad.setKeyLength(null);
        try {
            PBKDF2.fromXMLObject((KeyDerivationMethod)xmlKDMBad);
            Assert.fail((String)"Should have failed invalid XMLObject");
        }
        catch (ComponentInitializationException componentInitializationException) {
            // empty catch block
        }
        xmlKDMBad = (KeyDerivationMethod)XMLObjectSupport.cloneXMLObject((XMLObject)xmlKDM);
        xmlParamsBad = (PBKDF2Params)xmlKDMBad.getUnknownXMLObjects(PBKDF2Params.DEFAULT_ELEMENT_NAME).get(0);
        xmlParamsBad.setPRF(null);
        try {
            PBKDF2.fromXMLObject((KeyDerivationMethod)xmlKDMBad);
            Assert.fail((String)"Should have failed invalid XMLObject");
        }
        catch (ComponentInitializationException componentInitializationException) {
            // empty catch block
        }
        xmlKDMBad = (KeyDerivationMethod)XMLObjectSupport.cloneXMLObject((XMLObject)xmlKDM);
        xmlParamsBad = (PBKDF2Params)xmlKDMBad.getUnknownXMLObjects(PBKDF2Params.DEFAULT_ELEMENT_NAME).get(0);
        xmlParamsBad.setSalt(null);
        try {
            PBKDF2.fromXMLObject((KeyDerivationMethod)xmlKDMBad);
            Assert.fail((String)"Should have failed invalid XMLObject");
        }
        catch (ComponentInitializationException componentInitializationException) {
            // empty catch block
        }
    }

    @Test
    public void cloning() throws Exception {
        SecureRandom sr = new SecureRandom();
        PBKDF2 kdf = new PBKDF2();
        kdf.setGeneratedSaltLength(Integer.valueOf(16));
        kdf.setIterationCount(Integer.valueOf(3000));
        kdf.setKeyLength(Integer.valueOf(256));
        kdf.setPRF("http://www.w3.org/2001/04/xmldsig-more#hmac-sha512");
        kdf.setRandom(sr);
        kdf.setSalt("ABCD");
        kdf.initialize();
        PBKDF2 cloned = kdf.clone();
        Assert.assertNotSame((Object)cloned, (Object)kdf);
        Assert.assertNotNull((Object)cloned);
        Assert.assertEquals((int)cloned.getGeneratedSaltLength(), (int)16);
        Assert.assertEquals((int)cloned.getIterationCount(), (int)3000);
        Assert.assertEquals((int)cloned.getKeyLength(), (int)256);
        Assert.assertEquals((String)cloned.getPRF(), (String)"http://www.w3.org/2001/04/xmldsig-more#hmac-sha512");
        Assert.assertSame((Object)cloned.getRandom(), (Object)sr);
        Assert.assertEquals((String)cloned.getSalt(), (String)"ABCD");
    }

    @Test
    public void deriveWithDefaults() throws Exception {
        PBKDF2 kdf = new PBKDF2();
        kdf.initialize();
        byte[] secret = Hex.decodeHex((String)"DEADBEEF");
        SecretKey derivedKey = kdf.derive(secret, "http://www.w3.org/2009/xmlenc11#aes128-gcm", null);
        Assert.assertNotNull((Object)derivedKey);
        Assert.assertEquals((String)derivedKey.getAlgorithm(), (String)"AES");
        Assert.assertEquals((int)(derivedKey.getEncoded().length * 8), (int)128);
        Assert.assertNotNull((Object)kdf.getSalt());
        Assert.assertEquals((int)Base64Support.decode((String)kdf.getSalt()).length, (int)kdf.getGeneratedSaltLength());
        Assert.assertNotNull((Object)kdf.getKeyLength());
        Assert.assertEquals((int)kdf.getKeyLength(), (int)128);
    }

    @Test
    public void deriveWithExplicitProperties() throws Exception {
        PBKDF2 kdf = new PBKDF2();
        kdf.setIterationCount(Integer.valueOf(3000));
        kdf.setKeyLength(Integer.valueOf(256));
        kdf.setPRF("http://www.w3.org/2001/04/xmldsig-more#hmac-sha512");
        kdf.setSalt("ABCD");
        kdf.initialize();
        byte[] secret = Hex.decodeHex((String)"DEADBEEF");
        SecretKey derivedKey = kdf.derive(secret, "http://www.w3.org/2009/xmlenc11#aes256-gcm", null);
        Assert.assertNotNull((Object)derivedKey);
        Assert.assertEquals((String)derivedKey.getAlgorithm(), (String)"AES");
        Assert.assertEquals((int)(derivedKey.getEncoded().length * 8), (int)256);
    }

    @Test(expectedExceptions={KeyDerivationException.class})
    public void deriveWithKeyLengthMismatch() throws Exception {
        PBKDF2 kdf = new PBKDF2();
        kdf.setKeyLength(Integer.valueOf(256));
        kdf.initialize();
        byte[] secret = Hex.decodeHex((String)"DEADBEEF");
        kdf.derive(secret, "http://www.w3.org/2009/xmlenc11#aes128-gcm", null);
    }

    @Test(expectedExceptions={KeyDerivationException.class})
    public void unknownKeyAlgorithm() throws Exception {
        PBKDF2 kdf = new PBKDF2();
        kdf.initialize();
        byte[] secret = Hex.decodeHex((String)"DEADBEEF");
        kdf.derive(secret, "urn:test:InvalidKeyAlgorithm", null);
    }

    @Test(expectedExceptions={KeyDerivationException.class})
    public void nonKeyLengthAlgorithm() throws Exception {
        PBKDF2 kdf = new PBKDF2();
        kdf.initialize();
        byte[] secret = Hex.decodeHex((String)"DEADBEEF");
        kdf.derive(secret, "http://www.w3.org/2001/04/xmldsig-more#rsa-sha256", null);
    }

    @Test
    public void nonKeyLengthAlgorithmWithSpecifiedLength() throws Exception {
        PBKDF2 kdf = new PBKDF2();
        kdf.initialize();
        byte[] secret = Hex.decodeHex((String)"DEADBEEF");
        SecretKey derivedKey = kdf.derive(secret, "http://www.w3.org/2001/04/xmldsig-more#rsa-sha256", Integer.valueOf(256));
        Assert.assertNotNull((Object)derivedKey);
        Assert.assertEquals((String)derivedKey.getAlgorithm(), (String)"RSA");
        Assert.assertEquals((int)(derivedKey.getEncoded().length * 8), (int)256);
    }

    @BeforeClass
    public void setupTestVectorAlgorithms() {
        AlgorithmRegistry registry = AlgorithmSupport.getGlobalAlgorithmRegistry();
        registry.register((AlgorithmDescriptor)new MockKeyAlgorithm128());
        registry.register((AlgorithmDescriptor)new MockKeyAlgorithm160());
        registry.register((AlgorithmDescriptor)new MockKeyAlgorithm200());
        registry.register((AlgorithmDescriptor)new MockKeyAlgorithm256());
        registry.register((AlgorithmDescriptor)new MockKeyAlgorithm320());
    }

    @AfterClass
    public void teardownTestVectorAlgorithms() {
        AlgorithmRegistry registry = AlgorithmSupport.getGlobalAlgorithmRegistry();
        registry.deregister((AlgorithmDescriptor)new MockKeyAlgorithm128());
        registry.deregister((AlgorithmDescriptor)new MockKeyAlgorithm160());
        registry.deregister((AlgorithmDescriptor)new MockKeyAlgorithm200());
        registry.register((AlgorithmDescriptor)new MockKeyAlgorithm256());
        registry.deregister((AlgorithmDescriptor)new MockKeyAlgorithm320());
    }

    private String whitespace(String input) {
        return input.replaceAll("\\s", "");
    }

    @DataProvider(name="testVectors")
    public Object[][] testVectors() throws DecoderException, EncodingException {
        return new Object[][]{{"password".getBytes(Charsets.UTF_8), "urn:test:MockKeyAlgorithm:160", "http://www.w3.org/2000/09/xmldsig#hmac-sha1", Base64Support.encode((byte[])"salt".getBytes(Charsets.UTF_8), (boolean)false), 1, Hex.decodeHex((String)this.whitespace("0c 60 c8 0f 96 1f 0e 71f3 a9 b5 24 af 60 12 062f e0 37 a6"))}, {"password".getBytes(Charsets.UTF_8), "urn:test:MockKeyAlgorithm:160", "http://www.w3.org/2000/09/xmldsig#hmac-sha1", Base64Support.encode((byte[])"salt".getBytes(Charsets.UTF_8), (boolean)false), 2, Hex.decodeHex((String)this.whitespace("ea 6c 01 4d c7 2d 6f 8ccd 1e d9 2a ce 1d 41 f0d8 de 89 57"))}, {"password".getBytes(Charsets.UTF_8), "urn:test:MockKeyAlgorithm:160", "http://www.w3.org/2000/09/xmldsig#hmac-sha1", Base64Support.encode((byte[])"salt".getBytes(Charsets.UTF_8), (boolean)false), 4096, Hex.decodeHex((String)this.whitespace("4b 00 79 01 b7 65 48 9abe ad 49 d9 26 f7 21 d065 a4 29 c1  "))}, {"passwordPASSWORDpassword".getBytes(Charsets.UTF_8), "urn:test:MockKeyAlgorithm:200", "http://www.w3.org/2000/09/xmldsig#hmac-sha1", Base64Support.encode((byte[])"saltSALTsaltSALTsaltSALTsaltSALTsalt".getBytes(Charsets.UTF_8), (boolean)false), 4096, Hex.decodeHex((String)this.whitespace("3d 2e ec 4f e4 1c 84 9b80 c8 d8 36 62 c0 e4 4a8b 29 1a 96 4c f2 f0 7038"))}, {"pass\u0000word".getBytes(Charsets.UTF_8), "urn:test:MockKeyAlgorithm:128", "http://www.w3.org/2000/09/xmldsig#hmac-sha1", Base64Support.encode((byte[])"sa\u0000lt".getBytes(Charsets.UTF_8), (boolean)false), 4096, Hex.decodeHex((String)this.whitespace("56 fa 6a a7 55 48 09 9dcc 37 d7 f0 34 25 e0 c3"))}, {"password".getBytes(Charsets.UTF_8), "urn:test:MockKeyAlgorithm:256", "http://www.w3.org/2001/04/xmldsig-more#hmac-sha256", Base64Support.encode((byte[])"salt".getBytes(Charsets.UTF_8), (boolean)false), 1, Hex.decodeHex((String)this.whitespace("12 0f b6 cf fc f8 b3 2c43 e7 22 52 56 c4 f8 37a8 65 48 c9 2c cc 35 4808 05 98 7c b7 0b e1 7b"))}, {"password".getBytes(Charsets.UTF_8), "urn:test:MockKeyAlgorithm:256", "http://www.w3.org/2001/04/xmldsig-more#hmac-sha256", Base64Support.encode((byte[])"salt".getBytes(Charsets.UTF_8), (boolean)false), 2, Hex.decodeHex((String)this.whitespace("ae 4d 0c 95 af 6b 46 d32d 0a df f9 28 f0 6d d02a 30 3f 8e f3 c2 51 dfd6 e2 d8 5a 95 47 4c 43"))}, {"password".getBytes(Charsets.UTF_8), "urn:test:MockKeyAlgorithm:256", "http://www.w3.org/2001/04/xmldsig-more#hmac-sha256", Base64Support.encode((byte[])"salt".getBytes(Charsets.UTF_8), (boolean)false), 4096, Hex.decodeHex((String)this.whitespace("c5 e4 78 d5 92 88 c8 41aa 53 0d b6 84 5c 4c 8d96 28 93 a0 01 ce 4e 11a4 96 38 73 aa 98 13 4a"))}, {"passwordPASSWORDpassword".getBytes(Charsets.UTF_8), "urn:test:MockKeyAlgorithm:320", "http://www.w3.org/2001/04/xmldsig-more#hmac-sha256", Base64Support.encode((byte[])"saltSALTsaltSALTsaltSALTsaltSALTsalt".getBytes(Charsets.UTF_8), (boolean)false), 4096, Hex.decodeHex((String)this.whitespace("34 8c 89 db cb d3 2b 2f32 d8 14 b8 11 6e 84 cf2b 17 34 7e bc 18 00 181c 4e 2a 1f b8 dd 53 e1c6 35 51 8c 7d ac 47 e9"))}, {"pass\u0000word".getBytes(Charsets.UTF_8), "urn:test:MockKeyAlgorithm:128", "http://www.w3.org/2001/04/xmldsig-more#hmac-sha256", Base64Support.encode((byte[])"sa\u0000lt".getBytes(Charsets.UTF_8), (boolean)false), 4096, Hex.decodeHex((String)this.whitespace("89 b6 9d 05 16 f8 29 893c 69 62 26 65 0a 86 87"))}};
    }

    @Test(dataProvider="testVectors")
    public void deriveTestVectors(byte[] secret, String keyAlgorithm, String prfAlgorithm, String salt, Integer iterationCount, byte[] keyBytes) throws Exception {
        String jcaKeyAlgorithm = AlgorithmSupport.getKeyAlgorithm((String)keyAlgorithm);
        Assert.assertNotNull((Object)jcaKeyAlgorithm);
        Integer jcaKeyLength = AlgorithmSupport.getKeyLength((String)keyAlgorithm);
        Assert.assertNotNull((Object)jcaKeyLength);
        PBKDF2 kdf = new PBKDF2();
        kdf.setIterationCount(iterationCount);
        kdf.setKeyLength(jcaKeyLength);
        kdf.setPRF(prfAlgorithm);
        kdf.setSalt(salt);
        kdf.initialize();
        SecretKey derivedKey = kdf.derive(secret, keyAlgorithm, null);
        Assert.assertNotNull((Object)derivedKey);
        Assert.assertEquals((String)derivedKey.getAlgorithm(), (String)jcaKeyAlgorithm);
        Assert.assertEquals((int)(derivedKey.getEncoded().length * 8), (int)jcaKeyLength);
        Assert.assertEquals((byte[])derivedKey.getEncoded(), (byte[])keyBytes);
    }

    private class MockKeyAlgorithm128
    implements BlockEncryptionAlgorithm {
        private MockKeyAlgorithm128() {
        }

        public String getKey() {
            return "MockKey";
        }

        public String getURI() {
            return "urn:test:MockKeyAlgorithm:128";
        }

        public Integer getKeyLength() {
            return 128;
        }

        public AlgorithmDescriptor.AlgorithmType getType() {
            return AlgorithmDescriptor.AlgorithmType.BlockEncryption;
        }

        public String getJCAAlgorithmID() {
            return null;
        }

        public String getCipherMode() {
            return null;
        }

        public String getPadding() {
            return null;
        }
    }

    private class MockKeyAlgorithm160
    implements BlockEncryptionAlgorithm {
        private MockKeyAlgorithm160() {
        }

        public String getKey() {
            return "MockKey";
        }

        public String getURI() {
            return "urn:test:MockKeyAlgorithm:160";
        }

        public Integer getKeyLength() {
            return 160;
        }

        public AlgorithmDescriptor.AlgorithmType getType() {
            return AlgorithmDescriptor.AlgorithmType.BlockEncryption;
        }

        public String getJCAAlgorithmID() {
            return null;
        }

        public String getCipherMode() {
            return null;
        }

        public String getPadding() {
            return null;
        }
    }

    private class MockKeyAlgorithm200
    implements BlockEncryptionAlgorithm {
        private MockKeyAlgorithm200() {
        }

        public String getKey() {
            return "MockKey";
        }

        public String getURI() {
            return "urn:test:MockKeyAlgorithm:200";
        }

        public Integer getKeyLength() {
            return 200;
        }

        public AlgorithmDescriptor.AlgorithmType getType() {
            return AlgorithmDescriptor.AlgorithmType.BlockEncryption;
        }

        public String getJCAAlgorithmID() {
            return null;
        }

        public String getCipherMode() {
            return null;
        }

        public String getPadding() {
            return null;
        }
    }

    private class MockKeyAlgorithm256
    implements BlockEncryptionAlgorithm {
        private MockKeyAlgorithm256() {
        }

        public String getKey() {
            return "MockKey";
        }

        public String getURI() {
            return "urn:test:MockKeyAlgorithm:256";
        }

        public Integer getKeyLength() {
            return 256;
        }

        public AlgorithmDescriptor.AlgorithmType getType() {
            return AlgorithmDescriptor.AlgorithmType.BlockEncryption;
        }

        public String getJCAAlgorithmID() {
            return null;
        }

        public String getCipherMode() {
            return null;
        }

        public String getPadding() {
            return null;
        }
    }

    private class MockKeyAlgorithm320
    implements BlockEncryptionAlgorithm {
        private MockKeyAlgorithm320() {
        }

        public String getKey() {
            return "MockKey";
        }

        public String getURI() {
            return "urn:test:MockKeyAlgorithm:320";
        }

        public Integer getKeyLength() {
            return 320;
        }

        public AlgorithmDescriptor.AlgorithmType getType() {
            return AlgorithmDescriptor.AlgorithmType.BlockEncryption;
        }

        public String getJCAAlgorithmID() {
            return null;
        }

        public String getCipherMode() {
            return null;
        }

        public String getPadding() {
            return null;
        }
    }
}

