/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.xmlsec.encryption.impl;

import net.shibboleth.utilities.java.support.xml.XMLParserException;
import org.opensaml.core.testing.XMLObjectProviderBaseTestCase;
import org.opensaml.core.xml.XMLObject;
import org.opensaml.core.xml.io.MarshallingException;
import org.opensaml.xmlsec.encryption.CarriedKeyName;
import org.opensaml.xmlsec.encryption.CipherData;
import org.opensaml.xmlsec.encryption.EncryptedKey;
import org.opensaml.xmlsec.encryption.EncryptionMethod;
import org.opensaml.xmlsec.encryption.EncryptionProperties;
import org.opensaml.xmlsec.encryption.ReferenceList;
import org.opensaml.xmlsec.signature.KeyInfo;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public class EncryptedKeyTest
extends XMLObjectProviderBaseTestCase {
    private String expectedId;
    private String expectedType;
    private String expectedMimeType;
    private String expectedEncoding;
    private String expectedRecipient;

    public EncryptedKeyTest() {
        this.singleElementFile = "/org/opensaml/xmlsec/encryption/impl/EncryptedKey.xml";
        this.singleElementOptionalAttributesFile = "/org/opensaml/xmlsec/encryption/impl/EncryptedKeyOptionalAttributes.xml";
        this.childElementsFile = "/org/opensaml/xmlsec/encryption/impl/EncryptedKeyChildElements.xml";
    }

    @BeforeMethod
    protected void setUp() throws Exception {
        this.expectedId = "abc123";
        this.expectedType = "someType";
        this.expectedMimeType = "someMimeType";
        this.expectedEncoding = "someEncoding";
        this.expectedRecipient = "someRecipient";
    }

    @Test
    public void testSingleElementUnmarshall() {
        EncryptedKey ek = (EncryptedKey)this.unmarshallElement(this.singleElementFile);
        Assert.assertNotNull((Object)ek, (String)"EncryptedKey");
        Assert.assertNull((Object)ek.getEncryptionMethod(), (String)"EncryptionMethod child");
        Assert.assertNull((Object)ek.getKeyInfo(), (String)"KeyInfo child");
        Assert.assertNull((Object)ek.getCipherData(), (String)"CipherData child");
        Assert.assertNull((Object)ek.getEncryptionProperties(), (String)"EncryptionProperties child");
        Assert.assertNull((Object)ek.getReferenceList(), (String)"ReferenceList child");
        Assert.assertNull((Object)ek.getCarriedKeyName(), (String)"CarriedKeyName child");
    }

    @Test
    public void testChildElementsUnmarshall() {
        EncryptedKey ek = (EncryptedKey)this.unmarshallElement(this.childElementsFile);
        Assert.assertNotNull((Object)ek, (String)"EncryptedKey");
        Assert.assertNotNull((Object)ek.getEncryptionMethod(), (String)"EncryptionMethod child");
        Assert.assertNotNull((Object)ek.getKeyInfo(), (String)"KeyInfo child");
        Assert.assertNotNull((Object)ek.getCipherData(), (String)"CipherData child");
        Assert.assertNotNull((Object)ek.getEncryptionProperties(), (String)"EncryptionProperties child");
        Assert.assertNotNull((Object)ek.getReferenceList(), (String)"ReferenceList child");
        Assert.assertNotNull((Object)ek.getCarriedKeyName(), (String)"CarriedKeyName child");
    }

    @Test
    public void testSingleElementOptionalAttributesUnmarshall() {
        EncryptedKey ek = (EncryptedKey)this.unmarshallElement(this.singleElementOptionalAttributesFile);
        Assert.assertNotNull((Object)ek, (String)"EncryptedKey");
        Assert.assertEquals((String)ek.getID(), (String)this.expectedId, (String)"Id attribute");
        Assert.assertEquals((String)ek.getType(), (String)this.expectedType, (String)"Type attribute");
        Assert.assertEquals((String)ek.getMimeType(), (String)this.expectedMimeType, (String)"MimeType attribute");
        Assert.assertEquals((String)ek.getEncoding(), (String)this.expectedEncoding, (String)"Encoding attribute");
        Assert.assertEquals((String)ek.getRecipient(), (String)this.expectedRecipient, (String)"Recipient attribute");
        Assert.assertEquals((Object)ek.resolveID(this.expectedId), (Object)ek, (String)"ID lookup failed");
    }

    @Test
    public void testSingleElementMarshall() {
        EncryptedKey ek = (EncryptedKey)this.buildXMLObject(EncryptedKey.DEFAULT_ELEMENT_NAME);
        this.assertXMLEquals(this.expectedDOM, (XMLObject)ek);
    }

    @Test
    public void testAttributeIDnessMarshall() throws MarshallingException, XMLParserException {
        XMLObject target = this.buildXMLObject(EncryptedKey.DEFAULT_ELEMENT_NAME);
        ((EncryptedKey)target).setID("id123");
        this.testAttributeIDnessMarshall(target, "id123");
    }

    @Test
    public void testChildElementsMarshall() {
        EncryptedKey ek = (EncryptedKey)this.buildXMLObject(EncryptedKey.DEFAULT_ELEMENT_NAME);
        ek.setEncryptionMethod((EncryptionMethod)this.buildXMLObject(EncryptionMethod.DEFAULT_ELEMENT_NAME));
        ek.setKeyInfo((KeyInfo)this.buildXMLObject(KeyInfo.DEFAULT_ELEMENT_NAME));
        ek.setCipherData((CipherData)this.buildXMLObject(CipherData.DEFAULT_ELEMENT_NAME));
        ek.setEncryptionProperties((EncryptionProperties)this.buildXMLObject(EncryptionProperties.DEFAULT_ELEMENT_NAME));
        ek.setReferenceList((ReferenceList)this.buildXMLObject(ReferenceList.DEFAULT_ELEMENT_NAME));
        ek.setCarriedKeyName((CarriedKeyName)this.buildXMLObject(CarriedKeyName.DEFAULT_ELEMENT_NAME));
        this.assertXMLEquals(this.expectedChildElementsDOM, (XMLObject)ek);
    }

    @Test
    public void testSingleElementOptionalAttributesMarshall() {
        EncryptedKey ek = (EncryptedKey)this.buildXMLObject(EncryptedKey.DEFAULT_ELEMENT_NAME);
        ek.setID(this.expectedId);
        ek.setType(this.expectedType);
        ek.setMimeType(this.expectedMimeType);
        ek.setEncoding(this.expectedEncoding);
        ek.setRecipient(this.expectedRecipient);
        this.assertXMLEquals(this.expectedOptionalAttributesDOM, (XMLObject)ek);
    }
}

