/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.xmlsec.impl;

import java.security.KeyPair;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.utilities.java.support.logic.ConstraintViolationException;
import net.shibboleth.utilities.java.support.resolver.CriteriaSet;
import net.shibboleth.utilities.java.support.resolver.Criterion;
import net.shibboleth.utilities.java.support.resolver.ResolverException;
import org.opensaml.core.testing.XMLObjectBaseTestCase;
import org.opensaml.security.credential.BasicCredential;
import org.opensaml.security.credential.Credential;
import org.opensaml.security.credential.CredentialSupport;
import org.opensaml.security.crypto.KeySupport;
import org.opensaml.xmlsec.AlgorithmPolicyConfiguration;
import org.opensaml.xmlsec.AlgorithmPolicyParameters;
import org.opensaml.xmlsec.impl.AbstractSecurityParametersResolver;
import org.opensaml.xmlsec.impl.AlgorithmPolicyConfigurationCriterion;
import org.opensaml.xmlsec.impl.BasicAlgorithmPolicyConfiguration;
import org.opensaml.xmlsec.keyinfo.KeyInfoGeneratorFactory;
import org.opensaml.xmlsec.keyinfo.NamedKeyInfoGeneratorManager;
import org.opensaml.xmlsec.keyinfo.impl.BasicKeyInfoGeneratorFactory;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public class AbstractSecurityParametersResolverTest
extends XMLObjectBaseTestCase {
    private DummyParametersResolver resolver;
    private BasicAlgorithmPolicyConfiguration config1;
    private BasicAlgorithmPolicyConfiguration config2;
    private BasicAlgorithmPolicyConfiguration config3;
    private AlgorithmPolicyConfigurationCriterion criterion;
    private CriteriaSet criteriaSet;
    private Set<String> set1;
    private Set<String> set2;
    private Set<String> set3;

    @BeforeMethod
    public void setUp() {
        this.resolver = new DummyParametersResolver();
        this.config1 = new BasicAlgorithmPolicyConfiguration();
        this.config2 = new BasicAlgorithmPolicyConfiguration();
        this.config3 = new BasicAlgorithmPolicyConfiguration();
        this.criterion = new AlgorithmPolicyConfigurationCriterion(new AlgorithmPolicyConfiguration[]{this.config1, this.config2, this.config3});
        this.criteriaSet = new CriteriaSet(new Criterion[]{this.criterion});
        this.set1 = Set.of("A", "B", "C", "D");
        this.set2 = Set.of("X", "Y", "Z");
        this.set3 = Set.of("foo", "bar", "baz");
    }

    @Test
    public void testBlacklistOnlyDefaults() throws ResolverException {
        this.config1.setExcludedAlgorithms(this.set1);
        this.config2.setExcludedAlgorithms(this.set2);
        AlgorithmPolicyParameters params = this.resolver.resolveSingle(this.criteriaSet);
        HashSet<String> control = new HashSet<String>();
        control.addAll(this.set1);
        control.addAll(this.set2);
        Assert.assertTrue((boolean)params.getIncludedAlgorithms().equals(Collections.emptySet()));
        Assert.assertTrue((boolean)params.getExcludedAlgorithms().equals(control));
    }

    @Test
    public void testBlacklistOnlyNoMerge() throws ResolverException {
        this.config1.setExcludedAlgorithms(this.set1);
        this.config1.setExcludeMerge(false);
        this.config2.setExcludedAlgorithms(this.set2);
        AlgorithmPolicyParameters params = this.resolver.resolveSingle(this.criteriaSet);
        Assert.assertTrue((boolean)params.getIncludedAlgorithms().equals(Collections.emptySet()));
        Assert.assertTrue((boolean)params.getExcludedAlgorithms().equals(this.set1));
    }

    @Test
    public void testBlacklistOnlyWithSimpleMerge() throws ResolverException {
        this.config1.setExcludedAlgorithms(this.set1);
        this.config1.setExcludeMerge(true);
        this.config2.setExcludedAlgorithms(this.set2);
        AlgorithmPolicyParameters params = this.resolver.resolveSingle(this.criteriaSet);
        HashSet<String> control = new HashSet<String>();
        control.addAll(this.set1);
        control.addAll(this.set2);
        Assert.assertTrue((boolean)params.getIncludedAlgorithms().equals(Collections.emptySet()));
        Assert.assertTrue((boolean)params.getExcludedAlgorithms().equals(control));
    }

    @Test
    public void testBlacklistOnlyWithTransitiveMerge() throws ResolverException {
        this.config1.setExcludedAlgorithms(this.set1);
        this.config1.setExcludeMerge(true);
        this.config2.setExcludeMerge(true);
        this.config3.setExcludedAlgorithms(this.set3);
        AlgorithmPolicyParameters params = this.resolver.resolveSingle(this.criteriaSet);
        HashSet<String> control = new HashSet<String>();
        control.addAll(this.set1);
        control.addAll(this.set3);
        Assert.assertTrue((boolean)params.getIncludedAlgorithms().equals(Collections.emptySet()));
        Assert.assertTrue((boolean)params.getExcludedAlgorithms().equals(control));
    }

    @Test
    public void testWhitelistOnlyDefaults() throws ResolverException {
        this.config1.setIncludedAlgorithms(this.set1);
        this.config2.setIncludedAlgorithms(this.set2);
        AlgorithmPolicyParameters params = this.resolver.resolveSingle(this.criteriaSet);
        Assert.assertTrue((boolean)params.getIncludedAlgorithms().equals(this.set1));
        Assert.assertTrue((boolean)params.getExcludedAlgorithms().equals(Collections.emptySet()));
    }

    @Test
    public void testWhitelistOnlyWithSimpleMerge() throws ResolverException {
        this.config1.setIncludedAlgorithms(this.set1);
        this.config1.setIncludeMerge(true);
        this.config2.setIncludedAlgorithms(this.set2);
        AlgorithmPolicyParameters params = this.resolver.resolveSingle(this.criteriaSet);
        HashSet<String> control = new HashSet<String>();
        control.addAll(this.set1);
        control.addAll(this.set2);
        Assert.assertTrue((boolean)params.getIncludedAlgorithms().equals(control));
        Assert.assertTrue((boolean)params.getExcludedAlgorithms().equals(Collections.emptySet()));
    }

    @Test
    public void testWhitelistOnlyWithTransitiveMerge() throws ResolverException {
        this.config1.setIncludedAlgorithms(this.set1);
        this.config1.setIncludeMerge(true);
        this.config2.setIncludeMerge(true);
        this.config3.setIncludedAlgorithms(this.set3);
        AlgorithmPolicyParameters params = this.resolver.resolveSingle(this.criteriaSet);
        HashSet<String> control = new HashSet<String>();
        control.addAll(this.set1);
        control.addAll(this.set3);
        Assert.assertTrue((boolean)params.getIncludedAlgorithms().equals(control));
        Assert.assertTrue((boolean)params.getExcludedAlgorithms().equals(Collections.emptySet()));
    }

    @Test
    public void testPrecedence() throws ResolverException {
        this.config1.setIncludedAlgorithms(this.set1);
        this.config1.setExcludedAlgorithms(this.set2);
        this.config1.setIncludeExcludePrecedence(AlgorithmPolicyConfiguration.Precedence.INCLUDE);
        AlgorithmPolicyParameters params = this.resolver.resolveSingle(this.criteriaSet);
        Assert.assertTrue((boolean)params.getIncludedAlgorithms().equals(this.set1));
        Assert.assertTrue((boolean)params.getExcludedAlgorithms().equals(Collections.emptySet()));
        this.config1.setIncludeExcludePrecedence(AlgorithmPolicyConfiguration.Precedence.EXCLUDE);
        params = this.resolver.resolveSingle(this.criteriaSet);
        Assert.assertTrue((boolean)params.getIncludedAlgorithms().equals(Collections.emptySet()));
        Assert.assertTrue((boolean)params.getExcludedAlgorithms().equals(this.set2));
    }

    @Test
    public void testResolvePredicate() {
        this.config1.setIncludedAlgorithms(this.set1);
        this.config1.setExcludedAlgorithms(this.set2);
        this.config1.setIncludeExcludePrecedence(AlgorithmPolicyConfiguration.Precedence.INCLUDE);
        Predicate predicate = this.resolver.resolveIncludeExcludePredicate(this.criteriaSet, List.of(this.config1, this.config2, this.config3));
        Assert.assertTrue((boolean)predicate.test("A"));
        Assert.assertTrue((boolean)predicate.test("B"));
        Assert.assertTrue((boolean)predicate.test("C"));
        Assert.assertTrue((boolean)predicate.test("D"));
        Assert.assertFalse((boolean)predicate.test("X"));
        Assert.assertFalse((boolean)predicate.test("Y"));
        Assert.assertFalse((boolean)predicate.test("Z"));
        Assert.assertFalse((boolean)predicate.test("foo"));
        Assert.assertFalse((boolean)predicate.test("bar"));
        Assert.assertFalse((boolean)predicate.test("bax"));
        this.config1.setIncludeExcludePrecedence(AlgorithmPolicyConfiguration.Precedence.EXCLUDE);
        predicate = this.resolver.resolveIncludeExcludePredicate(this.criteriaSet, List.of(this.config1, this.config2, this.config3));
        Assert.assertTrue((boolean)predicate.test("A"));
        Assert.assertTrue((boolean)predicate.test("B"));
        Assert.assertTrue((boolean)predicate.test("C"));
        Assert.assertTrue((boolean)predicate.test("D"));
        Assert.assertTrue((boolean)predicate.test("foo"));
        Assert.assertTrue((boolean)predicate.test("bar"));
        Assert.assertTrue((boolean)predicate.test("bax"));
        Assert.assertFalse((boolean)predicate.test("X"));
        Assert.assertFalse((boolean)predicate.test("Y"));
        Assert.assertFalse((boolean)predicate.test("Z"));
    }

    @Test
    public void testResolveEffectiveWhitelist() {
        Collection whitelist = this.resolver.resolveEffectiveIncludes(this.criteriaSet, this.criterion.getConfigurations());
        Assert.assertTrue((boolean)whitelist.isEmpty());
        this.config1.setIncludedAlgorithms(this.set1);
        this.config2.setIncludedAlgorithms(this.set2);
        this.config3.setIncludedAlgorithms(this.set3);
        whitelist = this.resolver.resolveEffectiveIncludes(this.criteriaSet, this.criterion.getConfigurations());
        Assert.assertTrue((boolean)whitelist.containsAll(this.set1));
        Assert.assertFalse((boolean)whitelist.containsAll(this.set2));
        Assert.assertFalse((boolean)whitelist.containsAll(this.set3));
        this.config1.setIncludeMerge(true);
        whitelist = this.resolver.resolveEffectiveIncludes(this.criteriaSet, this.criterion.getConfigurations());
        Assert.assertTrue((boolean)whitelist.containsAll(this.set1));
        Assert.assertTrue((boolean)whitelist.containsAll(this.set2));
        Assert.assertFalse((boolean)whitelist.containsAll(this.set3));
        this.config1.setIncludeMerge(true);
        this.config2.setIncludeMerge(true);
        whitelist = this.resolver.resolveEffectiveIncludes(this.criteriaSet, this.criterion.getConfigurations());
        Assert.assertTrue((boolean)whitelist.containsAll(this.set1));
        Assert.assertTrue((boolean)whitelist.containsAll(this.set2));
        Assert.assertTrue((boolean)whitelist.containsAll(this.set3));
        this.config1.setIncludedAlgorithms(new HashSet());
        this.config2.setIncludedAlgorithms(new HashSet());
        this.config1.setIncludeMerge(true);
        this.config2.setIncludeMerge(true);
        whitelist = this.resolver.resolveEffectiveIncludes(this.criteriaSet, this.criterion.getConfigurations());
        Assert.assertFalse((boolean)whitelist.containsAll(this.set1));
        Assert.assertFalse((boolean)whitelist.containsAll(this.set2));
        Assert.assertTrue((boolean)whitelist.containsAll(this.set3));
    }

    @Test
    public void testResolveEffectiveBlacklist() {
        Collection blacklist = this.resolver.resolveEffectiveExcludes(this.criteriaSet, this.criterion.getConfigurations());
        Assert.assertTrue((boolean)blacklist.isEmpty());
        this.config1.setExcludedAlgorithms(this.set1);
        this.config2.setExcludedAlgorithms(this.set2);
        this.config3.setExcludedAlgorithms(this.set3);
        blacklist = this.resolver.resolveEffectiveExcludes(this.criteriaSet, this.criterion.getConfigurations());
        Assert.assertTrue((boolean)blacklist.containsAll(this.set1));
        Assert.assertTrue((boolean)blacklist.containsAll(this.set2));
        Assert.assertTrue((boolean)blacklist.containsAll(this.set3));
        this.config2.setExcludeMerge(false);
        blacklist = this.resolver.resolveEffectiveExcludes(this.criteriaSet, this.criterion.getConfigurations());
        Assert.assertTrue((boolean)blacklist.containsAll(this.set1));
        Assert.assertTrue((boolean)blacklist.containsAll(this.set2));
        Assert.assertFalse((boolean)blacklist.containsAll(this.set3));
        this.config1.setExcludeMerge(false);
        this.config2.setExcludeMerge(false);
        blacklist = this.resolver.resolveEffectiveExcludes(this.criteriaSet, this.criterion.getConfigurations());
        Assert.assertTrue((boolean)blacklist.containsAll(this.set1));
        Assert.assertFalse((boolean)blacklist.containsAll(this.set2));
        Assert.assertFalse((boolean)blacklist.containsAll(this.set3));
        this.config1.setExcludedAlgorithms(new HashSet());
        this.config2.setExcludedAlgorithms(new HashSet());
        this.config1.setExcludeMerge(true);
        this.config2.setExcludeMerge(true);
        blacklist = this.resolver.resolveEffectiveExcludes(this.criteriaSet, this.criterion.getConfigurations());
        Assert.assertFalse((boolean)blacklist.containsAll(this.set1));
        Assert.assertFalse((boolean)blacklist.containsAll(this.set2));
        Assert.assertTrue((boolean)blacklist.containsAll(this.set3));
    }

    @Test
    public void testResolveEffectivePrecedence() {
        this.config1.setIncludeExcludePrecedence(AlgorithmPolicyConfiguration.Precedence.INCLUDE);
        AlgorithmPolicyConfiguration.Precedence precedence = this.resolver.resolveIncludeExcludePrecedence(this.criteriaSet, this.criterion.getConfigurations());
        Assert.assertEquals((Object)precedence, (Object)AlgorithmPolicyConfiguration.Precedence.INCLUDE);
        this.config1.setIncludeExcludePrecedence(AlgorithmPolicyConfiguration.Precedence.EXCLUDE);
        precedence = this.resolver.resolveIncludeExcludePrecedence(this.criteriaSet, this.criterion.getConfigurations());
        Assert.assertEquals((Object)precedence, (Object)AlgorithmPolicyConfiguration.Precedence.EXCLUDE);
    }

    @Test
    public void testKeyInfoGeneratorLookup() throws NoSuchAlgorithmException, NoSuchProviderException {
        KeyPair kp = KeySupport.generateKeyPair((String)"RSA", (int)2048, null);
        BasicCredential cred = CredentialSupport.getSimpleCredential((PublicKey)kp.getPublic(), (PrivateKey)kp.getPrivate());
        NamedKeyInfoGeneratorManager manager = new NamedKeyInfoGeneratorManager();
        manager.setUseDefaultManager(false);
        manager.registerDefaultFactory((KeyInfoGeneratorFactory)new BasicKeyInfoGeneratorFactory());
        Assert.assertNotNull((Object)this.resolver.lookupKeyInfoGenerator((Credential)cred, manager, null));
        Assert.assertNull((Object)this.resolver.lookupKeyInfoGenerator((Credential)cred, manager, "test"));
        manager = new NamedKeyInfoGeneratorManager();
        manager.setUseDefaultManager(true);
        manager.registerDefaultFactory((KeyInfoGeneratorFactory)new BasicKeyInfoGeneratorFactory());
        Assert.assertNotNull((Object)this.resolver.lookupKeyInfoGenerator((Credential)cred, manager, null));
        Assert.assertNotNull((Object)this.resolver.lookupKeyInfoGenerator((Credential)cred, manager, "test"));
        manager = new NamedKeyInfoGeneratorManager();
        manager.registerFactory("test", (KeyInfoGeneratorFactory)new BasicKeyInfoGeneratorFactory());
        Assert.assertNull((Object)this.resolver.lookupKeyInfoGenerator((Credential)cred, manager, null));
        Assert.assertNotNull((Object)this.resolver.lookupKeyInfoGenerator((Credential)cred, manager, "test"));
        Assert.assertNull((Object)this.resolver.lookupKeyInfoGenerator((Credential)cred, null, null));
        Assert.assertNull((Object)this.resolver.lookupKeyInfoGenerator((Credential)cred, null, "test"));
        try {
            this.resolver.lookupKeyInfoGenerator(null, manager, "test");
            Assert.fail((String)"Null credential should have thrown");
        }
        catch (ConstraintViolationException constraintViolationException) {
            // empty catch block
        }
    }

    public class DummyParametersResolver
    extends AbstractSecurityParametersResolver<AlgorithmPolicyParameters> {
        @Nonnull
        public Iterable<AlgorithmPolicyParameters> resolve(CriteriaSet criteria) throws ResolverException {
            AlgorithmPolicyParameters params = this.resolveSingle(criteria);
            if (params != null) {
                return Collections.singletonList(params);
            }
            return Collections.emptyList();
        }

        @Nullable
        public AlgorithmPolicyParameters resolveSingle(CriteriaSet criteria) throws ResolverException {
            AlgorithmPolicyParameters params = new AlgorithmPolicyParameters();
            this.resolveAndPopulateIncludesExcludes(params, criteria, ((AlgorithmPolicyConfigurationCriterion)criteria.get(AlgorithmPolicyConfigurationCriterion.class)).getConfigurations());
            return params;
        }
    }
}

