/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.xmlsec.impl;

import java.util.Arrays;
import java.util.List;
import net.shibboleth.utilities.java.support.logic.ConstraintViolationException;
import org.opensaml.xmlsec.WhitelistBlacklistConfiguration;
import org.opensaml.xmlsec.impl.BasicWhitelistBlacklistConfiguration;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public class BasicWhitelistBlacklistConfigurationTest {
    private BasicWhitelistBlacklistConfiguration config;

    @BeforeMethod
    public void setUp() {
        this.config = new BasicWhitelistBlacklistConfiguration();
    }

    @Test
    public void testDefaults() {
        Assert.assertEquals((boolean)this.config.isWhitelistMerge(), (boolean)false);
        Assert.assertNotNull((Object)this.config.getWhitelistedAlgorithms());
        Assert.assertTrue((boolean)this.config.getWhitelistedAlgorithms().isEmpty());
        Assert.assertEquals((boolean)this.config.isBlacklistMerge(), (boolean)true);
        Assert.assertNotNull((Object)this.config.getBlacklistedAlgorithms());
        Assert.assertTrue((boolean)this.config.getBlacklistedAlgorithms().isEmpty());
        Assert.assertEquals((Object)this.config.getWhitelistBlacklistPrecedence(), (Object)WhitelistBlacklistConfiguration.Precedence.WHITELIST);
    }

    @Test
    public void testValidWhitelist() {
        this.config.setWhitelistedAlgorithms(Arrays.asList("  A   ", null, "   B   ", null, "   C   "));
        Assert.assertEquals((int)this.config.getWhitelistedAlgorithms().size(), (int)3);
        Assert.assertTrue((boolean)this.config.getWhitelistedAlgorithms().contains("A"));
        Assert.assertTrue((boolean)this.config.getWhitelistedAlgorithms().contains("B"));
        Assert.assertTrue((boolean)this.config.getWhitelistedAlgorithms().contains("C"));
    }

    @Test
    public void testNullWhitelist() {
        this.config.setWhitelistedAlgorithms(null);
        Assert.assertNotNull((Object)this.config.getWhitelistedAlgorithms());
        Assert.assertTrue((boolean)this.config.getWhitelistedAlgorithms().isEmpty());
    }

    @Test(expectedExceptions={UnsupportedOperationException.class})
    public void testWhitelistImmutable() {
        this.config.setWhitelistedAlgorithms(List.of("A", "B", "C"));
        this.config.getWhitelistedAlgorithms().add("D");
    }

    @Test
    public void testWhitelistMerge() {
        Assert.assertFalse((boolean)this.config.isWhitelistMerge());
        this.config.setWhitelistMerge(true);
        Assert.assertTrue((boolean)this.config.isWhitelistMerge());
        this.config.setWhitelistMerge(false);
        Assert.assertFalse((boolean)this.config.isWhitelistMerge());
    }

    @Test
    public void testValidBlacklist() {
        this.config.setBlacklistedAlgorithms(Arrays.asList("   A   ", null, "   B   ", null, "   C   "));
        Assert.assertEquals((int)this.config.getBlacklistedAlgorithms().size(), (int)3);
        Assert.assertTrue((boolean)this.config.getBlacklistedAlgorithms().contains("A"));
        Assert.assertTrue((boolean)this.config.getBlacklistedAlgorithms().contains("B"));
        Assert.assertTrue((boolean)this.config.getBlacklistedAlgorithms().contains("C"));
    }

    @Test
    public void testNullBlacklist() {
        this.config.setBlacklistedAlgorithms(null);
        Assert.assertNotNull((Object)this.config.getBlacklistedAlgorithms());
        Assert.assertTrue((boolean)this.config.getBlacklistedAlgorithms().isEmpty());
    }

    @Test(expectedExceptions={UnsupportedOperationException.class})
    public void testBlacklistImmutable() {
        this.config.setBlacklistedAlgorithms(List.of("A", "B", "C"));
        this.config.getBlacklistedAlgorithms().add("D");
    }

    @Test
    public void testBlacklistMerge() {
        Assert.assertTrue((boolean)this.config.isBlacklistMerge());
        this.config.setBlacklistMerge(false);
        Assert.assertFalse((boolean)this.config.isBlacklistMerge());
        this.config.setBlacklistMerge(true);
        Assert.assertTrue((boolean)this.config.isBlacklistMerge());
    }

    @Test
    public void testValidPrecedence() {
        Assert.assertEquals((Object)this.config.getWhitelistBlacklistPrecedence(), (Object)WhitelistBlacklistConfiguration.Precedence.WHITELIST);
        this.config.setWhitelistBlacklistPrecedence(WhitelistBlacklistConfiguration.Precedence.WHITELIST);
        Assert.assertEquals((Object)this.config.getWhitelistBlacklistPrecedence(), (Object)WhitelistBlacklistConfiguration.Precedence.WHITELIST);
        this.config.setWhitelistBlacklistPrecedence(WhitelistBlacklistConfiguration.Precedence.BLACKLIST);
        Assert.assertEquals((Object)this.config.getWhitelistBlacklistPrecedence(), (Object)WhitelistBlacklistConfiguration.Precedence.BLACKLIST);
    }

    @Test(expectedExceptions={ConstraintViolationException.class})
    public void testNullPrecedence() {
        this.config.setWhitelistBlacklistPrecedence(null);
    }
}

