/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.xmlsec.keyinfo.impl;

import com.google.common.collect.Iterables;
import java.security.Key;
import java.security.KeyPair;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.ECGenParameterSpec;
import java.util.ArrayList;
import javax.xml.namespace.QName;
import net.shibboleth.utilities.java.support.resolver.CriteriaSet;
import net.shibboleth.utilities.java.support.resolver.Criterion;
import net.shibboleth.utilities.java.support.resolver.ResolverException;
import org.opensaml.core.testing.XMLObjectBaseTestCase;
import org.opensaml.security.SecurityException;
import org.opensaml.security.credential.Credential;
import org.opensaml.security.credential.CredentialResolver;
import org.opensaml.security.credential.CredentialSupport;
import org.opensaml.security.credential.impl.CollectionCredentialResolver;
import org.opensaml.security.crypto.KeySupport;
import org.opensaml.xmlsec.agreement.KeyAgreementCredential;
import org.opensaml.xmlsec.agreement.KeyAgreementParameters;
import org.opensaml.xmlsec.agreement.impl.ECDHKeyAgreementProcessor;
import org.opensaml.xmlsec.algorithm.AlgorithmSupport;
import org.opensaml.xmlsec.derivation.impl.ConcatKDF;
import org.opensaml.xmlsec.encryption.AgreementMethod;
import org.opensaml.xmlsec.encryption.EncryptedData;
import org.opensaml.xmlsec.encryption.EncryptedType;
import org.opensaml.xmlsec.encryption.EncryptionMethod;
import org.opensaml.xmlsec.encryption.KeySize;
import org.opensaml.xmlsec.keyinfo.KeyInfoCriterion;
import org.opensaml.xmlsec.keyinfo.impl.KeyAgreementKeyInfoGeneratorFactory;
import org.opensaml.xmlsec.keyinfo.impl.KeyInfoCredentialContext;
import org.opensaml.xmlsec.keyinfo.impl.LocalKeyInfoCredentialResolver;
import org.opensaml.xmlsec.keyinfo.impl.provider.AgreementMethodKeyInfoProvider;
import org.opensaml.xmlsec.keyinfo.impl.provider.DEREncodedKeyValueProvider;
import org.opensaml.xmlsec.keyinfo.impl.provider.DSAKeyValueProvider;
import org.opensaml.xmlsec.keyinfo.impl.provider.InlineX509DataProvider;
import org.opensaml.xmlsec.keyinfo.impl.provider.RSAKeyValueProvider;
import org.opensaml.xmlsec.signature.KeyInfo;
import org.testng.Assert;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public class AgreementMethodTest
extends XMLObjectBaseTestCase {
    private LocalKeyInfoCredentialResolver resolver;
    private Credential credRecipientPrivateEC;
    private Credential credRecipientPublicEC;
    private KeyAgreementCredential credKeyAgreementOriginatorEC;
    private CollectionCredentialResolver recipientLocalCredResolver;
    private KeyAgreementKeyInfoGeneratorFactory keyInfoFactory;
    private String expectedEncryptionAlgorithm = "http://www.w3.org/2009/xmlenc11#aes256-gcm";

    @BeforeClass
    public void beforeClass() throws Exception {
        KeyPair kpRecipientEC = KeySupport.generateKeyPair((String)"EC", (AlgorithmParameterSpec)new ECGenParameterSpec("secp256r1"), null);
        this.credRecipientPrivateEC = CredentialSupport.getSimpleCredential((PublicKey)kpRecipientEC.getPublic(), (PrivateKey)kpRecipientEC.getPrivate());
        this.credRecipientPublicEC = CredentialSupport.getSimpleCredential((PublicKey)kpRecipientEC.getPublic(), null);
        this.recipientLocalCredResolver = new CollectionCredentialResolver();
        ArrayList<Object> providers = new ArrayList<Object>();
        providers.add(new RSAKeyValueProvider());
        providers.add(new DSAKeyValueProvider());
        providers.add(new DEREncodedKeyValueProvider());
        providers.add(new InlineX509DataProvider());
        providers.add(new AgreementMethodKeyInfoProvider());
        this.resolver = new LocalKeyInfoCredentialResolver(providers, (CredentialResolver)this.recipientLocalCredResolver);
        this.keyInfoFactory = new KeyAgreementKeyInfoGeneratorFactory();
    }

    @BeforeMethod
    public void beforeMethod() throws Exception {
        this.recipientLocalCredResolver.getCollection().clear();
        this.recipientLocalCredResolver.getCollection().add(this.credRecipientPrivateEC);
        ConcatKDF kdf = new ConcatKDF();
        kdf.setDigestMethod("http://www.w3.org/2001/04/xmlenc#sha512");
        kdf.setAlgorithmID("AA");
        kdf.setPartyUInfo("BB");
        kdf.setPartyVInfo("CC");
        kdf.setSuppPubInfo("DD");
        kdf.setSuppPrivInfo("EE");
        kdf.initialize();
        KeyAgreementParameters params = new KeyAgreementParameters();
        params.add((Object)kdf);
        ECDHKeyAgreementProcessor processor = new ECDHKeyAgreementProcessor();
        this.credKeyAgreementOriginatorEC = processor.execute(this.credRecipientPublicEC, this.expectedEncryptionAlgorithm, params);
    }

    @Test
    public void ECDHWithConcatKDF_Success() throws Exception {
        KeyInfo keyInfo = this.prepareAndValidateKeyInfo(this.credKeyAgreementOriginatorEC);
        Iterable creds = this.resolver.resolve(new CriteriaSet(new Criterion[]{new KeyInfoCriterion(keyInfo)}));
        Assert.assertNotNull((Object)creds);
        Assert.assertEquals((int)Iterables.size((Iterable)creds), (int)1);
        Credential cred = (Credential)creds.iterator().next();
        Assert.assertTrue((boolean)KeyAgreementCredential.class.isInstance(cred));
        KeyAgreementCredential keyAgreementCred = (KeyAgreementCredential)KeyAgreementCredential.class.cast(cred);
        Assert.assertEquals((String)keyAgreementCred.getAlgorithm(), (String)"http://www.w3.org/2009/xmlenc11#ECDH-ES");
        this.validateDerivedKey((Credential)keyAgreementCred, this.expectedEncryptionAlgorithm);
        Assert.assertNotNull((Object)keyAgreementCred.getOriginatorCredential());
        Assert.assertNotNull((Object)keyAgreementCred.getOriginatorCredential().getPublicKey());
        Assert.assertNull((Object)keyAgreementCred.getOriginatorCredential().getPrivateKey());
        Assert.assertEquals((Object)keyAgreementCred.getOriginatorCredential().getPublicKey(), (Object)this.credKeyAgreementOriginatorEC.getOriginatorCredential().getPublicKey());
        Assert.assertNotNull((Object)keyAgreementCred.getRecipientCredential());
        Assert.assertNotNull((Object)keyAgreementCred.getRecipientCredential().getPublicKey());
        Assert.assertNotNull((Object)keyAgreementCred.getRecipientCredential().getPrivateKey());
        Assert.assertEquals((Object)keyAgreementCred.getRecipientCredential().getPublicKey(), (Object)this.credRecipientPrivateEC.getPublicKey());
        Assert.assertEquals((Object)keyAgreementCred.getRecipientCredential().getPrivateKey(), (Object)this.credRecipientPrivateEC.getPrivateKey());
        Assert.assertTrue((boolean)keyAgreementCred.getParameters().contains(ConcatKDF.class));
        ConcatKDF kdf = (ConcatKDF)keyAgreementCred.getParameters().get(ConcatKDF.class);
        Assert.assertEquals((String)kdf.getDigestMethod(), (String)"http://www.w3.org/2001/04/xmlenc#sha512");
        Assert.assertEquals((String)kdf.getAlgorithmID(), (String)"AA");
        Assert.assertEquals((String)kdf.getPartyUInfo(), (String)"BB");
        Assert.assertEquals((String)kdf.getPartyVInfo(), (String)"CC");
        Assert.assertEquals((String)kdf.getSuppPubInfo(), (String)"DD");
        Assert.assertEquals((String)kdf.getSuppPrivInfo(), (String)"EE");
        Assert.assertTrue((boolean)keyAgreementCred.getCredentialContextSet().contains(KeyInfoCredentialContext.class));
        Assert.assertSame((Object)((KeyInfoCredentialContext)keyAgreementCred.getCredentialContextSet().get(KeyInfoCredentialContext.class)).getKeyInfo(), (Object)keyInfo);
    }

    @Test
    public void agreementAlgorithmNotRegistered() throws Exception {
        KeyInfo keyInfo = this.prepareAndValidateKeyInfo(this.credKeyAgreementOriginatorEC);
        ((AgreementMethod)keyInfo.getAgreementMethods().get(0)).setAlgorithm("INVALID");
        Iterable creds = this.resolver.resolve(new CriteriaSet(new Criterion[]{new KeyInfoCriterion(keyInfo)}));
        Assert.assertNotNull((Object)creds);
        Assert.assertEquals((int)Iterables.size((Iterable)creds), (int)0);
    }

    @Test
    public void agreementMethodNotGranndchildOfEncryptedType() throws Exception {
        KeyInfo keyInfo = this.prepareAndValidateKeyInfo(this.credKeyAgreementOriginatorEC);
        keyInfo.setParent(null);
        Iterable creds = this.resolver.resolve(new CriteriaSet(new Criterion[]{new KeyInfoCriterion(keyInfo)}));
        Assert.assertNotNull((Object)creds);
        Assert.assertEquals((int)Iterables.size((Iterable)creds), (int)0);
    }

    @Test(expectedExceptions={ResolverException.class})
    public void missingEncryptionAlgorithm() throws Exception {
        KeyInfo keyInfo = this.prepareAndValidateKeyInfo(this.credKeyAgreementOriginatorEC);
        ((EncryptedType)EncryptedType.class.cast(keyInfo.getParent())).getEncryptionMethod().setAlgorithm(null);
        this.resolver.resolve(new CriteriaSet(new Criterion[]{new KeyInfoCriterion(keyInfo)}));
    }

    @Test(expectedExceptions={ResolverException.class})
    public void unknownEncryptionAlgorithm() throws Exception {
        KeyInfo keyInfo = this.prepareAndValidateKeyInfo(this.credKeyAgreementOriginatorEC);
        ((EncryptedType)EncryptedType.class.cast(keyInfo.getParent())).getEncryptionMethod().setAlgorithm("INVALID");
        this.resolver.resolve(new CriteriaSet(new Criterion[]{new KeyInfoCriterion(keyInfo)}));
    }

    @Test(expectedExceptions={ResolverException.class})
    public void missingOriginatorKeyInfo() throws Exception {
        KeyInfo keyInfo = this.prepareAndValidateKeyInfo(this.credKeyAgreementOriginatorEC);
        ((AgreementMethod)keyInfo.getAgreementMethods().get(0)).setOriginatorKeyInfo(null);
        this.resolver.resolve(new CriteriaSet(new Criterion[]{new KeyInfoCriterion(keyInfo)}));
    }

    @Test(expectedExceptions={ResolverException.class})
    public void originatorCredResolutionFailedMissingKeyInfoData() throws Exception {
        KeyInfo keyInfo = this.prepareAndValidateKeyInfo(this.credKeyAgreementOriginatorEC);
        ((AgreementMethod)keyInfo.getAgreementMethods().get(0)).getOriginatorKeyInfo().getDEREncodedKeyValues().clear();
        ((AgreementMethod)keyInfo.getAgreementMethods().get(0)).getOriginatorKeyInfo().getKeyValues().clear();
        this.resolver.resolve(new CriteriaSet(new Criterion[]{new KeyInfoCriterion(keyInfo)}));
    }

    @Test(expectedExceptions={ResolverException.class})
    public void missingRecipientKeyInfo() throws Exception {
        KeyInfo keyInfo = this.prepareAndValidateKeyInfo(this.credKeyAgreementOriginatorEC);
        ((AgreementMethod)keyInfo.getAgreementMethods().get(0)).setRecipientKeyInfo(null);
        this.resolver.resolve(new CriteriaSet(new Criterion[]{new KeyInfoCriterion(keyInfo)}));
    }

    @Test(expectedExceptions={ResolverException.class})
    public void recipientCredResolutionFailedMissingKeyInfoData() throws Exception {
        KeyInfo keyInfo = this.prepareAndValidateKeyInfo(this.credKeyAgreementOriginatorEC);
        ((AgreementMethod)keyInfo.getAgreementMethods().get(0)).getRecipientKeyInfo().getDEREncodedKeyValues().clear();
        ((AgreementMethod)keyInfo.getAgreementMethods().get(0)).getRecipientKeyInfo().getKeyValues().clear();
        this.resolver.resolve(new CriteriaSet(new Criterion[]{new KeyInfoCriterion(keyInfo)}));
    }

    @Test(expectedExceptions={ResolverException.class})
    public void recipientCredResolutionFailedAtCredentialResolver() throws Exception {
        KeyInfo keyInfo = this.prepareAndValidateKeyInfo(this.credKeyAgreementOriginatorEC);
        this.recipientLocalCredResolver.getCollection().clear();
        this.resolver.resolve(new CriteriaSet(new Criterion[]{new KeyInfoCriterion(keyInfo)}));
    }

    @Test(expectedExceptions={ResolverException.class})
    public void recipientCredMissingPrivateKey() throws Exception {
        KeyInfo keyInfo = this.prepareAndValidateKeyInfo(this.credKeyAgreementOriginatorEC);
        this.recipientLocalCredResolver.getCollection().clear();
        this.recipientLocalCredResolver.getCollection().add(this.credRecipientPublicEC);
        this.resolver.resolve(new CriteriaSet(new Criterion[]{new KeyInfoCriterion(keyInfo)}));
    }

    private KeyInfo prepareAndValidateKeyInfo(KeyAgreementCredential cred) throws SecurityException {
        KeyInfo keyInfo = this.keyInfoFactory.newInstance().generate((Credential)this.credKeyAgreementOriginatorEC);
        Assert.assertNotNull((Object)keyInfo);
        Assert.assertEquals((int)keyInfo.getOrderedChildren().size(), (int)1);
        Assert.assertEquals((int)keyInfo.getAgreementMethods().size(), (int)1);
        this.makeEncryptionMethodChild(keyInfo, this.expectedEncryptionAlgorithm, null, EncryptedData.DEFAULT_ELEMENT_NAME);
        return keyInfo;
    }

    private EncryptedType makeEncryptionMethodChild(KeyInfo keyinfo, String algorithm, Integer keySize, QName elementType) {
        EncryptedType encryptedType = (EncryptedType)this.buildXMLObject(elementType);
        encryptedType.setKeyInfo(keyinfo);
        EncryptionMethod encryptionMethod = (EncryptionMethod)this.buildXMLObject(EncryptionMethod.DEFAULT_ELEMENT_NAME);
        encryptionMethod.setAlgorithm(algorithm);
        if (keySize != null) {
            KeySize keySizeElement = (KeySize)this.buildXMLObject(KeySize.DEFAULT_ELEMENT_NAME);
            keySizeElement.setValue(keySize);
            encryptionMethod.setKeySize(keySizeElement);
        }
        encryptedType.setEncryptionMethod(encryptionMethod);
        return encryptedType;
    }

    private void validateDerivedKey(Credential credential, String algorithmURI) {
        Assert.assertNotNull((Object)credential);
        Assert.assertNotNull((Object)credential.getSecretKey());
        Assert.assertEquals((String)credential.getSecretKey().getAlgorithm(), (String)AlgorithmSupport.getKeyAlgorithm((String)algorithmURI));
        Assert.assertEquals((Object)KeySupport.getKeyLength((Key)credential.getSecretKey()), (Object)AlgorithmSupport.getKeyLength((String)algorithmURI));
    }
}

