/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.xmlsec.keyinfo.impl;

import java.security.InvalidAlgorithmParameterException;
import java.security.KeyPair;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.ECGenParameterSpec;
import javax.crypto.SecretKey;
import org.opensaml.core.testing.XMLObjectBaseTestCase;
import org.opensaml.security.credential.BasicCredential;
import org.opensaml.security.credential.Credential;
import org.opensaml.security.crypto.KeySupport;
import org.opensaml.xmlsec.agreement.KeyAgreementCredential;
import org.opensaml.xmlsec.agreement.impl.BasicKeyAgreementCredential;
import org.opensaml.xmlsec.agreement.impl.DigestMethod;
import org.opensaml.xmlsec.agreement.impl.KANonce;
import org.opensaml.xmlsec.derivation.impl.ConcatKDF;
import org.opensaml.xmlsec.derivation.impl.PBKDF2;
import org.opensaml.xmlsec.encryption.AgreementMethod;
import org.opensaml.xmlsec.encryption.ConcatKDFParams;
import org.opensaml.xmlsec.encryption.KeyDerivationMethod;
import org.opensaml.xmlsec.encryption.OriginatorKeyInfo;
import org.opensaml.xmlsec.encryption.PBKDF2Params;
import org.opensaml.xmlsec.encryption.RecipientKeyInfo;
import org.opensaml.xmlsec.keyinfo.KeyInfoGenerator;
import org.opensaml.xmlsec.keyinfo.KeyInfoSupport;
import org.opensaml.xmlsec.keyinfo.impl.KeyAgreementKeyInfoGeneratorFactory;
import org.opensaml.xmlsec.signature.DEREncodedKeyValue;
import org.opensaml.xmlsec.signature.KeyInfo;
import org.opensaml.xmlsec.signature.KeyValue;
import org.testng.Assert;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public class KeyAgreementKeyInfoGeneratorTest
extends XMLObjectBaseTestCase {
    private KeyPair keyPairOriginatorECDH;
    private KeyPair keyPairRecipientECDH;
    private KeyPair keyPairOriginatorDiffieHellman;
    private KeyPair keyPairRecipientDiffieHellman;
    private Credential credOriginatorECDH;
    private Credential credRecipientECDH;
    private Credential credOriginatorDiffieHellman;
    private Credential credRecipientDiffieHellman;
    private SecretKey derivedKey;
    private KeyAgreementCredential credECDH;
    private KeyAgreementCredential credDiffieHellmanExplicitKDF;
    private KeyAgreementCredential credDiffieHellmanLegacyKDF;
    private KeyAgreementKeyInfoGeneratorFactory factory;

    @BeforeClass
    public void beforeClass() throws NoSuchAlgorithmException, NoSuchProviderException, InvalidAlgorithmParameterException {
        this.keyPairOriginatorECDH = KeySupport.generateKeyPair((String)"EC", (AlgorithmParameterSpec)new ECGenParameterSpec("secp256r1"), null);
        this.credOriginatorECDH = new BasicCredential(this.keyPairOriginatorECDH.getPublic(), this.keyPairOriginatorECDH.getPrivate());
        this.keyPairRecipientECDH = KeySupport.generateKeyPair((String)"EC", (AlgorithmParameterSpec)new ECGenParameterSpec("secp256r1"), null);
        this.credRecipientECDH = new BasicCredential(this.keyPairRecipientECDH.getPublic());
        this.keyPairOriginatorDiffieHellman = KeySupport.generateKeyPair((String)"DiffieHellman", (int)1024, null);
        this.credOriginatorDiffieHellman = new BasicCredential(this.keyPairOriginatorDiffieHellman.getPublic(), this.keyPairOriginatorDiffieHellman.getPrivate());
        this.keyPairRecipientDiffieHellman = KeySupport.generateKeyPair((String)"DiffieHellman", (int)1024, null);
        this.credRecipientDiffieHellman = new BasicCredential(this.keyPairRecipientDiffieHellman.getPublic());
        this.derivedKey = KeySupport.generateKey((String)"AES", (int)256, null);
    }

    @BeforeMethod
    public void beforeMethod() {
        this.factory = new KeyAgreementKeyInfoGeneratorFactory();
        this.credECDH = new BasicKeyAgreementCredential(this.derivedKey, "http://www.w3.org/2009/xmlenc11#ECDH-ES", this.credOriginatorECDH, this.credRecipientECDH);
        this.credDiffieHellmanExplicitKDF = new BasicKeyAgreementCredential(this.derivedKey, "http://www.w3.org/2009/xmlenc11#dh-es", this.credOriginatorDiffieHellman, this.credRecipientDiffieHellman);
        this.credDiffieHellmanLegacyKDF = new BasicKeyAgreementCredential(this.derivedKey, "http://www.w3.org/2001/04/xmlenc#dh", this.credOriginatorDiffieHellman, this.credRecipientDiffieHellman);
    }

    @Test
    public void ECDHWithConcatKDFWithDefaults() throws Exception {
        ConcatKDF kdf = new ConcatKDF();
        kdf.setDigestMethod("http://www.w3.org/2001/04/xmlenc#sha512");
        kdf.setAlgorithmID("AA");
        kdf.setPartyUInfo("BB");
        kdf.setPartyVInfo("CC");
        kdf.setSuppPubInfo("DD");
        kdf.setSuppPrivInfo("EE");
        kdf.initialize();
        this.credECDH.getParameters().add((Object)kdf);
        KeyInfoGenerator generator = this.factory.newInstance();
        KeyInfo keyInfo = generator.generate((Credential)this.credECDH);
        Assert.assertNotNull((Object)keyInfo);
        Assert.assertNotNull((Object)keyInfo.getOrderedChildren());
        Assert.assertEquals((int)keyInfo.getOrderedChildren().size(), (int)1);
        Assert.assertEquals((int)keyInfo.getAgreementMethods().size(), (int)1);
        AgreementMethod agreementMethod = (AgreementMethod)keyInfo.getAgreementMethods().get(0);
        Assert.assertEquals((String)agreementMethod.getAlgorithm(), (String)this.credECDH.getAlgorithm());
        Assert.assertEquals((int)agreementMethod.getOrderedChildren().size(), (int)3);
        Assert.assertNotNull((Object)agreementMethod.getOriginatorKeyInfo());
        OriginatorKeyInfo originatorKeyInfo = agreementMethod.getOriginatorKeyInfo();
        Assert.assertEquals((int)originatorKeyInfo.getOrderedChildren().size(), (int)2);
        Assert.assertEquals((int)originatorKeyInfo.getDEREncodedKeyValues().size(), (int)1);
        Assert.assertEquals((Object)KeyInfoSupport.getKey((DEREncodedKeyValue)((DEREncodedKeyValue)originatorKeyInfo.getDEREncodedKeyValues().get(0))), (Object)this.keyPairOriginatorECDH.getPublic());
        Assert.assertEquals((int)originatorKeyInfo.getKeyValues().size(), (int)1);
        Assert.assertEquals((Object)KeyInfoSupport.getKey((KeyValue)((KeyValue)originatorKeyInfo.getKeyValues().get(0))), (Object)this.keyPairOriginatorECDH.getPublic());
        Assert.assertNotNull((Object)agreementMethod.getRecipientKeyInfo());
        RecipientKeyInfo recipientKeyInfo = agreementMethod.getRecipientKeyInfo();
        Assert.assertEquals((int)recipientKeyInfo.getOrderedChildren().size(), (int)2);
        Assert.assertEquals((int)recipientKeyInfo.getDEREncodedKeyValues().size(), (int)1);
        Assert.assertEquals((Object)KeyInfoSupport.getKey((DEREncodedKeyValue)((DEREncodedKeyValue)recipientKeyInfo.getDEREncodedKeyValues().get(0))), (Object)this.keyPairRecipientECDH.getPublic());
        Assert.assertEquals((int)recipientKeyInfo.getKeyValues().size(), (int)1);
        Assert.assertEquals((Object)KeyInfoSupport.getKey((KeyValue)((KeyValue)recipientKeyInfo.getKeyValues().get(0))), (Object)this.keyPairRecipientECDH.getPublic());
        Assert.assertEquals((int)agreementMethod.getUnknownXMLObjects(KeyDerivationMethod.DEFAULT_ELEMENT_NAME).size(), (int)1);
        KeyDerivationMethod kdm = (KeyDerivationMethod)agreementMethod.getUnknownXMLObjects(KeyDerivationMethod.DEFAULT_ELEMENT_NAME).get(0);
        Assert.assertEquals((String)kdm.getAlgorithm(), (String)"http://www.w3.org/2009/xmlenc11#ConcatKDF");
        Assert.assertEquals((int)kdm.getUnknownXMLObjects().size(), (int)1);
        Assert.assertEquals((int)kdm.getUnknownXMLObjects(ConcatKDFParams.DEFAULT_ELEMENT_NAME).size(), (int)1);
        ConcatKDFParams kdfParams = (ConcatKDFParams)kdm.getUnknownXMLObjects(ConcatKDFParams.DEFAULT_ELEMENT_NAME).get(0);
        Assert.assertNotNull((Object)kdfParams.getDigestMethod());
        Assert.assertEquals((String)kdfParams.getDigestMethod().getAlgorithm(), (String)"http://www.w3.org/2001/04/xmlenc#sha512");
        Assert.assertEquals((String)kdfParams.getAlgorithmID(), (String)"00AA");
        Assert.assertEquals((String)kdfParams.getPartyUInfo(), (String)"00BB");
        Assert.assertEquals((String)kdfParams.getPartyVInfo(), (String)"00CC");
        Assert.assertEquals((String)kdfParams.getSuppPubInfo(), (String)"00DD");
        Assert.assertEquals((String)kdfParams.getSuppPrivInfo(), (String)"00EE");
    }

    @Test
    public void ECDHWithPBKDF2WithDefaults() throws Exception {
        PBKDF2 kdf = new PBKDF2();
        kdf.setIterationCount(Integer.valueOf(1500));
        kdf.setKeyLength(Integer.valueOf(256));
        kdf.setPRF("http://www.w3.org/2001/04/xmldsig-more#hmac-sha512");
        kdf.setSalt("ABCD");
        kdf.initialize();
        this.credECDH.getParameters().add((Object)kdf);
        KeyInfoGenerator generator = this.factory.newInstance();
        KeyInfo keyInfo = generator.generate((Credential)this.credECDH);
        Assert.assertNotNull((Object)keyInfo);
        Assert.assertNotNull((Object)keyInfo.getOrderedChildren());
        Assert.assertEquals((int)keyInfo.getOrderedChildren().size(), (int)1);
        Assert.assertEquals((int)keyInfo.getAgreementMethods().size(), (int)1);
        AgreementMethod agreementMethod = (AgreementMethod)keyInfo.getAgreementMethods().get(0);
        Assert.assertEquals((String)agreementMethod.getAlgorithm(), (String)this.credECDH.getAlgorithm());
        Assert.assertEquals((int)agreementMethod.getOrderedChildren().size(), (int)3);
        Assert.assertNotNull((Object)agreementMethod.getOriginatorKeyInfo());
        OriginatorKeyInfo originatorKeyInfo = agreementMethod.getOriginatorKeyInfo();
        Assert.assertEquals((int)originatorKeyInfo.getOrderedChildren().size(), (int)2);
        Assert.assertEquals((int)originatorKeyInfo.getDEREncodedKeyValues().size(), (int)1);
        Assert.assertEquals((Object)KeyInfoSupport.getKey((DEREncodedKeyValue)((DEREncodedKeyValue)originatorKeyInfo.getDEREncodedKeyValues().get(0))), (Object)this.keyPairOriginatorECDH.getPublic());
        Assert.assertEquals((int)originatorKeyInfo.getKeyValues().size(), (int)1);
        Assert.assertEquals((Object)KeyInfoSupport.getKey((KeyValue)((KeyValue)originatorKeyInfo.getKeyValues().get(0))), (Object)this.keyPairOriginatorECDH.getPublic());
        Assert.assertNotNull((Object)agreementMethod.getRecipientKeyInfo());
        RecipientKeyInfo recipientKeyInfo = agreementMethod.getRecipientKeyInfo();
        Assert.assertEquals((int)recipientKeyInfo.getOrderedChildren().size(), (int)2);
        Assert.assertEquals((int)recipientKeyInfo.getDEREncodedKeyValues().size(), (int)1);
        Assert.assertEquals((Object)KeyInfoSupport.getKey((DEREncodedKeyValue)((DEREncodedKeyValue)recipientKeyInfo.getDEREncodedKeyValues().get(0))), (Object)this.keyPairRecipientECDH.getPublic());
        Assert.assertEquals((int)recipientKeyInfo.getKeyValues().size(), (int)1);
        Assert.assertEquals((Object)KeyInfoSupport.getKey((KeyValue)((KeyValue)recipientKeyInfo.getKeyValues().get(0))), (Object)this.keyPairRecipientECDH.getPublic());
        Assert.assertEquals((int)agreementMethod.getUnknownXMLObjects(KeyDerivationMethod.DEFAULT_ELEMENT_NAME).size(), (int)1);
        KeyDerivationMethod kdm = (KeyDerivationMethod)agreementMethod.getUnknownXMLObjects(KeyDerivationMethod.DEFAULT_ELEMENT_NAME).get(0);
        Assert.assertEquals((String)kdm.getAlgorithm(), (String)"http://www.w3.org/2009/xmlenc11#pbkdf2");
        Assert.assertEquals((int)kdm.getUnknownXMLObjects().size(), (int)1);
        Assert.assertEquals((int)kdm.getUnknownXMLObjects(PBKDF2Params.DEFAULT_ELEMENT_NAME).size(), (int)1);
        PBKDF2Params kdfParams = (PBKDF2Params)kdm.getUnknownXMLObjects(PBKDF2Params.DEFAULT_ELEMENT_NAME).get(0);
        Assert.assertNotNull((Object)kdfParams.getIterationCount());
        Assert.assertEquals((int)kdfParams.getIterationCount().getValue(), (int)1500);
        Assert.assertNotNull((Object)kdfParams.getKeyLength());
        Assert.assertEquals((int)kdfParams.getKeyLength().getValue(), (int)32);
        Assert.assertNotNull((Object)kdfParams.getPRF());
        Assert.assertEquals((String)kdfParams.getPRF().getAlgorithm(), (String)"http://www.w3.org/2001/04/xmldsig-more#hmac-sha512");
        Assert.assertNotNull((Object)kdfParams.getSalt());
        Assert.assertNotNull((Object)kdfParams.getSalt().getSpecified());
        Assert.assertEquals((String)kdfParams.getSalt().getSpecified().getValue(), (String)"ABCD");
    }

    @Test
    public void DiffieHellmanWithConcatKDFWithDefaults() throws Exception {
        ConcatKDF kdf = new ConcatKDF();
        kdf.setDigestMethod("http://www.w3.org/2001/04/xmlenc#sha512");
        kdf.setAlgorithmID("AA");
        kdf.setPartyUInfo("BB");
        kdf.setPartyVInfo("CC");
        kdf.setSuppPubInfo("DD");
        kdf.setSuppPrivInfo("EE");
        kdf.initialize();
        this.credDiffieHellmanExplicitKDF.getParameters().add((Object)kdf);
        KeyInfoGenerator generator = this.factory.newInstance();
        KeyInfo keyInfo = generator.generate((Credential)this.credDiffieHellmanExplicitKDF);
        Assert.assertNotNull((Object)keyInfo);
        Assert.assertNotNull((Object)keyInfo.getOrderedChildren());
        Assert.assertEquals((int)keyInfo.getOrderedChildren().size(), (int)1);
        Assert.assertEquals((int)keyInfo.getAgreementMethods().size(), (int)1);
        AgreementMethod agreementMethod = (AgreementMethod)keyInfo.getAgreementMethods().get(0);
        Assert.assertEquals((String)agreementMethod.getAlgorithm(), (String)this.credDiffieHellmanExplicitKDF.getAlgorithm());
        Assert.assertEquals((int)agreementMethod.getOrderedChildren().size(), (int)3);
        Assert.assertNotNull((Object)agreementMethod.getOriginatorKeyInfo());
        OriginatorKeyInfo originatorKeyInfo = agreementMethod.getOriginatorKeyInfo();
        Assert.assertEquals((int)originatorKeyInfo.getOrderedChildren().size(), (int)2);
        Assert.assertEquals((int)originatorKeyInfo.getDEREncodedKeyValues().size(), (int)1);
        Assert.assertEquals((Object)KeyInfoSupport.getKey((DEREncodedKeyValue)((DEREncodedKeyValue)originatorKeyInfo.getDEREncodedKeyValues().get(0))), (Object)this.keyPairOriginatorDiffieHellman.getPublic());
        Assert.assertEquals((int)originatorKeyInfo.getKeyValues().size(), (int)1);
        Assert.assertEquals((Object)KeyInfoSupport.getKey((KeyValue)((KeyValue)originatorKeyInfo.getKeyValues().get(0))), (Object)this.keyPairOriginatorDiffieHellman.getPublic());
        Assert.assertNotNull((Object)agreementMethod.getRecipientKeyInfo());
        RecipientKeyInfo recipientKeyInfo = agreementMethod.getRecipientKeyInfo();
        Assert.assertEquals((int)recipientKeyInfo.getOrderedChildren().size(), (int)2);
        Assert.assertEquals((int)recipientKeyInfo.getDEREncodedKeyValues().size(), (int)1);
        Assert.assertEquals((Object)KeyInfoSupport.getKey((DEREncodedKeyValue)((DEREncodedKeyValue)recipientKeyInfo.getDEREncodedKeyValues().get(0))), (Object)this.keyPairRecipientDiffieHellman.getPublic());
        Assert.assertEquals((int)recipientKeyInfo.getKeyValues().size(), (int)1);
        Assert.assertEquals((Object)KeyInfoSupport.getKey((KeyValue)((KeyValue)recipientKeyInfo.getKeyValues().get(0))), (Object)this.keyPairRecipientDiffieHellman.getPublic());
        Assert.assertEquals((int)agreementMethod.getUnknownXMLObjects(KeyDerivationMethod.DEFAULT_ELEMENT_NAME).size(), (int)1);
        KeyDerivationMethod kdm = (KeyDerivationMethod)agreementMethod.getUnknownXMLObjects(KeyDerivationMethod.DEFAULT_ELEMENT_NAME).get(0);
        Assert.assertEquals((String)kdm.getAlgorithm(), (String)"http://www.w3.org/2009/xmlenc11#ConcatKDF");
        Assert.assertEquals((int)kdm.getUnknownXMLObjects().size(), (int)1);
        Assert.assertEquals((int)kdm.getUnknownXMLObjects(ConcatKDFParams.DEFAULT_ELEMENT_NAME).size(), (int)1);
        ConcatKDFParams kdfParams = (ConcatKDFParams)kdm.getUnknownXMLObjects(ConcatKDFParams.DEFAULT_ELEMENT_NAME).get(0);
        Assert.assertNotNull((Object)kdfParams.getDigestMethod());
        Assert.assertEquals((String)kdfParams.getDigestMethod().getAlgorithm(), (String)"http://www.w3.org/2001/04/xmlenc#sha512");
        Assert.assertEquals((String)kdfParams.getAlgorithmID(), (String)"00AA");
        Assert.assertEquals((String)kdfParams.getPartyUInfo(), (String)"00BB");
        Assert.assertEquals((String)kdfParams.getPartyVInfo(), (String)"00CC");
        Assert.assertEquals((String)kdfParams.getSuppPubInfo(), (String)"00DD");
        Assert.assertEquals((String)kdfParams.getSuppPrivInfo(), (String)"00EE");
    }

    @Test
    public void DiffieHellmanWithLegacyKDFWithDefaults() throws Exception {
        DigestMethod dm = new DigestMethod();
        dm.setAlgorithm("http://www.w3.org/2001/04/xmlenc#sha512");
        dm.initialize();
        KANonce nonce = new KANonce();
        nonce.setValue("ABCD");
        nonce.initialize();
        this.credDiffieHellmanLegacyKDF.getParameters().add((Object)dm);
        this.credDiffieHellmanLegacyKDF.getParameters().add((Object)nonce);
        KeyInfoGenerator generator = this.factory.newInstance();
        KeyInfo keyInfo = generator.generate((Credential)this.credDiffieHellmanLegacyKDF);
        Assert.assertNotNull((Object)keyInfo);
        Assert.assertNotNull((Object)keyInfo.getOrderedChildren());
        Assert.assertEquals((int)keyInfo.getOrderedChildren().size(), (int)1);
        Assert.assertEquals((int)keyInfo.getAgreementMethods().size(), (int)1);
        AgreementMethod agreementMethod = (AgreementMethod)keyInfo.getAgreementMethods().get(0);
        Assert.assertEquals((String)agreementMethod.getAlgorithm(), (String)this.credDiffieHellmanLegacyKDF.getAlgorithm());
        Assert.assertEquals((int)agreementMethod.getOrderedChildren().size(), (int)4);
        Assert.assertNotNull((Object)agreementMethod.getOriginatorKeyInfo());
        OriginatorKeyInfo originatorKeyInfo = agreementMethod.getOriginatorKeyInfo();
        Assert.assertEquals((int)originatorKeyInfo.getOrderedChildren().size(), (int)2);
        Assert.assertEquals((int)originatorKeyInfo.getDEREncodedKeyValues().size(), (int)1);
        Assert.assertEquals((Object)KeyInfoSupport.getKey((DEREncodedKeyValue)((DEREncodedKeyValue)originatorKeyInfo.getDEREncodedKeyValues().get(0))), (Object)this.keyPairOriginatorDiffieHellman.getPublic());
        Assert.assertEquals((int)originatorKeyInfo.getKeyValues().size(), (int)1);
        Assert.assertEquals((Object)KeyInfoSupport.getKey((KeyValue)((KeyValue)originatorKeyInfo.getKeyValues().get(0))), (Object)this.keyPairOriginatorDiffieHellman.getPublic());
        Assert.assertNotNull((Object)agreementMethod.getRecipientKeyInfo());
        RecipientKeyInfo recipientKeyInfo = agreementMethod.getRecipientKeyInfo();
        Assert.assertEquals((int)recipientKeyInfo.getOrderedChildren().size(), (int)2);
        Assert.assertEquals((int)recipientKeyInfo.getDEREncodedKeyValues().size(), (int)1);
        Assert.assertEquals((Object)KeyInfoSupport.getKey((DEREncodedKeyValue)((DEREncodedKeyValue)recipientKeyInfo.getDEREncodedKeyValues().get(0))), (Object)this.keyPairRecipientDiffieHellman.getPublic());
        Assert.assertEquals((int)recipientKeyInfo.getKeyValues().size(), (int)1);
        Assert.assertEquals((Object)KeyInfoSupport.getKey((KeyValue)((KeyValue)recipientKeyInfo.getKeyValues().get(0))), (Object)this.keyPairRecipientDiffieHellman.getPublic());
        Assert.assertNotNull((Object)agreementMethod.getKANonce());
        Assert.assertEquals((String)agreementMethod.getKANonce().getValue(), (String)"ABCD");
        Assert.assertEquals((int)agreementMethod.getUnknownXMLObjects(org.opensaml.xmlsec.signature.DigestMethod.DEFAULT_ELEMENT_NAME).size(), (int)1);
        org.opensaml.xmlsec.signature.DigestMethod xmlDigest = (org.opensaml.xmlsec.signature.DigestMethod)agreementMethod.getUnknownXMLObjects(org.opensaml.xmlsec.signature.DigestMethod.DEFAULT_ELEMENT_NAME).get(0);
        Assert.assertEquals((String)xmlDigest.getAlgorithm(), (String)"http://www.w3.org/2001/04/xmlenc#sha512");
    }

    @Test
    public void noEmitKeyinfos() throws Exception {
        this.factory.setEmitOriginatorKeyInfo(false);
        this.factory.setEmitRecipientKeyInfo(false);
        ConcatKDF kdf = new ConcatKDF();
        kdf.setDigestMethod("http://www.w3.org/2001/04/xmlenc#sha512");
        kdf.setAlgorithmID("AA");
        kdf.setPartyUInfo("BB");
        kdf.setPartyVInfo("CC");
        kdf.setSuppPubInfo("DD");
        kdf.setSuppPrivInfo("EE");
        kdf.initialize();
        this.credECDH.getParameters().add((Object)kdf);
        KeyInfoGenerator generator = this.factory.newInstance();
        KeyInfo keyInfo = generator.generate((Credential)this.credECDH);
        Assert.assertNotNull((Object)keyInfo);
        Assert.assertNotNull((Object)keyInfo.getOrderedChildren());
        Assert.assertEquals((int)keyInfo.getOrderedChildren().size(), (int)1);
        Assert.assertEquals((int)keyInfo.getAgreementMethods().size(), (int)1);
        AgreementMethod agreementMethod = (AgreementMethod)keyInfo.getAgreementMethods().get(0);
        Assert.assertEquals((int)agreementMethod.getOrderedChildren().size(), (int)1);
        Assert.assertEquals((int)agreementMethod.getUnknownXMLObjects(KeyDerivationMethod.DEFAULT_ELEMENT_NAME).size(), (int)1);
        Assert.assertNull((Object)agreementMethod.getOriginatorKeyInfo());
        Assert.assertNull((Object)agreementMethod.getRecipientKeyInfo());
    }

    @Test
    public void noKeyInfoManagers() throws Exception {
        this.factory.setOriginatorKeyInfoGeneratorManager(null);
        this.factory.setRecipientKeyInfoGeneratorManager(null);
        ConcatKDF kdf = new ConcatKDF();
        kdf.setDigestMethod("http://www.w3.org/2001/04/xmlenc#sha512");
        kdf.setAlgorithmID("AA");
        kdf.setPartyUInfo("BB");
        kdf.setPartyVInfo("CC");
        kdf.setSuppPubInfo("DD");
        kdf.setSuppPrivInfo("EE");
        kdf.initialize();
        this.credECDH.getParameters().add((Object)kdf);
        KeyInfoGenerator generator = this.factory.newInstance();
        KeyInfo keyInfo = generator.generate((Credential)this.credECDH);
        Assert.assertNotNull((Object)keyInfo);
        Assert.assertNotNull((Object)keyInfo.getOrderedChildren());
        Assert.assertEquals((int)keyInfo.getOrderedChildren().size(), (int)1);
        Assert.assertEquals((int)keyInfo.getAgreementMethods().size(), (int)1);
        AgreementMethod agreementMethod = (AgreementMethod)keyInfo.getAgreementMethods().get(0);
        Assert.assertEquals((int)agreementMethod.getOrderedChildren().size(), (int)1);
        Assert.assertEquals((int)agreementMethod.getUnknownXMLObjects(KeyDerivationMethod.DEFAULT_ELEMENT_NAME).size(), (int)1);
        Assert.assertNull((Object)agreementMethod.getOriginatorKeyInfo());
        Assert.assertNull((Object)agreementMethod.getRecipientKeyInfo());
    }
}

