/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.xmlsec.keyinfo.impl;

import java.security.interfaces.RSAPublicKey;
import java.util.ArrayList;
import java.util.Iterator;
import net.shibboleth.utilities.java.support.resolver.CriteriaSet;
import net.shibboleth.utilities.java.support.resolver.Criterion;
import net.shibboleth.utilities.java.support.resolver.ResolverException;
import org.opensaml.core.testing.XMLObjectBaseTestCase;
import org.opensaml.security.credential.BasicCredential;
import org.opensaml.security.credential.Credential;
import org.opensaml.security.crypto.KeySupport;
import org.opensaml.xmlsec.keyinfo.KeyInfoCredentialResolver;
import org.opensaml.xmlsec.keyinfo.KeyInfoCriterion;
import org.opensaml.xmlsec.keyinfo.impl.BasicProviderKeyInfoCredentialResolver;
import org.opensaml.xmlsec.keyinfo.impl.provider.RSAKeyValueProvider;
import org.opensaml.xmlsec.signature.KeyInfo;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public class RSAKeyValueTest
extends XMLObjectBaseTestCase {
    private KeyInfoCredentialResolver resolver;
    private String keyInfoFile;
    private RSAPublicKey pubKey;
    private final String rsaBase64 = "MIIBIjANBgkqhkiG9w0BAQEFAAOCAQ8AMIIBCgKCAQEAw/WnsbA8frhQ+8EoPgMrQjpINjt20U/MvsvmoAgQnAgEF4OYt9Vj9/2YvMO4NvX1fNDFzoYRyOMrypF7skAPcITUhdcPSEpI4nsf5yFZLziK/tQ26RsccE7WhpGB8eHu9tfseelgyioorvmt+JCoP15c5rYUuIfVC+eEsYolw344q6N61OACHETuySL0a1+GFu3WoISXte1pQIst7HKvBbHH41HEWAxT6e0hlD5PyKL4lBJadGHXg8Zz4r2jV2n6+Ox7raEWmtVCGFxsAoCRalu6nvs2++5Nnb4C1SE640esfYhfeMd5JYfsTNMaQ8sZLpsWdglAGpa/Q87K19LIwwIDAQAB";

    @BeforeMethod
    protected void setUp() throws Exception {
        ArrayList<RSAKeyValueProvider> providers = new ArrayList<RSAKeyValueProvider>();
        providers.add(new RSAKeyValueProvider());
        this.resolver = new BasicProviderKeyInfoCredentialResolver(providers);
        this.keyInfoFile = "/org/opensaml/xmlsec/keyinfo/impl/RSAKeyValue.xml";
        this.pubKey = KeySupport.buildJavaRSAPublicKey((String)"MIIBIjANBgkqhkiG9w0BAQEFAAOCAQ8AMIIBCgKCAQEAw/WnsbA8frhQ+8EoPgMrQjpINjt20U/MvsvmoAgQnAgEF4OYt9Vj9/2YvMO4NvX1fNDFzoYRyOMrypF7skAPcITUhdcPSEpI4nsf5yFZLziK/tQ26RsccE7WhpGB8eHu9tfseelgyioorvmt+JCoP15c5rYUuIfVC+eEsYolw344q6N61OACHETuySL0a1+GFu3WoISXte1pQIst7HKvBbHH41HEWAxT6e0hlD5PyKL4lBJadGHXg8Zz4r2jV2n6+Ox7raEWmtVCGFxsAoCRalu6nvs2++5Nnb4C1SE640esfYhfeMd5JYfsTNMaQ8sZLpsWdglAGpa/Q87K19LIwwIDAQAB");
    }

    @Test
    public void testCredResolution() throws ResolverException {
        KeyInfo keyInfo = (KeyInfo)this.unmarshallElement(this.keyInfoFile);
        CriteriaSet criteriaSet = new CriteriaSet(new Criterion[]{new KeyInfoCriterion(keyInfo)});
        Iterator iter = this.resolver.resolve((Object)criteriaSet).iterator();
        Assert.assertTrue((boolean)iter.hasNext(), (String)"No credentials were found");
        Credential credential = (Credential)iter.next();
        Assert.assertNotNull((Object)credential, (String)"Credential was null");
        Assert.assertFalse((boolean)iter.hasNext(), (String)"Too many credentials returned");
        Assert.assertTrue((boolean)(credential instanceof BasicCredential), (String)"Credential is not of the expected type");
        Assert.assertNotNull((Object)credential.getPublicKey(), (String)"Public key was null");
        Assert.assertEquals((Object)credential.getPublicKey(), (Object)this.pubKey, (String)"Expected public key value not found");
        Assert.assertEquals((int)credential.getKeyNames().size(), (int)2, (String)"Wrong number of key names");
        Assert.assertTrue((boolean)credential.getKeyNames().contains("Foo"), (String)"Expected key name value not found");
        Assert.assertTrue((boolean)credential.getKeyNames().contains("Bar"), (String)"Expected key name value not found");
    }
}

