/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.xmlsec.keyinfo.impl;

import java.security.cert.X509Certificate;
import java.security.interfaces.RSAPublicKey;
import java.util.ArrayList;
import java.util.Iterator;
import net.shibboleth.utilities.java.support.resolver.CriteriaSet;
import net.shibboleth.utilities.java.support.resolver.Criterion;
import net.shibboleth.utilities.java.support.resolver.ResolverException;
import org.opensaml.core.testing.XMLObjectBaseTestCase;
import org.opensaml.security.credential.Credential;
import org.opensaml.security.crypto.KeySupport;
import org.opensaml.security.x509.X509Credential;
import org.opensaml.security.x509.X509Support;
import org.opensaml.xmlsec.keyinfo.KeyInfoCredentialResolver;
import org.opensaml.xmlsec.keyinfo.KeyInfoCriterion;
import org.opensaml.xmlsec.keyinfo.impl.BasicProviderKeyInfoCredentialResolver;
import org.opensaml.xmlsec.keyinfo.impl.provider.InlineX509DataProvider;
import org.opensaml.xmlsec.signature.KeyInfo;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public class SingleCertX509DataTest
extends XMLObjectBaseTestCase {
    private KeyInfoCredentialResolver resolver;
    private RSAPublicKey pubKey;
    private final String rsaBase64 = "MIIBIjANBgkqhkiG9w0BAQEFAAOCAQ8AMIIBCgKCAQEAw/WnsbA8frhQ+8EoPgMrQjpINjt20U/MvsvmoAgQnAgEF4OYt9Vj9/2YvMO4NvX1fNDFzoYRyOMrypF7skAPcITUhdcPSEpI4nsf5yFZLziK/tQ26RsccE7WhpGB8eHu9tfseelgyioorvmt+JCoP15c5rYUuIfVC+eEsYolw344q6N61OACHETuySL0a1+GFu3WoISXte1pQIst7HKvBbHH41HEWAxT6e0hlD5PyKL4lBJadGHXg8Zz4r2jV2n6+Ox7raEWmtVCGFxsAoCRalu6nvs2++5Nnb4C1SE640esfYhfeMd5JYfsTNMaQ8sZLpsWdglAGpa/Q87K19LIwwIDAQAB";
    private X509Certificate entityCert;
    private String entityCertBase64 = "MIIDizCCAnOgAwIBAgIBATANBgkqhkiG9w0BAQUFADAuMRIwEAYDVQQKEwlJbnRlcm5ldDIxGDAWBgNVBAMTD2Zvby5leGFtcGxlLm9yZzAeFw0wNzA0MDkwMzUxMTdaFw0xNzA0MDYwMzUxMTdaMC4xEjAQBgNVBAoTCUludGVybmV0MjEYMBYGA1UEAxMPZm9vLmV4YW1wbGUub3JnMIIBIjANBgkqhkiG9w0BAQEFAAOCAQ8AMIIBCgKCAQEAw/WnsbA8frhQ+8EoPgMrQjpINjt20U/MvsvmoAgQnAgEF4OYt9Vj9/2YvMO4NvX1fNDFzoYRyOMrypF7skAPcITUhdcPSEpI4nsf5yFZLziK/tQ26RsccE7WhpGB8eHu9tfseelgyioorvmt+JCoP15c5rYUuIfVC+eEsYolw344q6N61OACHETuySL0a1+GFu3WoISXte1pQIst7HKvBbHH41HEWAxT6e0hlD5PyKL4lBJadGHXg8Zz4r2jV2n6+Ox7raEWmtVCGFxsAoCRalu6nvs2++5Nnb4C1SE640esfYhfeMd5JYfsTNMaQ8sZLpsWdglAGpa/Q87K19LIwwIDAQABo4GzMIGwMAkGA1UdEwQCMAAwLAYJYIZIAYb4QgENBB8WHU9wZW5TU0wgR2VuZXJhdGVkIENlcnRpZmljYXRlMB0GA1UdDgQWBBQOuBH/fniYGRwnTeCejBF2Hg6W5jBWBgNVHSMETzBNgBQOuBH/fniYGRwnTeCejBF2Hg6W5qEypDAwLjESMBAGA1UEChMJSW50ZXJuZXQyMRgwFgYDVQQDEw9mb28uZXhhbXBsZS5vcmeCAQEwDQYJKoZIhvcNAQEFBQADggEBALJ7VxOwQDBpYEO3fAdVEL/mWA2xPTw0fuLkmyecutqB7qOWdSxvjh8wQAGmpg8APV5wxIJrtQADqLvsgY8/Zrq/aMZLfi6YFoNaKaDjvNlp96iarOLNU5fHI/HNh0W444EbiYzg2R/TBixwGYxSTmWArUIu4ILi+9ek49F5oKwkOKrPGLQmJmWKNgxvpyLJFlfnnJSEVLmazAGuTSmbQguYF+AS4pRESlwMuViS9eX27VVi7Tx7SCxOZnoXUI0fPCuYE66jNtrcfSSWRkFE+DOWrtpJVZqXa9Z1LPYjMZcfyC/jSgGMSSpl/7wCiU8ElDQvWOVsU8EtSM7UjgSWu+g=";

    @BeforeMethod
    protected void setUp() throws Exception {
        ArrayList<InlineX509DataProvider> providers = new ArrayList<InlineX509DataProvider>();
        providers.add(new InlineX509DataProvider());
        this.resolver = new BasicProviderKeyInfoCredentialResolver(providers);
        this.pubKey = KeySupport.buildJavaRSAPublicKey((String)"MIIBIjANBgkqhkiG9w0BAQEFAAOCAQ8AMIIBCgKCAQEAw/WnsbA8frhQ+8EoPgMrQjpINjt20U/MvsvmoAgQnAgEF4OYt9Vj9/2YvMO4NvX1fNDFzoYRyOMrypF7skAPcITUhdcPSEpI4nsf5yFZLziK/tQ26RsccE7WhpGB8eHu9tfseelgyioorvmt+JCoP15c5rYUuIfVC+eEsYolw344q6N61OACHETuySL0a1+GFu3WoISXte1pQIst7HKvBbHH41HEWAxT6e0hlD5PyKL4lBJadGHXg8Zz4r2jV2n6+Ox7raEWmtVCGFxsAoCRalu6nvs2++5Nnb4C1SE640esfYhfeMd5JYfsTNMaQ8sZLpsWdglAGpa/Q87K19LIwwIDAQAB");
        this.entityCert = X509Support.decodeCertificate((String)this.entityCertBase64);
    }

    @Test
    public void testCredResolution() throws ResolverException {
        KeyInfo keyInfo = (KeyInfo)this.unmarshallElement("/org/opensaml/xmlsec/keyinfo/impl/SingleX509Certificate.xml");
        CriteriaSet criteriaSet = new CriteriaSet(new Criterion[]{new KeyInfoCriterion(keyInfo)});
        Iterator iter = this.resolver.resolve((Object)criteriaSet).iterator();
        Assert.assertTrue((boolean)iter.hasNext(), (String)"No credentials were found");
        Credential credential = (Credential)iter.next();
        Assert.assertNotNull((Object)credential, (String)"Credential was null");
        Assert.assertFalse((boolean)iter.hasNext(), (String)"Too many credentials returned");
        Assert.assertTrue((boolean)(credential instanceof X509Credential), (String)"Credential is not of the expected type");
        X509Credential x509Credential = (X509Credential)credential;
        Assert.assertNotNull((Object)x509Credential.getPublicKey(), (String)"Public key was null");
        Assert.assertEquals((Object)x509Credential.getPublicKey(), (Object)this.pubKey, (String)"Expected public key value not found");
        Assert.assertNotNull((Object)x509Credential.getEntityCertificate(), (String)"Entity certificate was null");
        Assert.assertEquals((Object)x509Credential.getEntityCertificate(), (Object)this.entityCert, (String)"Expected X509Certificate value not found");
    }
}

