/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.xmlsec.signature.impl;

import org.opensaml.core.testing.XMLObjectProviderBaseTestCase;
import org.opensaml.core.xml.XMLObject;
import org.opensaml.core.xml.mock.SimpleXMLObject;
import org.opensaml.xmlsec.signature.SPKIData;
import org.opensaml.xmlsec.signature.SPKISexp;
import org.testng.Assert;
import org.testng.annotations.Test;

public class SPKIDataTest
extends XMLObjectProviderBaseTestCase {
    public SPKIDataTest() {
        this.singleElementFile = "/org/opensaml/xmlsec/signature/impl/SPKIData.xml";
        this.childElementsFile = "/org/opensaml/xmlsec/signature/impl/SPKIDataChildElements.xml";
    }

    @Test
    public void testSingleElementUnmarshall() {
        SPKIData spkiData = (SPKIData)this.unmarshallElement(this.singleElementFile);
        Assert.assertNotNull((Object)spkiData, (String)"SPKIData");
        Assert.assertEquals((int)spkiData.getXMLObjects().size(), (int)0, (String)"Total # of XMLObject child elements");
    }

    @Test
    public void testChildElementsUnmarshall() {
        SPKIData spkiData = (SPKIData)this.unmarshallElement(this.childElementsFile);
        Assert.assertNotNull((Object)spkiData, (String)"SPKIData");
        Assert.assertEquals((int)spkiData.getXMLObjects().size(), (int)4, (String)"Total # of XMLObject child elements");
        Assert.assertEquals((int)spkiData.getSPKISexps().size(), (int)2, (String)"# of SPKISexp child elements");
        Assert.assertEquals((int)spkiData.getXMLObjects(SimpleXMLObject.ELEMENT_NAME).size(), (int)2, (String)"# of SimpleElement child elements");
    }

    @Test
    public void testSingleElementMarshall() {
        SPKIData spkiData = (SPKIData)this.buildXMLObject(SPKIData.DEFAULT_ELEMENT_NAME);
        this.assertXMLEquals(this.expectedDOM, (XMLObject)spkiData);
    }

    @Test
    public void testChildElementsMarshall() {
        SPKIData spkiData = (SPKIData)this.buildXMLObject(SPKIData.DEFAULT_ELEMENT_NAME);
        spkiData.getXMLObjects().add(this.buildXMLObject(SPKISexp.DEFAULT_ELEMENT_NAME));
        spkiData.getXMLObjects().add(this.buildXMLObject(SimpleXMLObject.ELEMENT_NAME));
        spkiData.getXMLObjects().add(this.buildXMLObject(SPKISexp.DEFAULT_ELEMENT_NAME));
        spkiData.getXMLObjects().add(this.buildXMLObject(SimpleXMLObject.ELEMENT_NAME));
        this.assertXMLEquals(this.expectedChildElementsDOM, (XMLObject)spkiData);
    }
}

