/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.xmlsec.signature.impl;

import org.opensaml.core.testing.XMLObjectProviderBaseTestCase;
import org.opensaml.core.xml.XMLObject;
import org.opensaml.core.xml.mock.SimpleXMLObject;
import org.opensaml.xmlsec.signature.Transform;
import org.opensaml.xmlsec.signature.XPath;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public class TransformTest
extends XMLObjectProviderBaseTestCase {
    private String expectedAlgorithm;
    private int expectedTotalChildren;
    private int expectedXPathChildren;

    public TransformTest() {
        this.singleElementFile = "/org/opensaml/xmlsec/signature/impl/Transform.xml";
        this.childElementsFile = "/org/opensaml/xmlsec/signature/impl/TransformChildElements.xml";
    }

    @BeforeMethod
    protected void setUp() throws Exception {
        this.expectedAlgorithm = "urn:string:foo";
        this.expectedTotalChildren = 5;
        this.expectedXPathChildren = 2;
    }

    @Test
    public void testSingleElementUnmarshall() {
        Transform transform = (Transform)this.unmarshallElement(this.singleElementFile);
        Assert.assertNotNull((Object)transform, (String)"Transform");
        Assert.assertEquals((String)transform.getAlgorithm(), (String)this.expectedAlgorithm, (String)"Algorithm attribute");
        Assert.assertEquals((int)transform.getAllChildren().size(), (int)0, (String)"Total children");
        Assert.assertEquals((int)transform.getXPaths().size(), (int)0, (String)"XPath children");
    }

    @Test
    public void testChildElementsUnmarshall() {
        Transform transform = (Transform)this.unmarshallElement(this.childElementsFile);
        Assert.assertNotNull((Object)transform, (String)"Transform");
        Assert.assertEquals((String)transform.getAlgorithm(), (String)this.expectedAlgorithm, (String)"Algorithm attribute");
        Assert.assertEquals((int)transform.getAllChildren().size(), (int)this.expectedTotalChildren, (String)"Total children");
        Assert.assertEquals((int)transform.getXPaths().size(), (int)this.expectedXPathChildren, (String)"XPath children");
    }

    @Test
    public void testSingleElementMarshall() {
        Transform transform = (Transform)this.buildXMLObject(Transform.DEFAULT_ELEMENT_NAME);
        transform.setAlgorithm(this.expectedAlgorithm);
        this.assertXMLEquals(this.expectedDOM, (XMLObject)transform);
    }

    @Test
    public void testChildElementsMarshall() {
        Transform transform = (Transform)this.buildXMLObject(Transform.DEFAULT_ELEMENT_NAME);
        transform.setAlgorithm(this.expectedAlgorithm);
        transform.getAllChildren().add(this.buildXMLObject(XPath.DEFAULT_ELEMENT_NAME));
        transform.getAllChildren().add(this.buildXMLObject(SimpleXMLObject.ELEMENT_NAME));
        transform.getAllChildren().add(this.buildXMLObject(SimpleXMLObject.ELEMENT_NAME));
        transform.getAllChildren().add(this.buildXMLObject(XPath.DEFAULT_ELEMENT_NAME));
        transform.getAllChildren().add(this.buildXMLObject(SimpleXMLObject.ELEMENT_NAME));
        this.assertXMLEquals(this.expectedChildElementsDOM, (XMLObject)transform);
    }
}

