/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.client.opensearch._types.analysis;

import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;
import org.opensearch.client.json.JsonpDeserializable;
import org.opensearch.client.json.JsonpDeserializer;
import org.opensearch.client.json.JsonpMapper;
import org.opensearch.client.json.ObjectBuilderDeserializer;
import org.opensearch.client.json.ObjectDeserializer;
import org.opensearch.client.opensearch._types.analysis.TokenizerBase;
import org.opensearch.client.opensearch._types.analysis.TokenizerDefinition;
import org.opensearch.client.opensearch._types.analysis.TokenizerDefinitionVariant;
import org.opensearch.client.util.ApiTypeHelper;
import org.opensearch.client.util.ObjectBuilder;

@JsonpDeserializable
public class KeywordTokenizer
extends TokenizerBase
implements TokenizerDefinitionVariant {
    private final int bufferSize;
    public static final JsonpDeserializer<KeywordTokenizer> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, KeywordTokenizer::setupKeywordTokenizerDeserializer);

    private KeywordTokenizer(Builder builder) {
        super(builder);
        this.bufferSize = ApiTypeHelper.requireNonNull(builder.bufferSize, this, "bufferSize");
    }

    public static KeywordTokenizer of(Function<Builder, ObjectBuilder<KeywordTokenizer>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Override
    public TokenizerDefinition.Kind _tokenizerDefinitionKind() {
        return TokenizerDefinition.Kind.Keyword;
    }

    public final int bufferSize() {
        return this.bufferSize;
    }

    @Override
    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.write("type", "keyword");
        super.serializeInternal(generator, mapper);
        generator.writeKey("buffer_size");
        generator.write(this.bufferSize);
    }

    protected static void setupKeywordTokenizerDeserializer(ObjectDeserializer<Builder> op) {
        TokenizerBase.setupTokenizerBaseDeserializer(op);
        op.add(Builder::bufferSize, JsonpDeserializer.integerDeserializer(), "buffer_size");
        op.ignore("type");
    }

    public static class Builder
    extends TokenizerBase.AbstractBuilder<Builder>
    implements ObjectBuilder<KeywordTokenizer> {
        private Integer bufferSize;

        public final Builder bufferSize(int value) {
            this.bufferSize = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public KeywordTokenizer build() {
            this._checkSingleUse();
            return new KeywordTokenizer(this);
        }
    }
}

