/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.client.opensearch._types.analysis;

import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;
import org.opensearch.client.json.JsonpDeserializable;
import org.opensearch.client.json.JsonpDeserializer;
import org.opensearch.client.json.JsonpMapper;
import org.opensearch.client.json.ObjectBuilderDeserializer;
import org.opensearch.client.json.ObjectDeserializer;
import org.opensearch.client.opensearch._types.analysis.TokenFilterBase;
import org.opensearch.client.opensearch._types.analysis.TokenFilterDefinition;
import org.opensearch.client.opensearch._types.analysis.TokenFilterDefinitionVariant;
import org.opensearch.client.util.ApiTypeHelper;
import org.opensearch.client.util.ObjectBuilder;

@JsonpDeserializable
public class TruncateTokenFilter
extends TokenFilterBase
implements TokenFilterDefinitionVariant {
    private final int length;
    public static final JsonpDeserializer<TruncateTokenFilter> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, TruncateTokenFilter::setupTruncateTokenFilterDeserializer);

    private TruncateTokenFilter(Builder builder) {
        super(builder);
        this.length = ApiTypeHelper.requireNonNull(builder.length, this, "length");
    }

    public static TruncateTokenFilter of(Function<Builder, ObjectBuilder<TruncateTokenFilter>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Override
    public TokenFilterDefinition.Kind _tokenFilterDefinitionKind() {
        return TokenFilterDefinition.Kind.Truncate;
    }

    public final int length() {
        return this.length;
    }

    @Override
    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.write("type", "truncate");
        super.serializeInternal(generator, mapper);
        generator.writeKey("length");
        generator.write(this.length);
    }

    protected static void setupTruncateTokenFilterDeserializer(ObjectDeserializer<Builder> op) {
        TruncateTokenFilter.setupTokenFilterBaseDeserializer(op);
        op.add(Builder::length, JsonpDeserializer.integerDeserializer(), "length");
        op.ignore("type");
    }

    public static class Builder
    extends TokenFilterBase.AbstractBuilder<Builder>
    implements ObjectBuilder<TruncateTokenFilter> {
        private Integer length;

        public final Builder length(int value) {
            this.length = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public TruncateTokenFilter build() {
            this._checkSingleUse();
            return new TruncateTokenFilter(this);
        }
    }
}

