/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.client.http;

import org.apache.hc.client5.http.classic.methods.HttpUriRequestBase;
import org.apache.hc.core5.http.HttpEntity;
import org.apache.hc.core5.http.HttpHost;
import org.apache.hc.core5.http.HttpRequest;
import org.apache.hc.core5.http.nio.AsyncEntityProducer;
import org.apache.hc.core5.http.nio.support.BasicRequestProducer;
import org.apache.hc.core5.net.NamedEndpoint;
import org.apache.hc.core5.net.URIAuthority;
import org.apache.hc.core5.util.Args;
import org.opensearch.client.nio.HttpEntityAsyncEntityProducer;

public class HttpUriRequestProducer
extends BasicRequestProducer {
    private final HttpUriRequestBase request;

    HttpUriRequestProducer(HttpUriRequestBase request, AsyncEntityProducer entityProducer) {
        super((HttpRequest)request, entityProducer);
        this.request = request;
    }

    public HttpUriRequestBase getRequest() {
        return this.request;
    }

    public static HttpUriRequestProducer create(HttpUriRequestBase request, HttpHost host) {
        Args.notNull((Object)request, (String)"Request");
        Args.notNull((Object)host, (String)"HttpHost");
        request.setAuthority(new URIAuthority((NamedEndpoint)host));
        request.setScheme(host.getSchemeName());
        HttpEntity entity = request.getEntity();
        HttpEntityAsyncEntityProducer entityProducer = null;
        if (entity != null) {
            entityProducer = new HttpEntityAsyncEntityProducer(entity);
        }
        return new HttpUriRequestProducer(request, entityProducer);
    }
}

