/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.asm.util;

import java.util.HashSet;
import org.objectweb.asm.ModuleVisitor;
import org.objectweb.asm.util.CheckClassAdapter;
import org.objectweb.asm.util.CheckMethodAdapter;

public final class CheckModuleAdapter
extends ModuleVisitor {
    private boolean end;
    private final boolean isOpen;
    private final HashSet requireNames = new HashSet();
    private final HashSet exportNames = new HashSet();
    private final HashSet openNames = new HashSet();
    private final HashSet useNames = new HashSet();
    private final HashSet provideNames = new HashSet();

    public CheckModuleAdapter(ModuleVisitor moduleVisitor, boolean bl) {
        super(393216, moduleVisitor);
        this.isOpen = bl;
    }

    public void visitRequire(String string, int n, String string2) {
        this.checkEnd();
        if (string == null) {
            throw new IllegalArgumentException("require cannot be null");
        }
        CheckModuleAdapter.checkDeclared("requires", this.requireNames, string);
        CheckClassAdapter.checkAccess(n, 36960);
        super.visitRequire(string, n, string2);
    }

    public void visitExport(String string, int n, String ... stringArray) {
        this.checkEnd();
        if (string == null) {
            throw new IllegalArgumentException("packaze cannot be null");
        }
        CheckMethodAdapter.checkInternalName(string, "package name");
        CheckModuleAdapter.checkDeclared("exports", this.exportNames, string);
        CheckClassAdapter.checkAccess(n, 36864);
        if (stringArray != null) {
            for (int i = 0; i < stringArray.length; ++i) {
                if (stringArray[i] != null) continue;
                throw new IllegalArgumentException("module at index " + i + " cannot be null");
            }
        }
        super.visitExport(string, n, stringArray);
    }

    public void visitOpen(String string, int n, String ... stringArray) {
        this.checkEnd();
        if (this.isOpen) {
            throw new IllegalArgumentException("an open module can not use open directive");
        }
        if (string == null) {
            throw new IllegalArgumentException("packaze cannot be null");
        }
        CheckMethodAdapter.checkInternalName(string, "package name");
        CheckModuleAdapter.checkDeclared("opens", this.openNames, string);
        CheckClassAdapter.checkAccess(n, 36864);
        if (stringArray != null) {
            for (int i = 0; i < stringArray.length; ++i) {
                if (stringArray[i] != null) continue;
                throw new IllegalArgumentException("module at index " + i + " cannot be null");
            }
        }
        super.visitOpen(string, n, stringArray);
    }

    public void visitUse(String string) {
        this.checkEnd();
        CheckMethodAdapter.checkInternalName(string, "service");
        CheckModuleAdapter.checkDeclared("uses", this.useNames, string);
        super.visitUse(string);
    }

    public void visitProvide(String string, String ... stringArray) {
        this.checkEnd();
        CheckMethodAdapter.checkInternalName(string, "service");
        CheckModuleAdapter.checkDeclared("provides", this.provideNames, string);
        if (stringArray == null || stringArray.length == 0) {
            throw new IllegalArgumentException("providers cannot be null or empty");
        }
        for (int i = 0; i < stringArray.length; ++i) {
            CheckMethodAdapter.checkInternalName(stringArray[i], "provider");
        }
        super.visitProvide(string, stringArray);
    }

    public void visitEnd() {
        this.checkEnd();
        this.end = true;
        super.visitEnd();
    }

    private void checkEnd() {
        if (this.end) {
            throw new IllegalStateException("Cannot call a visit method after visitEnd has been called");
        }
    }

    private static void checkDeclared(String string, HashSet hashSet, String string2) {
        if (!hashSet.add(string2)) {
            throw new IllegalArgumentException(string + " " + string2 + " already declared");
        }
    }
}

