/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.dependencycheck.analyzer;

import com.github.packageurl.MalformedPackageURLException;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.concurrent.ThreadSafe;
import org.apache.commons.lang3.StringUtils;
import org.owasp.dependencycheck.Engine;
import org.owasp.dependencycheck.analyzer.AbstractFileTypeAnalyzer;
import org.owasp.dependencycheck.analyzer.AnalysisPhase;
import org.owasp.dependencycheck.analyzer.exception.AnalysisException;
import org.owasp.dependencycheck.dependency.Confidence;
import org.owasp.dependencycheck.dependency.Dependency;
import org.owasp.dependencycheck.dependency.EvidenceType;
import org.owasp.dependencycheck.dependency.naming.GenericIdentifier;
import org.owasp.dependencycheck.dependency.naming.PurlIdentifier;
import org.owasp.dependencycheck.exception.InitializationException;
import org.owasp.dependencycheck.processing.GrokAssemblyProcessor;
import org.owasp.dependencycheck.utils.DependencyVersion;
import org.owasp.dependencycheck.utils.DependencyVersionUtil;
import org.owasp.dependencycheck.utils.ExtractionException;
import org.owasp.dependencycheck.utils.ExtractionUtil;
import org.owasp.dependencycheck.utils.FileFilterBuilder;
import org.owasp.dependencycheck.utils.FileUtils;
import org.owasp.dependencycheck.utils.processing.ProcessReader;
import org.owasp.dependencycheck.utils.processing.Processor;
import org.owasp.dependencycheck.xml.assembly.AssemblyData;
import org.owasp.dependencycheck.xml.assembly.GrokParseException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
public class AssemblyAnalyzer
extends AbstractFileTypeAnalyzer {
    private static final Logger LOGGER = LoggerFactory.getLogger(AssemblyAnalyzer.class);
    private static final String ANALYZER_NAME = "Assembly Analyzer";
    private static final AnalysisPhase ANALYSIS_PHASE = AnalysisPhase.INFORMATION_COLLECTION;
    public static final String DEPENDENCY_ECOSYSTEM = "dotnet";
    private static final String[] SUPPORTED_EXTENSIONS = new String[]{"dll", "exe"};
    private static final FileFilter FILTER = FileFilterBuilder.newInstance().addExtensions(SUPPORTED_EXTENSIONS).build();
    private File grokAssembly = null;
    private List<String> baseArgumentList = null;

    protected List<String> buildArgumentList() {
        ArrayList<String> args = new ArrayList<String>();
        if (!StringUtils.isBlank((CharSequence)this.getSettings().getString("analyzer.assembly.dotnet.path"))) {
            args.add(this.getSettings().getString("analyzer.assembly.dotnet.path"));
        } else if (this.isDotnetPath()) {
            args.add(DEPENDENCY_ECOSYSTEM);
        } else {
            return null;
        }
        args.add(this.grokAssembly.getPath());
        return args;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void analyzeDependency(Dependency dependency, Engine engine) throws AnalysisException {
        File test = new File(dependency.getActualFilePath());
        if (!test.isFile()) {
            throw new AnalysisException(String.format("%s does not exist and cannot be analyzed by dependency-check", dependency.getActualFilePath()));
        }
        if (this.grokAssembly == null) {
            LOGGER.warn("GrokAssembly didn't get deployed");
            return;
        }
        if (this.baseArgumentList == null) {
            LOGGER.warn("Assembly Analyzer was unable to execute");
            return;
        }
        ArrayList<String> args = new ArrayList<String>(this.baseArgumentList);
        args.add(dependency.getActualFilePath());
        ProcessBuilder pb = new ProcessBuilder(args);
        try {
            AssemblyData data;
            Process proc = pb.start();
            try (GrokAssemblyProcessor processor = new GrokAssemblyProcessor();
                 ProcessReader processReader = new ProcessReader(proc, (Processor)processor);){
                int exitValue;
                processReader.readAll();
                String errorOutput = processReader.getError();
                if (!StringUtils.isBlank((CharSequence)errorOutput)) {
                    LOGGER.warn("Error from GrokAssembly: {}", (Object)errorOutput);
                }
                if ((exitValue = proc.exitValue()) == 3) {
                    LOGGER.debug("{} is not a .NET assembly or executable and as such cannot be analyzed by dependency-check", (Object)dependency.getActualFilePath());
                    return;
                }
                if (exitValue != 0) {
                    LOGGER.debug("Return code {} from GrokAssembly; dependency-check is unable to analyze the library: {}", (Object)exitValue, (Object)dependency.getActualFilePath());
                    return;
                }
                data = processor.getAssemblyData();
            }
            String error = data.getError();
            if (error != null && !error.isEmpty()) {
                throw new AnalysisException(error);
            }
            if (data.getWarning() != null) {
                LOGGER.debug("Grok Assembly - could not get namespace on dependency `{}` - {}", (Object)dependency.getActualFilePath(), (Object)data.getWarning());
            }
            this.updateDependency(data, dependency);
            return;
        }
        catch (GrokParseException saxe) {
            LOGGER.error("----------------------------------------------------");
            LOGGER.error("Failed to read the Assembly Analyzer results.");
            LOGGER.error("----------------------------------------------------");
            throw new AnalysisException("Couldn't parse Assembly Analyzer results (GrokAssembly)", saxe);
        }
        catch (IOException ioe) {
            throw new AnalysisException(ioe);
        }
        catch (InterruptedException ex) {
            Thread.currentThread().interrupt();
            throw new AnalysisException("GrokAssembly process interrupted", ex);
        }
    }

    private void updateDependency(AssemblyData data, Dependency dependency) {
        String originalFilename;
        String internalName;
        DependencyVersion version;
        String description;
        StringBuilder sb = new StringBuilder();
        if (!StringUtils.isBlank((CharSequence)data.getFileDescription())) {
            sb.append(data.getFileDescription());
        }
        if (!StringUtils.isBlank((CharSequence)data.getComments())) {
            if (sb.length() > 0) {
                sb.append("\n\n");
            }
            sb.append(data.getComments());
        }
        if (!StringUtils.isBlank((CharSequence)data.getLegalCopyright())) {
            if (sb.length() > 0) {
                sb.append("\n\n");
            }
            sb.append(data.getLegalCopyright());
        }
        if (!StringUtils.isBlank((CharSequence)data.getLegalTrademarks())) {
            if (sb.length() > 0) {
                sb.append("\n");
            }
            sb.append(data.getLegalTrademarks());
        }
        if ((description = sb.toString()).length() > 0) {
            dependency.setDescription(description);
            AssemblyAnalyzer.addMatchingValues(data.getNamespaces(), description, dependency, EvidenceType.VENDOR);
            AssemblyAnalyzer.addMatchingValues(data.getNamespaces(), description, dependency, EvidenceType.PRODUCT);
        }
        if (!StringUtils.isBlank((CharSequence)data.getProductVersion())) {
            dependency.addEvidence(EvidenceType.VERSION, "grokassembly", "ProductVersion", data.getProductVersion(), Confidence.HIGHEST);
        }
        if (!StringUtils.isBlank((CharSequence)data.getFileVersion())) {
            dependency.addEvidence(EvidenceType.VERSION, "grokassembly", "FileVersion", data.getFileVersion(), Confidence.HIGH);
        }
        if (data.getFileVersion() != null && data.getProductVersion() != null) {
            int pos;
            int max = data.getFileVersion().length() > data.getProductVersion().length() ? data.getProductVersion().length() : data.getFileVersion().length();
            for (pos = 0; pos < max && data.getFileVersion().charAt(pos) == data.getProductVersion().charAt(pos); ++pos) {
            }
            DependencyVersion fileVersion = DependencyVersionUtil.parseVersion(data.getFileVersion(), true);
            DependencyVersion productVersion = DependencyVersionUtil.parseVersion(data.getProductVersion(), true);
            if (pos > 0) {
                DependencyVersion matchingVersion = DependencyVersionUtil.parseVersion(data.getFileVersion().substring(0, pos), true);
                if (fileVersion != null && data.getFileVersion() != null && fileVersion.toString().length() == data.getFileVersion().length() && matchingVersion != null && matchingVersion.getVersionParts().size() > 2) {
                    dependency.addEvidence(EvidenceType.VERSION, "AssemblyAnalyzer", "FilteredVersion", matchingVersion.toString(), Confidence.HIGHEST);
                    dependency.setVersion(matchingVersion.toString());
                }
            }
            if (dependency.getVersion() == null) {
                if (data.getFileVersion() != null && data.getProductVersion() != null && data.getFileVersion().length() >= data.getProductVersion().length()) {
                    if (fileVersion != null && fileVersion.toString().length() == data.getFileVersion().length()) {
                        dependency.setVersion(fileVersion.toString());
                    } else if (productVersion != null && productVersion.toString().length() == data.getProductVersion().length()) {
                        dependency.setVersion(productVersion.toString());
                    }
                } else if (productVersion != null && productVersion.toString().length() == data.getProductVersion().length()) {
                    dependency.setVersion(productVersion.toString());
                } else if (fileVersion != null && fileVersion.toString().length() == data.getFileVersion().length()) {
                    dependency.setVersion(fileVersion.toString());
                }
            }
        }
        if (dependency.getVersion() == null && data.getFileVersion() != null && (version = DependencyVersionUtil.parseVersion(data.getFileVersion(), true)) != null) {
            dependency.setVersion(version.toString());
        }
        if (dependency.getVersion() == null && data.getProductVersion() != null && (version = DependencyVersionUtil.parseVersion(data.getProductVersion(), true)) != null) {
            dependency.setVersion(version.toString());
        }
        if (!StringUtils.isBlank((CharSequence)data.getCompanyName())) {
            dependency.addEvidence(EvidenceType.VENDOR, "grokassembly", "CompanyName", data.getCompanyName(), Confidence.HIGHEST);
            AssemblyAnalyzer.addMatchingValues(data.getNamespaces(), data.getCompanyName(), dependency, EvidenceType.VENDOR);
        }
        if (!StringUtils.isBlank((CharSequence)data.getProductName())) {
            dependency.addEvidence(EvidenceType.PRODUCT, "grokassembly", "ProductName", data.getProductName(), Confidence.HIGHEST);
            AssemblyAnalyzer.addMatchingValues(data.getNamespaces(), data.getProductName(), dependency, EvidenceType.PRODUCT);
        }
        if (!StringUtils.isBlank((CharSequence)data.getFileDescription())) {
            dependency.addEvidence(EvidenceType.PRODUCT, "grokassembly", "FileDescription", data.getFileDescription(), Confidence.HIGH);
            AssemblyAnalyzer.addMatchingValues(data.getNamespaces(), data.getFileDescription(), dependency, EvidenceType.PRODUCT);
        }
        if (!StringUtils.isBlank((CharSequence)(internalName = data.getInternalName()))) {
            dependency.addEvidence(EvidenceType.PRODUCT, "grokassembly", "InternalName", internalName, Confidence.MEDIUM);
            AssemblyAnalyzer.addMatchingValues(data.getNamespaces(), internalName, dependency, EvidenceType.PRODUCT);
            AssemblyAnalyzer.addMatchingValues(data.getNamespaces(), internalName, dependency, EvidenceType.VENDOR);
            if (dependency.getName() == null && StringUtils.containsIgnoreCase((CharSequence)dependency.getActualFile().getName(), (CharSequence)internalName)) {
                String ext = FileUtils.getFileExtension((String)internalName);
                if (ext != null) {
                    dependency.setName(internalName.substring(0, internalName.length() - ext.length() - 1));
                } else {
                    dependency.setName(internalName);
                }
            }
        }
        if (!StringUtils.isBlank((CharSequence)(originalFilename = data.getOriginalFilename()))) {
            dependency.addEvidence(EvidenceType.PRODUCT, "grokassembly", "OriginalFilename", originalFilename, Confidence.MEDIUM);
            AssemblyAnalyzer.addMatchingValues(data.getNamespaces(), originalFilename, dependency, EvidenceType.PRODUCT);
            if (dependency.getName() == null && StringUtils.containsIgnoreCase((CharSequence)dependency.getActualFile().getName(), (CharSequence)originalFilename)) {
                String ext = FileUtils.getFileExtension((String)originalFilename);
                if (ext != null) {
                    dependency.setName(originalFilename.substring(0, originalFilename.length() - ext.length() - 1));
                } else {
                    dependency.setName(originalFilename);
                }
            }
        }
        if (dependency.getName() != null && dependency.getVersion() != null) {
            try {
                dependency.addSoftwareIdentifier(new PurlIdentifier("generic", dependency.getName(), dependency.getVersion(), Confidence.MEDIUM));
            }
            catch (MalformedPackageURLException ex) {
                LOGGER.debug("Unable to create Package URL Identifier for " + dependency.getName(), (Throwable)ex);
                dependency.addSoftwareIdentifier(new GenericIdentifier(String.format("%s@%s", dependency.getName(), dependency.getVersion()), Confidence.MEDIUM));
            }
        }
        dependency.setEcosystem(DEPENDENCY_ECOSYSTEM);
    }

    @Override
    public void prepareFileTypeAnalyzer(Engine engine) throws InitializationException {
        this.grokAssembly = this.extractGrokAssembly();
        this.baseArgumentList = this.buildArgumentList();
        if (this.baseArgumentList == null) {
            this.setEnabled(false);
            LOGGER.error("----------------------------------------------------");
            LOGGER.error(".NET Assembly Analyzer could not be initialized and at least one 'exe' or 'dll' was scanned. The 'dotnet' executable could not be found on the path; either disable the Assembly Analyzer or add the path to dotnet core in the configuration.");
            LOGGER.error("----------------------------------------------------");
            return;
        }
        try {
            ProcessBuilder pb = new ProcessBuilder(this.baseArgumentList);
            Process p = pb.start();
            try (ProcessReader processReader = new ProcessReader(p);){
                processReader.readAll();
                String error = processReader.getError();
                if (p.exitValue() != 1 || !StringUtils.isBlank((CharSequence)error)) {
                    LOGGER.warn("An error occurred with the .NET AssemblyAnalyzer, please see the log for more details.");
                    LOGGER.debug("GrokAssembly.dll is not working properly");
                    this.grokAssembly = null;
                    this.setEnabled(false);
                    throw new InitializationException("Could not execute .NET AssemblyAnalyzer");
                }
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            LOGGER.warn("An error occurred with the .NET AssemblyAnalyzer;\nthis can be ignored unless you are scanning .NET DLLs. Please see the log for more details.");
            LOGGER.debug("Could not execute GrokAssembly {}", (Object)e.getMessage());
            this.setEnabled(false);
            throw new InitializationException("An error occurred with the .NET AssemblyAnalyzer", e);
        }
        catch (IOException e) {
            LOGGER.warn("An error occurred with the .NET AssemblyAnalyzer;\nthis can be ignored unless you are scanning .NET DLLs. Please see the log for more details.");
            LOGGER.debug("Could not execute GrokAssembly {}", (Object)e.getMessage());
            this.setEnabled(false);
            throw new InitializationException("An error occurred with the .NET AssemblyAnalyzer", e);
        }
    }

    private File extractGrokAssembly() throws InitializationException {
        File location;
        try (InputStream in = FileUtils.getResourceAsStream((String)"GrokAssembly.zip");){
            if (in == null) {
                throw new InitializationException("Unable to extract GrokAssembly.dll - file not found");
            }
            location = FileUtils.createTempDirectory((File)this.getSettings().getTempDirectory());
            ExtractionUtil.extractFiles(in, location);
        }
        catch (ExtractionException ex) {
            throw new InitializationException("Unable to extract GrokAssembly.dll", ex);
        }
        catch (IOException ex) {
            throw new InitializationException("Unable to create temp directory for GrokAssembly", ex);
        }
        return new File(location, "GrokAssembly.dll");
    }

    @Override
    public void closeAnalyzer() throws Exception {
        FileUtils.delete((File)this.grokAssembly.getParentFile());
    }

    @Override
    protected FileFilter getFileFilter() {
        return FILTER;
    }

    @Override
    public String getName() {
        return ANALYZER_NAME;
    }

    @Override
    public AnalysisPhase getAnalysisPhase() {
        return ANALYSIS_PHASE;
    }

    @Override
    protected String getAnalyzerEnabledSettingKey() {
        return "analyzer.assembly.enabled";
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean isDotnetPath() {
        String[] args = new String[]{DEPENDENCY_ECOSYSTEM, "--version"};
        ProcessBuilder pb = new ProcessBuilder(args);
        try {
            Process proc = pb.start();
            try (ProcessReader processReader = new ProcessReader(proc);){
                processReader.readAll();
                int exitValue = proc.exitValue();
                if (exitValue == 0) {
                    boolean bl = true;
                    return bl;
                }
                String output = processReader.getOutput();
                if (output.length() <= 0) return false;
                boolean bl = true;
                return bl;
            }
        }
        catch (InterruptedException ex) {
            Thread.currentThread().interrupt();
            LOGGER.debug("Path search failed for dotnet", (Throwable)ex);
            return false;
        }
        catch (IOException ex) {
            LOGGER.debug("Path search failed for dotnet", (Throwable)ex);
        }
        return false;
    }

    protected static void addMatchingValues(List<String> packages, String value, Dependency dep, EvidenceType type) {
        if (value == null || value.isEmpty() || packages == null || packages.isEmpty()) {
            return;
        }
        for (String key : packages) {
            int pos = StringUtils.indexOfIgnoreCase((CharSequence)value, (CharSequence)key);
            if ((pos != 0 || key.length() != value.length() && (key.length() >= value.length() || Character.isLetterOrDigit(value.charAt(key.length())))) && (pos <= 0 || Character.isLetterOrDigit(value.charAt(pos - 1)) || pos + key.length() != value.length() && (key.length() >= value.length() || Character.isLetterOrDigit(value.charAt(pos + key.length()))))) continue;
            dep.addEvidence(type, "dll", "namespace", key, Confidence.HIGHEST);
        }
    }

    File getGrokAssemblyPath() {
        return this.grokAssembly;
    }
}

