/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.dependencycheck.dependency;

import java.io.Serializable;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import org.sonatype.ossindex.service.api.cvss.Cvss3Severity;

public class CvssV3
implements Serializable {
    private static final long serialVersionUID = -315810090425928920L;
    private static final List<String> BASE_METRICS = Arrays.asList("AV", "AC", "PR", "UI", "S", "C", "I", "A");
    private final String attackVector;
    private final String attackComplexity;
    private final String privilegesRequired;
    private final String userInteraction;
    private final String scope;
    private final String confidentialityImpact;
    private final String integrityImpact;
    private final String availabilityImpact;
    private final float baseScore;
    private final String baseSeverity;
    private final Float exploitabilityScore;
    private final Float impactScore;
    private final String version;

    public CvssV3(String attackVector, String attackComplexity, String privilegesRequired, String userInteraction, String scope, String confidentialityImpact, String integrityImpact, String availabilityImpact, float baseScore, String baseSeverity) {
        this(attackVector, attackComplexity, privilegesRequired, userInteraction, scope, confidentialityImpact, integrityImpact, availabilityImpact, baseScore, baseSeverity, null, null, null);
    }

    public CvssV3(String attackVector, String attackComplexity, String privilegesRequired, String userInteraction, String scope, String confidentialityImpact, String integrityImpact, String availabilityImpact, float baseScore, String baseSeverity, Float exploitabilityScore, Float impactScore, String version) {
        this.attackVector = attackVector;
        this.attackComplexity = attackComplexity;
        this.privilegesRequired = privilegesRequired;
        this.userInteraction = userInteraction;
        this.scope = scope;
        this.confidentialityImpact = confidentialityImpact;
        this.integrityImpact = integrityImpact;
        this.availabilityImpact = availabilityImpact;
        this.baseScore = baseScore;
        this.baseSeverity = baseSeverity;
        this.exploitabilityScore = exploitabilityScore;
        this.impactScore = impactScore;
        this.version = version;
    }

    public CvssV3(String vectorString, float baseScore) {
        if (!vectorString.startsWith("CVSS:3")) {
            throw new IllegalArgumentException("Not a valid CVSSv3 vector string: " + vectorString);
        }
        this.version = vectorString.substring(5, vectorString.indexOf(47));
        String[] metricStrings = vectorString.substring(vectorString.indexOf(47) + 1).split("/");
        HashMap<String, String> metrics = new HashMap<String, String>();
        for (int i = 0; i < metricStrings.length; ++i) {
            String[] metricKeyVal = metricStrings[i].split(":");
            if (metricKeyVal.length != 2) {
                throw new IllegalArgumentException(String.format("Not a valid CVSSv3 vector string '%s', invalid metric component '%s'", vectorString, metricStrings[i]));
            }
            metrics.put(metricKeyVal[0], metricKeyVal[1]);
        }
        if (!metrics.keySet().containsAll(BASE_METRICS)) {
            throw new IllegalArgumentException(String.format("Not a valid CVSSv3 vector string '%s'; missing one or more required Base Metrics;", vectorString));
        }
        this.attackVector = (String)metrics.get("AV");
        this.attackComplexity = (String)metrics.get("AC");
        this.privilegesRequired = (String)metrics.get("PR");
        this.userInteraction = (String)metrics.get("UI");
        this.scope = (String)metrics.get("S");
        this.confidentialityImpact = (String)metrics.get("C");
        this.integrityImpact = (String)metrics.get("I");
        this.availabilityImpact = (String)metrics.get("A");
        this.baseScore = baseScore;
        this.baseSeverity = Cvss3Severity.of((Float)Float.valueOf(baseScore)).name();
        this.exploitabilityScore = null;
        this.impactScore = null;
    }

    public String getAttackVector() {
        return this.attackVector;
    }

    public String getAttackComplexity() {
        return this.attackComplexity;
    }

    public String getPrivilegesRequired() {
        return this.privilegesRequired;
    }

    public String getUserInteraction() {
        return this.userInteraction;
    }

    public String getScope() {
        return this.scope;
    }

    public String getConfidentialityImpact() {
        return this.confidentialityImpact;
    }

    public String getIntegrityImpact() {
        return this.integrityImpact;
    }

    public String getAvailabilityImpact() {
        return this.availabilityImpact;
    }

    public float getBaseScore() {
        return this.baseScore;
    }

    public String getBaseSeverity() {
        return this.baseSeverity;
    }

    public String getVersion() {
        return this.version;
    }

    public Float getexploitabilityScore() {
        return this.exploitabilityScore;
    }

    public Float getimpactScore() {
        return this.impactScore;
    }

    public String toString() {
        return String.format("CVSS:%s/AV:%s/AC:%s/PR:%s/UI:%s/S:%s/C:%s/I:%s/A:%s", this.version == null ? "" : this.version, this.attackVector == null ? "" : this.attackVector.substring(0, 1), this.attackComplexity == null ? "" : this.attackComplexity.substring(0, 1), this.privilegesRequired == null ? "" : this.privilegesRequired.substring(0, 1), this.userInteraction == null ? "" : this.userInteraction.substring(0, 1), this.scope == null ? "" : this.scope.substring(0, 1), this.confidentialityImpact == null ? "" : this.confidentialityImpact.substring(0, 1), this.integrityImpact == null ? "" : this.integrityImpact.substring(0, 1), this.availabilityImpact == null ? "" : this.availabilityImpact.substring(0, 1));
    }
}

