/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.dependencycheck.analyzer;

import java.util.Map;
import java.util.Set;
import javax.annotation.concurrent.ThreadSafe;
import org.owasp.dependencycheck.Engine;
import org.owasp.dependencycheck.analyzer.AbstractAnalyzer;
import org.owasp.dependencycheck.analyzer.AnalysisPhase;
import org.owasp.dependencycheck.analyzer.exception.AnalysisException;
import org.owasp.dependencycheck.data.nvdcve.DatabaseException;
import org.owasp.dependencycheck.dependency.Dependency;
import org.owasp.dependencycheck.dependency.Vulnerability;
import org.owasp.dependencycheck.exception.InitializationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
public class KnownExploitedVulnerabilityAnalyzer
extends AbstractAnalyzer {
    private static final Logger LOGGER = LoggerFactory.getLogger(KnownExploitedVulnerabilityAnalyzer.class);
    private Map<String, org.owasp.dependencycheck.data.knownexploited.json.Vulnerability> knownExploited = null;
    private static final String ANALYZER_NAME = "Known Exploited Vulnerability Analyzer";
    private static final AnalysisPhase ANALYSIS_PHASE = AnalysisPhase.POST_FINDING_ANALYSIS;

    @Override
    public String getName() {
        return ANALYZER_NAME;
    }

    @Override
    public AnalysisPhase getAnalysisPhase() {
        return ANALYSIS_PHASE;
    }

    @Override
    protected String getAnalyzerEnabledSettingKey() {
        return "analyzer.knownexploited.enabled";
    }

    @Override
    public void prepareAnalyzer(Engine engine) throws InitializationException {
        try {
            this.knownExploited = engine.getDatabase().getknownExploitedVulnerabilities();
        }
        catch (DatabaseException ex) {
            LOGGER.debug("Unable to load the known exploited vulnerabilities", (Throwable)ex);
            throw new InitializationException("Unable to load the known exploited vulnerabilities", ex);
        }
    }

    @Override
    protected void analyzeDependency(Dependency dependency, Engine engine) throws AnalysisException {
        Set<Vulnerability> vulns = dependency.getVulnerabilities();
        for (Vulnerability v : vulns) {
            org.owasp.dependencycheck.data.knownexploited.json.Vulnerability kev = this.knownExploited.get(v.getName());
            if (kev == null) continue;
            v.setKnownExploitedVulnerability(kev);
        }
    }
}

