/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.dependencycheck.data.update;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import javax.annotation.concurrent.ThreadSafe;
import org.owasp.dependencycheck.Engine;
import org.owasp.dependencycheck.data.update.CachedWebDataSource;
import org.owasp.dependencycheck.data.update.exception.UpdateException;
import org.owasp.dependencycheck.exception.WriteLockException;
import org.owasp.dependencycheck.utils.Downloader;
import org.owasp.dependencycheck.utils.ResourceNotFoundException;
import org.owasp.dependencycheck.utils.Settings;
import org.owasp.dependencycheck.utils.TooManyRequestsException;
import org.owasp.dependencycheck.utils.WriteLock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
public class RetireJSDataSource
implements CachedWebDataSource {
    private static final Logger LOGGER = LoggerFactory.getLogger(RetireJSDataSource.class);
    public static final String RETIREJS_UPDATED_ON = "RetireJSUpdatedOn";
    private Settings settings;
    public static final String DEFAULT_JS_URL = "https://raw.githubusercontent.com/Retirejs/retire.js/master/repository/jsrepository.json";

    @Override
    public boolean update(Engine engine) throws UpdateException {
        this.settings = engine.getSettings();
        String configuredUrl = this.settings.getString("analyzer.retirejs.repo.js.url", DEFAULT_JS_URL);
        boolean autoupdate = this.settings.getBoolean("odc.autoupdate", true);
        boolean forceupdate = this.settings.getBoolean("analyzer.retirejs.forceupdate", false);
        boolean enabled = this.settings.getBoolean("analyzer.retirejs.enabled", true);
        try {
            boolean proceed;
            URL url = new URL(configuredUrl);
            File filepath = new File(url.getPath());
            File repoFile = new File(this.settings.getDataDirectory(), filepath.getName());
            boolean bl = proceed = enabled && (forceupdate || autoupdate && this.shouldUpdate(repoFile));
            if (proceed) {
                LOGGER.debug("Begin RetireJS Update");
                this.initializeRetireJsRepo(this.settings, url, repoFile);
            }
        }
        catch (MalformedURLException ex) {
            throw new UpdateException(String.format("Invalid URL for RetireJS repository (%s)", configuredUrl), ex);
        }
        catch (IOException ex) {
            throw new UpdateException("Unable to get the data directory", ex);
        }
        return false;
    }

    protected boolean shouldUpdate(File repo) throws NumberFormatException {
        boolean proceed = true;
        if (repo != null && repo.isFile()) {
            int validForHours = this.settings.getInt("analyzer.retirejs.repo.validforhours", 0);
            long lastUpdatedOn = repo.lastModified();
            long now = System.currentTimeMillis();
            LOGGER.debug("Last updated: {}", (Object)lastUpdatedOn);
            LOGGER.debug("Now: {}", (Object)now);
            long msValid = (long)validForHours * 60L * 60L * 1000L;
            boolean bl = proceed = now - lastUpdatedOn > msValid;
            if (!proceed) {
                LOGGER.info("Skipping RetireJS update since last update was within {} hours.", (Object)validForHours);
            }
        }
        return proceed;
    }

    private void initializeRetireJsRepo(Settings settings, URL repoUrl, File repoFile) throws UpdateException {
        try (WriteLock lock = new WriteLock(settings, true, repoFile.getName() + ".lock");){
            LOGGER.debug("RetireJS Repo URL: {}", (Object)repoUrl.toExternalForm());
            Downloader downloader = new Downloader(settings);
            downloader.fetchFile(repoUrl, repoFile, "analyzer.retirejs.repo.js.username", "analyzer.retirejs.repo.js.password");
        }
        catch (IOException | WriteLockException | ResourceNotFoundException | TooManyRequestsException ex) {
            throw new UpdateException("Failed to initialize the RetireJS repo", ex);
        }
    }

    @Override
    public boolean purge(Engine engine) {
        boolean result;
        block16: {
            this.settings = engine.getSettings();
            result = true;
            try {
                File dataDir = engine.getSettings().getDataDirectory();
                URL repoUrl = new URL(engine.getSettings().getString("analyzer.retirejs.repo.js.url", DEFAULT_JS_URL));
                String filename = repoUrl.getFile().substring(repoUrl.getFile().lastIndexOf("/") + 1);
                File repo = new File(dataDir, filename);
                if (!repo.exists()) break block16;
                try (WriteLock lock = new WriteLock(this.settings, true, filename + ".lock");){
                    if (repo.delete()) {
                        LOGGER.info("RetireJS repo removed successfully");
                    } else {
                        LOGGER.error("Unable to delete '{}'; please delete the file manually", (Object)repo.getAbsolutePath());
                        result = false;
                    }
                }
            }
            catch (IOException | WriteLockException ex) {
                LOGGER.error("Unable to delete the RetireJS repo - invalid configuration");
                result = false;
            }
        }
        return result;
    }
}

