/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.dependencycheck.maven;

import java.util.Locale;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.owasp.dependencycheck.Engine;
import org.owasp.dependencycheck.exception.ExceptionCollection;
import org.owasp.dependencycheck.maven.BaseDependencyCheckMojo;

@Mojo(name="check", defaultPhase=LifecyclePhase.VERIFY, threadSafe=true, requiresDependencyResolution=ResolutionScope.COMPILE_PLUS_RUNTIME, requiresOnline=true)
public class CheckMojo
extends BaseDependencyCheckMojo {
    @Parameter(property="name", defaultValue="dependency-check", required=true)
    private String name = "dependency-check";

    public boolean canGenerateReport() {
        this.populateSettings();
        boolean isCapable = false;
        for (Artifact a : this.getProject().getArtifacts()) {
            if (this.getArtifactScopeExcluded().passes((Object)a.getScope())) continue;
            isCapable = true;
            break;
        }
        return isCapable;
    }

    public String getName(Locale locale) {
        return this.name;
    }

    public String getDescription(Locale locale) {
        return "Generates a report providing details on any published vulnerabilities within project dependencies. This report is a best effort and may contain false positives and false negatives.";
    }

    @Override
    protected ExceptionCollection scanDependencies(Engine engine) throws MojoExecutionException {
        return this.scanArtifacts(this.getProject(), engine);
    }
}

