/*
 * Decompiled with CFR 0.152.
 */
package org.pac4j.cas.redirect;

import org.jasig.cas.client.util.CommonUtils;
import org.pac4j.cas.config.CasConfiguration;
import org.pac4j.core.context.WebContext;
import org.pac4j.core.exception.HttpAction;
import org.pac4j.core.redirect.RedirectAction;
import org.pac4j.core.redirect.RedirectActionBuilder;
import org.pac4j.core.util.CommonHelper;
import org.pac4j.core.util.InitializableWebObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CasRedirectActionBuilder
extends InitializableWebObject
implements RedirectActionBuilder {
    private static final Logger logger = LoggerFactory.getLogger(CasRedirectActionBuilder.class);
    protected final CasConfiguration configuration;
    private final String callbackUrl;

    public CasRedirectActionBuilder(CasConfiguration configuration, String callbackUrl) {
        this.configuration = configuration;
        this.callbackUrl = callbackUrl;
    }

    protected void internalInit(WebContext context) {
        CommonHelper.assertNotBlank((String)"callbackUrl", (String)this.callbackUrl);
        CommonHelper.assertNotNull((String)"configuration", (Object)((Object)this.configuration));
        this.configuration.init(context);
    }

    public RedirectAction redirect(WebContext context) throws HttpAction {
        this.init(context);
        String computeLoginUrl = this.configuration.computeFinalLoginUrl(context);
        String computedCallbackUrl = this.configuration.computeFinalUrl(this.callbackUrl, context);
        String redirectionUrl = CommonUtils.constructRedirectUrl((String)computeLoginUrl, (String)"service", (String)computedCallbackUrl, (boolean)this.configuration.isRenew(), (boolean)this.configuration.isGateway());
        logger.debug("redirectionUrl: {}", (Object)redirectionUrl);
        return RedirectAction.redirect((String)redirectionUrl);
    }
}

