/*
 * Decompiled with CFR 0.152.
 */
package org.pac4j.config.builder;

import java.util.Map;

public abstract class AbstractBuilder {
    protected static final int MAX_NUM_CLIENTS = 10;
    protected final Map<String, String> properties;

    protected AbstractBuilder(Map<String, String> properties) {
        this.properties = properties;
    }

    protected String concat(String value, int num) {
        return value.concat(num == 0 ? "" : "." + num);
    }

    protected String getProperty(String name) {
        return this.properties.get(name);
    }

    protected String getProperty(String name, int num) {
        return this.getProperty(this.concat(name, num));
    }

    protected boolean containsProperty(String name, int num) {
        return this.properties.containsKey(this.concat(name, num));
    }

    protected boolean getPropertyAsBoolean(String name, int num) {
        return Boolean.valueOf(this.getProperty(name, num));
    }

    protected int getPropertyAsInteger(String name, int num) {
        return Integer.parseInt(this.getProperty(name, num));
    }

    protected long getPropertyAsLong(String name, int num) {
        return Long.parseLong(this.getProperty(name, num));
    }
}

