/*
 * Decompiled with CFR 0.152.
 */
package org.pac4j.config.builder;

import java.util.List;
import java.util.Map;
import org.pac4j.config.builder.AbstractBuilder;
import org.pac4j.config.client.PropertiesConstants;
import org.pac4j.core.client.Client;
import org.pac4j.core.credentials.authenticator.Authenticator;
import org.pac4j.core.util.CommonHelper;
import org.pac4j.http.client.indirect.FormClient;
import org.pac4j.http.client.indirect.IndirectBasicAuthClient;
import org.pac4j.http.credentials.authenticator.test.SimpleTestTokenAuthenticator;
import org.pac4j.http.credentials.authenticator.test.SimpleTestUsernamePasswordAuthenticator;

public class IndirectHttpClientBuilder
extends AbstractBuilder
implements PropertiesConstants {
    private final Map<String, Authenticator> authenticators;

    public IndirectHttpClientBuilder(Map<String, String> properties, Map<String, Authenticator> authenticators) {
        super(properties);
        this.authenticators = authenticators;
    }

    public void tryCreateLoginFormClient(List<Client> clients) {
        for (int i = 0; i <= 10; ++i) {
            String loginUrl = this.getProperty("formClient.loginUrl", i);
            String authenticator = this.getProperty("formClient.authenticator", i);
            if (!CommonHelper.isNotBlank((String)loginUrl) || !CommonHelper.isNotBlank((String)authenticator)) continue;
            FormClient formClient = new FormClient();
            formClient.setLoginUrl(loginUrl);
            formClient.setAuthenticator(this.getAuthenticator(authenticator));
            if (this.containsProperty("formClient.usernameParameter", i)) {
                formClient.setUsernameParameter(this.getProperty("formClient.usernameParameter", i));
            }
            if (this.containsProperty("formClient.passwordParameter", i)) {
                formClient.setPasswordParameter(this.getProperty("formClient.passwordParameter", i));
            }
            if (i != 0) {
                formClient.setName(this.concat(formClient.getName(), i));
            }
            clients.add((Client)formClient);
        }
    }

    public void tryCreateIndirectBasciAuthClient(List<Client> clients) {
        for (int i = 0; i <= 10; ++i) {
            String authenticator = this.getProperty("indirectBasicAuth.authenticator", i);
            if (!CommonHelper.isNotBlank((String)authenticator)) continue;
            IndirectBasicAuthClient indirectBasicAuthClient = new IndirectBasicAuthClient();
            indirectBasicAuthClient.setAuthenticator(this.getAuthenticator(authenticator));
            if (this.containsProperty("indirectBasicAuth.realName", i)) {
                indirectBasicAuthClient.setRealmName(this.getProperty("indirectBasicAuth.realName", i));
            }
            if (i != 0) {
                indirectBasicAuthClient.setName(this.concat(indirectBasicAuthClient.getName(), i));
            }
            clients.add((Client)indirectBasicAuthClient);
        }
    }

    protected Authenticator getAuthenticator(String name) {
        if ("testToken".equals(name)) {
            return new SimpleTestTokenAuthenticator();
        }
        if ("testUsernamePassword".equals(name)) {
            return new SimpleTestUsernamePasswordAuthenticator();
        }
        return this.authenticators.get(name);
    }
}

