/*
 * Decompiled with CFR 0.152.
 */
package org.pac4j.core.authorization.authorizer.csrf;

import java.util.List;
import org.pac4j.core.authorization.authorizer.Authorizer;
import org.pac4j.core.authorization.authorizer.csrf.CsrfTokenGenerator;
import org.pac4j.core.context.Cookie;
import org.pac4j.core.context.WebContext;
import org.pac4j.core.exception.HttpAction;
import org.pac4j.core.profile.CommonProfile;
import org.pac4j.core.util.CommonHelper;

public class CsrfTokenGeneratorAuthorizer
implements Authorizer<CommonProfile> {
    private CsrfTokenGenerator csrfTokenGenerator;
    private String domain;
    private String path = "/";
    private Boolean httpOnly;
    private Boolean secure;

    public CsrfTokenGeneratorAuthorizer(CsrfTokenGenerator csrfTokenGenerator) {
        this.csrfTokenGenerator = csrfTokenGenerator;
    }

    @Override
    public boolean isAuthorized(WebContext context, List<CommonProfile> profiles) throws HttpAction {
        CommonHelper.assertNotNull("csrfTokenGenerator", this.csrfTokenGenerator);
        String token = this.csrfTokenGenerator.get(context);
        context.setRequestAttribute("pac4jCsrfToken", token);
        Cookie cookie = new Cookie("pac4jCsrfToken", token);
        if (this.domain != null) {
            cookie.setDomain(this.domain);
        } else {
            cookie.setDomain(context.getServerName());
        }
        if (this.path != null) {
            cookie.setPath(this.path);
        }
        if (this.httpOnly != null) {
            cookie.setHttpOnly(this.httpOnly);
        }
        if (this.secure != null) {
            cookie.setSecure(this.secure);
        }
        context.addResponseCookie(cookie);
        return true;
    }

    public CsrfTokenGenerator getCsrfTokenGenerator() {
        return this.csrfTokenGenerator;
    }

    public void setCsrfTokenGenerator(CsrfTokenGenerator csrfTokenGenerator) {
        this.csrfTokenGenerator = csrfTokenGenerator;
    }

    public String getDomain() {
        return this.domain;
    }

    public void setDomain(String domain) {
        this.domain = domain;
    }

    public String getPath() {
        return this.path;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public Boolean getHttpOnly() {
        return this.httpOnly;
    }

    public void setHttpOnly(Boolean httpOnly) {
        this.httpOnly = httpOnly;
    }

    public Boolean getSecure() {
        return this.secure;
    }

    public void setSecure(Boolean secure) {
        this.secure = secure;
    }

    public String toString() {
        return CommonHelper.toString(this.getClass(), "csrfTokenGenerator", this.csrfTokenGenerator, "domain", this.domain, "path", this.path, "httpOnly", this.httpOnly, "secure", this.secure);
    }
}

