/*
 * Decompiled with CFR 0.152.
 */
package org.pac4j.core.client;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.pac4j.core.authorization.generator.AuthorizationGenerator;
import org.pac4j.core.client.Client;
import org.pac4j.core.context.WebContext;
import org.pac4j.core.credentials.Credentials;
import org.pac4j.core.credentials.authenticator.Authenticator;
import org.pac4j.core.credentials.extractor.CredentialsExtractor;
import org.pac4j.core.exception.CredentialsException;
import org.pac4j.core.exception.HttpAction;
import org.pac4j.core.profile.CommonProfile;
import org.pac4j.core.profile.UserProfile;
import org.pac4j.core.profile.creator.AuthenticatorProfileCreator;
import org.pac4j.core.profile.creator.ProfileCreator;
import org.pac4j.core.util.CommonHelper;
import org.pac4j.core.util.InitializableWebObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BaseClient<C extends Credentials, U extends CommonProfile>
extends InitializableWebObject
implements Client<C, U> {
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    private String name;
    private List<AuthorizationGenerator<U>> authorizationGenerators = new ArrayList<AuthorizationGenerator<U>>();
    private CredentialsExtractor<C> credentialsExtractor;
    private Authenticator<C> authenticator;
    private ProfileCreator<C, U> profileCreator = AuthenticatorProfileCreator.INSTANCE;

    protected C retrieveCredentials(WebContext context) throws HttpAction {
        try {
            C credentials = this.credentialsExtractor.extract(context);
            if (credentials == null) {
                return null;
            }
            this.authenticator.validate(credentials, context);
            return credentials;
        }
        catch (CredentialsException e) {
            this.logger.info("Failed to retrieve or validate credentials: {}", (Object)e.getMessage());
            this.logger.debug("Failed to retrieve or validate credentials", (Throwable)e);
            return null;
        }
    }

    @Override
    public final U getUserProfile(C credentials, WebContext context) throws HttpAction {
        this.init(context);
        this.logger.debug("credentials : {}", credentials);
        if (credentials == null) {
            return null;
        }
        U profile = this.retrieveUserProfile(credentials, context);
        if (profile != null) {
            ((UserProfile)profile).setClientName(this.getName());
            if (this.authorizationGenerators != null) {
                for (AuthorizationGenerator<U> authorizationGenerator : this.authorizationGenerators) {
                    profile = authorizationGenerator.generate(context, profile);
                }
            }
        }
        return profile;
    }

    protected final U retrieveUserProfile(C credentials, WebContext context) throws HttpAction {
        U profile = this.profileCreator.create(credentials, context);
        this.logger.debug("profile: {}", profile);
        return profile;
    }

    public void setName(String name) {
        this.name = name;
    }

    @Override
    public String getName() {
        if (CommonHelper.isBlank(this.name)) {
            return this.getClass().getSimpleName();
        }
        return this.name;
    }

    public void notifySessionRenewal(String oldSessionId, WebContext context) {
    }

    public List<AuthorizationGenerator<U>> getAuthorizationGenerators() {
        return this.authorizationGenerators;
    }

    public void setAuthorizationGenerators(List<AuthorizationGenerator<U>> authorizationGenerators) {
        CommonHelper.assertNotNull("authorizationGenerators", authorizationGenerators);
        this.authorizationGenerators = authorizationGenerators;
    }

    public void setAuthorizationGenerators(AuthorizationGenerator<U> ... authorizationGenerators) {
        CommonHelper.assertNotNull("authorizationGenerators", authorizationGenerators);
        this.authorizationGenerators = Arrays.asList(authorizationGenerators);
    }

    public void setAuthorizationGenerator(AuthorizationGenerator<U> authorizationGenerator) {
        this.addAuthorizationGenerator(authorizationGenerator);
    }

    public void addAuthorizationGenerator(AuthorizationGenerator<U> authorizationGenerator) {
        CommonHelper.assertNotNull("authorizationGenerator", authorizationGenerator);
        this.authorizationGenerators.add(authorizationGenerator);
    }

    public void addAuthorizationGenerators(List<AuthorizationGenerator<U>> authorizationGenerators) {
        CommonHelper.assertNotNull("authorizationGenerators", authorizationGenerators);
        this.authorizationGenerators.addAll(authorizationGenerators);
    }

    public CredentialsExtractor<C> getCredentialsExtractor() {
        return this.credentialsExtractor;
    }

    protected void defaultCredentialsExtractor(CredentialsExtractor<C> credentialsExtractor) {
        if (this.credentialsExtractor == null) {
            this.credentialsExtractor = credentialsExtractor;
        }
    }

    public Authenticator<C> getAuthenticator() {
        return this.authenticator;
    }

    protected void defaultAuthenticator(Authenticator<C> authenticator) {
        if (this.authenticator == null) {
            this.authenticator = authenticator;
        }
    }

    public ProfileCreator<C, U> getProfileCreator() {
        return this.profileCreator;
    }

    protected void defaultProfileCreator(ProfileCreator<C, U> profileCreator) {
        if (this.profileCreator == null || this.profileCreator == AuthenticatorProfileCreator.INSTANCE) {
            this.profileCreator = profileCreator;
        }
    }

    public void setCredentialsExtractor(CredentialsExtractor<C> credentialsExtractor) {
        this.credentialsExtractor = credentialsExtractor;
    }

    public void setAuthenticator(Authenticator<C> authenticator) {
        this.authenticator = authenticator;
    }

    public void setProfileCreator(ProfileCreator<C, U> profileCreator) {
        this.profileCreator = profileCreator;
    }

    public String toString() {
        return CommonHelper.toString(this.getClass(), "name", this.getName(), "credentialsExtractor", this.credentialsExtractor, "authenticator", this.authenticator, "profileCreator", this.profileCreator, "authorizationGenerators", this.authorizationGenerators);
    }
}

