/*
 * Decompiled with CFR 0.152.
 */
package org.pac4j.core.credentials.extractor;

import org.pac4j.core.context.WebContext;
import org.pac4j.core.credentials.UsernamePasswordCredentials;
import org.pac4j.core.credentials.extractor.CredentialsExtractor;
import org.pac4j.core.exception.HttpAction;

public class FormExtractor
implements CredentialsExtractor<UsernamePasswordCredentials> {
    private final String usernameParameter;
    private final String passwordParameter;
    private final String clientName;

    public FormExtractor(String usernameParameter, String passwordParameter, String clientName) {
        this.usernameParameter = usernameParameter;
        this.passwordParameter = passwordParameter;
        this.clientName = clientName;
    }

    @Override
    public UsernamePasswordCredentials extract(WebContext context) throws HttpAction {
        String username = context.getRequestParameter(this.usernameParameter);
        String password = context.getRequestParameter(this.passwordParameter);
        if (username == null || password == null) {
            return null;
        }
        return new UsernamePasswordCredentials(username, password, this.clientName);
    }

    public String getUsernameParameter() {
        return this.usernameParameter;
    }

    public String getPasswordParameter() {
        return this.passwordParameter;
    }
}

