/*
 * Decompiled with CFR 0.152.
 */
package org.pac4j.core.engine;

import java.util.List;
import java.util.regex.Pattern;
import org.pac4j.core.client.Client;
import org.pac4j.core.client.Clients;
import org.pac4j.core.config.Config;
import org.pac4j.core.context.WebContext;
import org.pac4j.core.context.session.SessionStore;
import org.pac4j.core.engine.LogoutLogic;
import org.pac4j.core.exception.HttpAction;
import org.pac4j.core.http.HttpActionAdapter;
import org.pac4j.core.profile.CommonProfile;
import org.pac4j.core.profile.ProfileManager;
import org.pac4j.core.profile.ProfileManagerFactoryAware;
import org.pac4j.core.redirect.RedirectAction;
import org.pac4j.core.util.CommonHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultLogoutLogic<R, C extends WebContext>
extends ProfileManagerFactoryAware<C>
implements LogoutLogic<R, C> {
    protected Logger logger = LoggerFactory.getLogger(this.getClass());

    @Override
    public R perform(C context, Config config, HttpActionAdapter<R, C> httpActionAdapter, String defaultUrl, String inputLogoutUrlPattern, Boolean inputLocalLogout, Boolean inputDestroySession, Boolean inputCentralLogout) {
        this.logger.debug("=== LOGOUT ===");
        String logoutUrlPattern = inputLogoutUrlPattern == null ? "/.*" : inputLogoutUrlPattern;
        boolean localLogout = inputLocalLogout == null ? true : inputLocalLogout;
        boolean destroySession = inputDestroySession == null ? false : inputDestroySession;
        boolean centralLogout = inputCentralLogout == null ? false : inputCentralLogout;
        CommonHelper.assertNotNull("context", context);
        CommonHelper.assertNotNull("config", config);
        CommonHelper.assertNotNull("httpActionAdapter", httpActionAdapter);
        CommonHelper.assertNotBlank("logoutUrlPattern", logoutUrlPattern);
        Clients configClients = config.getClients();
        CommonHelper.assertNotNull("configClients", configClients);
        ProfileManager manager = this.getProfileManager(context, config);
        List profiles = manager.getAll(true);
        String url = context.getRequestParameter("url");
        String redirectUrl = defaultUrl;
        if (url != null && Pattern.matches(logoutUrlPattern, url)) {
            redirectUrl = url;
        }
        this.logger.debug("redirectUrl: {}", (Object)redirectUrl);
        HttpAction action = redirectUrl != null ? HttpAction.redirect("redirect", context, redirectUrl) : HttpAction.ok("ok", context);
        if (localLogout || profiles.size() > 1) {
            this.logger.debug("Performing application logout");
            manager.logout();
            if (destroySession) {
                SessionStore sessionStore = context.getSessionStore();
                if (sessionStore != null) {
                    boolean removed = sessionStore.destroySession(context);
                    if (!removed) {
                        this.logger.error("Unable to destroy the web session. The session store may not support this feature");
                    }
                } else {
                    this.logger.error("No session store available for this web context");
                }
            }
        }
        if (centralLogout) {
            this.logger.debug("Performing central logout");
            for (CommonProfile profile : profiles) {
                Client client;
                this.logger.debug("Profile: {}", (Object)profile);
                String clientName = profile.getClientName();
                if (clientName == null || (client = configClients.findClient(clientName)) == null) continue;
                String targetUrl = redirectUrl != null && (redirectUrl.startsWith("http") || redirectUrl.startsWith("https")) ? redirectUrl : null;
                RedirectAction logoutAction = client.getLogoutAction((WebContext)context, profile, targetUrl);
                this.logger.debug("Logout action: {}", (Object)logoutAction);
                if (logoutAction == null) continue;
                action = logoutAction.perform((WebContext)context);
                break;
            }
        }
        return httpActionAdapter.adapt(action.getCode(), context);
    }
}

