/*
 * Decompiled with CFR 0.152.
 */
package org.pac4j.core.exception;

import org.pac4j.core.context.WebContext;
import org.pac4j.core.util.CommonHelper;

public class HttpAction
extends Exception {
    private static final long serialVersionUID = -3959659239684160075L;
    protected int code;

    private HttpAction(String message, int code) {
        super(message);
        this.code = code;
    }

    public static HttpAction status(String message, int status, WebContext context) {
        context.setResponseStatus(status);
        return new HttpAction(message, status);
    }

    public static HttpAction redirect(String message, WebContext context, String url) {
        context.setResponseHeader("Location", url);
        context.setResponseStatus(302);
        return new HttpAction(message, 302);
    }

    public static HttpAction ok(String message, WebContext context) {
        return HttpAction.ok(message, context, "");
    }

    public static HttpAction ok(String message, WebContext context, String content) {
        context.setResponseStatus(200);
        context.writeResponseContent(content);
        return new HttpAction(message, 200);
    }

    public static HttpAction unauthorized(String message, WebContext context, String realmName) {
        if (CommonHelper.isNotBlank(realmName)) {
            context.setResponseHeader("WWW-Authenticate", "Basic realm=\"" + realmName + "\"");
        }
        context.setResponseStatus(401);
        return new HttpAction(message, 401);
    }

    public static HttpAction unauthorizedDigest(String message, WebContext context, String realmName, String qop, String nonce) {
        if (CommonHelper.isNotBlank(realmName)) {
            context.setResponseHeader("WWW-Authenticate", "Digest realm=\"" + realmName + "\", qop=\"" + qop + "\", nonce=\"" + nonce + "\"");
        }
        context.setResponseStatus(401);
        return new HttpAction(message, 401);
    }

    public static HttpAction forbidden(String message, WebContext context) {
        context.setResponseStatus(403);
        return new HttpAction(message, 403);
    }

    public int getCode() {
        return this.code;
    }

    @Override
    public String toString() {
        return CommonHelper.toString(HttpAction.class, "code", this.code);
    }
}

